/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.comm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.sql.RowSet;
import lasige.divdb.jdbc.BFTRowSet;

public class Message
implements Serializable {
    private static final long serialVersionUID = -137793546194980087L;
    private int opcode;
    private boolean unordered;
    private Object content;
    private int statementOption;
    private RowSet rowSet;
    private int clientId;
    protected int operationId;
    protected final int master;

    public Message(int opcode, Object content, boolean unordered) {
        this.opcode = opcode;
        this.content = content;
        this.unordered = unordered;
        this.master = 0;
    }

    public Message(int opcode, Object content, boolean unordered, int master) {
        this.opcode = opcode;
        this.content = content;
        this.unordered = unordered;
        this.master = master;
    }

    public Message(int opcode, Object content, boolean unordered, int master, int statementOption) {
        this(opcode, content, unordered, master);
        this.statementOption = statementOption;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream bStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oStream = new ObjectOutputStream(bStream);
            oStream.writeObject(this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] byteVal = bStream.toByteArray();
        return byteVal;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public Object getContents() {
        return this.content;
    }

    public boolean isUnordered() {
        return this.unordered;
    }

    public static Message getMessage(byte[] bytes) {
        Message m = null;
        try {
            ByteArrayInputStream bStream = new ByteArrayInputStream(bytes);
            ObjectInputStream oStream = new ObjectInputStream(bStream);
            m = (Message)oStream.readObject();
            Object obj = m.getContents();
            if (obj instanceof BFTRowSet) {
                ((BFTRowSet)obj).loadResourceBundle();
            }
            bStream.close();
            oStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return m;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{opcode: " + this.opcode + ", ");
        if (this.content == null) {
            sb.append("content: NULL, ");
        } else {
            sb.append("content: " + this.content.toString() + ", ");
        }
        sb.append("Unordered: " + Boolean.toString(this.unordered) + " }");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        result = 31 * result + this.opcode;
        result = 31 * result + (this.unordered ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message)obj;
        if (this.content == null ? other.content != null : !this.content.equals(other.content)) {
            return false;
        }
        if (this.opcode != other.opcode) {
            return false;
        }
        return this.unordered == other.unordered;
    }

    public int getStatementOption() {
        return this.statementOption;
    }

    public void setStatementOption(int statementOption) {
        this.statementOption = statementOption;
    }

    public RowSet getRowSet() {
        return this.rowSet;
    }

    public void setRowset(RowSet rowSet) {
        this.rowSet = rowSet;
    }

    public void setClientId(int clientId) throws Exception {
        if (this.clientId > 0) {
            throw new Exception("Client id already set");
        }
        this.clientId = clientId;
    }

    public int getClientId() {
        return this.clientId;
    }

    public int getOperationId() {
        return this.operationId;
    }

    public int getMaster() {
        return this.master;
    }
}

