/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.client;

import bftsmart.communication.client.ReplyListener;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.Extractor;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class SteelDBListener
implements ReplyListener {
    private ReentrantLock canReceiveLock;
    private Comparator<byte[]> comparator;
    private Extractor extractor;
    private TOMMessage response;
    private Semaphore sm;
    private final Map<Integer, TOMMessage> replies;
    private boolean hasResult;
    private final int master;
    private Logger logger = Logger.getLogger((String)"divdb");

    public SteelDBListener(byte[] request, Comparator<byte[]> comparator, Extractor extractor) {
        this(request, comparator, extractor, 0);
    }

    public SteelDBListener(byte[] request, Comparator<byte[]> comparator, Extractor extractor, int master) {
        this.comparator = comparator;
        this.extractor = extractor;
        this.canReceiveLock = new ReentrantLock();
        this.replies = new HashMap<Integer, TOMMessage>();
        this.response = null;
        this.sm = new Semaphore(0);
        this.master = master;
    }

    public TOMMessage getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            if (!this.sm.tryAcquire(10L, TimeUnit.SECONDS)) {
                this.logger.debug((Object)"Couldn't get reply from server");
                return null;
            }
        }
        catch (InterruptedException ex) {
            this.logger.error((Object)ex.getMessage());
        }
        return this.response;
    }

    public void replyReceived(TOMMessage reply) {
        if (this.hasResult) {
            return;
        }
        this.canReceiveLock.lock();
        if (reply.getSender() == this.master) {
            this.response = reply;
        }
        this.hasResult = true;
        this.sm.release();
        this.canReceiveLock.unlock();
    }
}

