/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.client;

import bftsmart.communication.client.ReplyListener;
import bftsmart.tom.core.messages.TOMMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class StateRequestListener
implements ReplyListener {
    private ReentrantLock canReceiveLock;
    private int receivedReplies;
    private TOMMessage response;
    private Semaphore sm;
    private final int stateReplica;
    private final List<TOMMessage> replies;
    private boolean expectedReplied;
    private Logger logger = Logger.getLogger((String)"divdb");

    public StateRequestListener(byte[] request, int stateReplica) {
        this.canReceiveLock = new ReentrantLock();
        this.replies = new ArrayList<TOMMessage>();
        this.stateReplica = stateReplica;
        this.receivedReplies = 0;
        this.response = null;
        this.sm = new Semaphore(0);
    }

    public TOMMessage getResponse() {
        if (this.response != null) {
            return this.response;
        }
        try {
            if (!this.sm.tryAcquire(20L, TimeUnit.SECONDS)) {
                this.logger.debug((Object)"Couldn't get reply from server");
                return null;
            }
        }
        catch (InterruptedException ex) {
            this.logger.error((Object)ex.getMessage());
        }
        this.logger.debug((Object)("Response extracted = " + this.response));
        return this.response;
    }

    public void replyReceived(TOMMessage reply) {
        this.canReceiveLock.lock();
        this.logger.debug((Object)("Receiving reply from " + reply.getSender() + ". Expected sender replica: " + this.stateReplica));
        this.replies.add(reply);
        ++this.receivedReplies;
        if (reply.getSender() == this.stateReplica) {
            this.expectedReplied = true;
        }
        if (this.receivedReplies >= 2 && this.expectedReplied) {
            this.response = this.replies.get(0);
            this.sm.release();
        }
        this.canReceiveLock.unlock();
    }
}

