/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.Replica;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import lasige.divdb.Replica.ConnManager;
import lasige.divdb.comm.Message;
import lasige.divdb.statemanagement.ConnectionState;

public class SessionManager {
    private HashMap<Integer, ConnManager> clientMap;
    private String urlBase;

    public SessionManager(String url) {
        this.urlBase = url;
        this.clientMap = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnManager getConnManager(int clientId) {
        ConnManager cManager;
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            cManager = this.clientMap.get(clientId);
            if (cManager == null) {
                cManager = new ConnManager();
                this.clientMap.put(clientId, cManager);
            }
        }
        return cManager;
    }

    protected void enqueueOperation(Message m, int clientId) {
        ConnManager cManager = this.clientMap.get(clientId);
        cManager.enqueueOperation(m);
    }

    protected Queue<Message> getOperations(int clientId) {
        ConnManager cManager = this.clientMap.get(clientId);
        Queue<Message> queue = cManager.getTransactionQueue();
        cManager.clearTransaction();
        return queue;
    }

    protected boolean connect(int clientId, String database, String user, String pass) {
        return this.connect(clientId, database, user, pass, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean connect(int clientId, String database, String user, String pass, Queue<Message> transQueue) {
        ConnManager cManager;
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            cManager = this.clientMap.get(clientId);
            if (cManager == null) {
                cManager = new ConnManager();
                this.clientMap.put(clientId, cManager);
            }
        }
        boolean connected = cManager.connect(String.valueOf(this.urlBase) + database, user, pass);
        if (!connected) {
            this.clientMap.remove(clientId);
        } else if (transQueue != null) {
            cManager.setTransactionQueue(transQueue);
        }
        return connected;
    }

    protected void close(int clientId) throws SQLException {
        ConnManager cManager = this.clientMap.get(clientId);
        cManager.closeConn();
        this.clientMap.remove(clientId);
    }

    protected List<ConnectionState> getConnections() {
        ArrayList<ConnectionState> connections = new ArrayList<ConnectionState>();
        for (Integer key : this.clientMap.keySet()) {
            ConnManager manager = this.clientMap.get(key);
            ConnectionState connection = new ConnectionState(key, manager.getLogin(), manager.getTransactionQueue());
            connections.add(connection);
        }
        return connections;
    }

    protected void abortTransactions() {
        Set<Integer> keys = this.clientMap.keySet();
        for (Integer clientId : keys) {
            ConnManager conn = this.clientMap.get(clientId);
            if (!conn.isReadWriteTransaction()) continue;
            conn.abort();
        }
    }

    protected Map<Integer, Queue<Message>> getPendingOps() {
        TreeMap<Integer, Queue<Message>> transMap = new TreeMap<Integer, Queue<Message>>();
        for (Integer clientId : this.clientMap.keySet()) {
            Queue<Message> transQueue = this.getOperations(clientId);
            if (transQueue.size() <= 0) continue;
            transMap.put(clientId, transQueue);
        }
        return transMap;
    }
}

