/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.Replica;

import bftsmart.reconfiguration.views.View;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.SMMessage;
import bftsmart.statemanagement.StateManager;
import bftsmart.tom.MessageContext;
import bftsmart.tom.ReplicaContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.Executable;
import bftsmart.tom.server.Recoverable;
import bftsmart.tom.server.SingleExecutable;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lasige.divdb.Replica.ConnectionParams;
import lasige.divdb.Replica.MessageProcessor;
import lasige.divdb.comm.Message;
import lasige.divdb.statemanagement.ConnectionState;
import lasige.divdb.statemanagement.DatabaseState;
import lasige.divdb.statemanagement.DatabaseStateManager;
import org.apache.log4j.Logger;
import org.h2.tools.RunScript;
import org.h2.tools.Script;

public class Replica
implements Recoverable,
SingleExecutable {
    private int id;
    private MessageProcessor mProcessor = null;
    private ConnectionParams connParams = null;
    private ReplicaContext replicaContext;
    private StateManager stateManager;
    private Logger logger = Logger.getLogger((String)"divdb_replica");
    private int lastEid = -1;
    private ConcurrentMap<Integer, Integer> clientOperations;
    private Lock fifoLock = new ReentrantLock();
    int count = 0;

    public Replica(int id, Properties config) {
        new ServiceReplica(id, (Executable)this, (Recoverable)this);
        this.id = id;
        this.connParams = new ConnectionParams(config);
        this.mProcessor = new MessageProcessor(id, this.connParams.getDriver(), this.connParams.getUrl());
        View view = this.replicaContext.getCurrentView();
        this.mProcessor.setCurrentView(view);
        this.clientOperations = new ConcurrentHashMap<Integer, Integer>();
        this.logger.debug((Object)"Starting replica");
    }

    public synchronized byte[] executeOrdered(byte[] command, MessageContext msgCtx) {
        byte[] reply = null;
        Message m = Message.getMessage(command);
        Message replyMsg = null;
        this.logger.debug((Object)("ordered, " + m.getClientId() + ", " + m.getContents()));
        switch (m.getOpcode()) {
            case 96: {
                SMMessage smmsg = (SMMessage)m.getContents();
                if (smmsg.getSender() != this.id) {
                    this.stateManager.SMRequestDeliver(smmsg, true);
                }
                replyMsg = new Message(97, null, false);
                break;
            }
            case 200: {
                replyMsg = this.mProcessor.processExecute(m, m.getClientId());
                break;
            }
            case 230: {
                replyMsg = this.mProcessor.processExecuteBatch(m, m.getClientId());
                break;
            }
            case 220: {
                replyMsg = this.mProcessor.processExecuteQuery(m, m.getClientId());
                break;
            }
            case 210: {
                replyMsg = this.mProcessor.processExecuteUpdate(m, m.getClientId());
                break;
            }
            case 100: {
                replyMsg = this.mProcessor.processLogin(m, m.getClientId());
                break;
            }
            case 303: {
                replyMsg = this.mProcessor.processAutoCommit(m, m.getClientId());
                break;
            }
            case 300: {
                replyMsg = this.mProcessor.processCommit(m, m.getClientId());
                break;
            }
            case 400: {
                replyMsg = this.mProcessor.processRollback(m, m.getClientId());
                break;
            }
            case 90: {
                replyMsg = this.mProcessor.processSuspectMaster(m);
                break;
            }
            case 500: {
                replyMsg = this.mProcessor.processSetFetchSize(m, m.getClientId());
                break;
            }
            case 501: {
                replyMsg = this.mProcessor.processSetMaxRows(m, m.getClientId());
                break;
            }
            case 600: {
                replyMsg = this.mProcessor.processClose(m, m.getClientId());
                break;
            }
            case 700: {
                int clientId = m.getClientId();
                replyMsg = this.mProcessor.getDBMetadata(clientId);
                break;
            }
            default: {
                this.logger.debug((Object)("[Replica " + this.id + "] Unknown opcode received: " + m.getOpcode()));
            }
        }
        this.lastEid = msgCtx.getConsensusId();
        reply = replyMsg.getBytes();
        return reply;
    }

    public synchronized byte[] executeUnordered(byte[] command, MessageContext msgCtx) {
        byte[] replyBytes = null;
        Message reply = null;
        Message m = Message.getMessage(command);
        this.logger.debug((Object)("unordered, " + m.getClientId() + ", " + m.getContents()));
        switch (m.getOpcode()) {
            case 200: {
                reply = this.mProcessor.processExecute(m, m.getClientId());
            }
            case 500: {
                break;
            }
            case 230: {
                reply = this.mProcessor.processExecuteBatch(m, m.getClientId());
                break;
            }
            case 220: {
                reply = this.mProcessor.processExecuteQuery(m, m.getClientId());
                break;
            }
            case 210: {
                reply = this.mProcessor.processExecuteUpdate(m, m.getClientId());
                break;
            }
            case 303: {
                reply = this.mProcessor.processAutoCommit(m, m.getClientId());
                break;
            }
            case 90: {
                reply = this.mProcessor.processSuspectMaster(m);
                break;
            }
            default: {
                this.logger.debug((Object)("[Replica " + this.id + "] Unknown opcode received: " + m.getOpcode()));
            }
        }
        if (reply != null) {
            replyBytes = reply.getBytes();
        }
        return replyBytes;
    }

    private byte[] getSnapshot() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String dumpFile = "files/tmp" + this.id + ".sql";
        String urlWithDB = String.valueOf(this.connParams.getUrl()) + this.connParams.getDatabase();
        try {
            Script.execute((String)urlWithDB, (String)this.connParams.getUser(), (String)this.connParams.getPassword(), (OutputStream)baos);
        }
        catch (SQLException e) {
            this.logger.error((Object)"PROBLEM GETTING DUMP");
            e.printStackTrace();
        }
        byte[] dump = baos.toByteArray();
        this.logger.debug((Object)("--- TAKING CHECKPOINT. SIZE : " + dump.length));
        return dump;
    }

    private void installSnapshot(byte[] dump) {
        StringBuffer dropStatements = new StringBuffer();
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.REPORT CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.DTC CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.APPLICATION_SETTING CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.AUDIT_ACTION CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.CLIENT_ENTITY CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.EVENT CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.DISTRICT CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.DTC_SERVICE CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.ALARM CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.CONTROL CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.MUNICIPALITY CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.OPERATIONAL_AREA CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.PERIOD CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.PROFILE CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.SERVICE CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.SPECIAL_DAY CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.SPECIAL_DAY_SERVICE CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.TIMETABLE CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.DTC_STATE CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.SERVICE_STOPWATCH_REPORT CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.USER CASCADE;\n");
        dropStatements.append("DROP TABLE IF EXISTS PUBLIC.SERVICE_STOPWATCH CASCADE;\n");
        String urlWithDB = String.valueOf(this.connParams.getUrl()) + this.connParams.getDatabase();
        try {
            this.logger.debug((Object)"---INSTALLING SNAPSHOT");
            String ckpFileName = "files/dump_received.sql";
            File tmpckp = new File(ckpFileName);
            FileOutputStream fos = new FileOutputStream(tmpckp);
            fos.write(dropStatements.toString().getBytes());
            fos.flush();
            fos.write(dump);
            fos.flush();
            fos.close();
            RunScript.execute((String)urlWithDB, (String)this.connParams.getUser(), (String)this.connParams.getPassword(), (String)ckpFileName, (String)"UTF-8", (boolean)true);
            this.logger.debug((Object)"---INSTALLED");
        }
        catch (IOException | SQLException e) {
            this.logger.error((Object)"error installing dump", (Throwable)e);
        }
    }

    public void setReplicaContext(ReplicaContext replicaCtx) {
        this.replicaContext = replicaCtx;
    }

    public ApplicationState getState(int eid, boolean sendState) {
        sendState = false;
        if (this.mProcessor.getMaster() == this.id) {
            sendState = true;
        }
        this.logger.debug((Object)("STATE ASKED. SendState:" + sendState));
        byte[] dump = this.getSnapshot();
        this.logger.debug((Object)("Dump taken. Size: " + dump.length + " bytes. Send dump: " + sendState));
        List<ConnectionState> connStates = this.mProcessor.getConnections();
        for (ConnectionState connection : connStates) {
            connection.setLastOperation((Integer)this.clientOperations.get(connection.getClientId()));
        }
        DatabaseState dbState = sendState ? new DatabaseState(eid, dump, null, this.mProcessor.getMaster(), connStates) : new DatabaseState(eid, null, TOMUtil.computeHash((byte[])dump), this.mProcessor.getMaster(), connStates);
        return dbState;
    }

    public int setState(ApplicationState recvState) {
        int lastEid = -1;
        DatabaseState state = (DatabaseState)recvState;
        this.logger.debug((Object)("Last eid in state: " + state.getLastEid()));
        lastEid = state.getLastEid();
        this.installSnapshot(state.getSerializedState());
        this.logger.debug((Object)"--- OPENING CONNECIONS");
        this.mProcessor.restoreOpenConnections(state.getConnections());
        for (ConnectionState connection : state.getConnections()) {
            this.logger.debug((Object)("client " + connection.getClientId() + " last execution is " + connection.getLastOperation()));
            this.clientOperations.put(connection.getClientId(), connection.getLastOperation());
        }
        this.logger.debug((Object)"--- OPEN");
        this.logger.debug((Object)("RETURNING " + lastEid));
        return lastEid;
    }

    public StateManager getStateManager() {
        if (this.stateManager == null) {
            this.stateManager = new DatabaseStateManager();
        }
        return this.stateManager;
    }
}

