/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.Replica;

import bftsmart.reconfiguration.views.View;
import bftsmart.tom.util.TOMUtil;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import lasige.divdb.Replica.ConnManager;
import lasige.divdb.Replica.SessionManager;
import lasige.divdb.Replica.normalizaton.FirebirdNormalizer;
import lasige.divdb.Replica.normalizaton.NoNormalizer;
import lasige.divdb.Replica.normalizaton.Normalizer;
import lasige.divdb.comm.FinishTransactionRequest;
import lasige.divdb.comm.LoginRequest;
import lasige.divdb.comm.Message;
import lasige.divdb.comm.RollbackRequest;
import lasige.divdb.jdbc.BFTDatabaseMetaData;
import lasige.divdb.jdbc.BFTRowSet;
import lasige.divdb.jdbc.ResultSetData;
import lasige.divdb.statemanagement.ConnectionState;
import lasige.divdb.statemanagement.DBLoginParams;
import org.apache.log4j.Logger;

public class MessageProcessor {
    private int replicaId;
    private SessionManager sm;
    private int master;
    private Normalizer norm;
    private View currentView;
    private long lastMasterChange;
    private static Logger logger = Logger.getLogger((String)"divdb.execution");

    public MessageProcessor(int id, String driver, String url) {
        this.replicaId = id;
        this.norm = this.getNormalizer(driver);
        this.sm = new SessionManager(url);
        this.master = 0;
    }

    protected Message processExecute(Message m, int clientId) {
        ConnManager connManager = this.sm.getConnManager(clientId);
        String sql = (String)m.getContents();
        Message reply = null;
        if (connManager.isAborted()) {
            return new Message(94, null, false, this.master);
        }
        int content = 0;
        String normSql = this.norm.normalize(sql);
        try {
            Statement s = connManager.createStatement();
            if (s.execute(normSql)) {
                content = 1;
            }
            reply = new Message(201, content, false, this.master);
        }
        catch (SQLException sqle) {
            logger.error((Object)"processExecute() error", (Throwable)sqle);
            reply = new Message(202, null, false, this.master);
        }
        return reply;
    }

    protected Message processExecuteBatch(Message m, int clientId) {
        Message reply = null;
        ConnManager connManager = this.sm.getConnManager(clientId);
        if (connManager.isAborted()) {
            return new Message(94, null, false, this.master);
        }
        LinkedList batch = (LinkedList)m.getContents();
        try {
            Statement s = connManager.createStatement();
            logger.debug((Object)"processExecuteBatch() start");
            for (String sql : batch) {
                s.addBatch(sql);
                logger.debug((Object)("processExecuteBatch(): " + sql));
            }
            logger.debug((Object)"processExecuteBatch() end");
            int[] resultArray = s.executeBatch();
            ArrayList<Integer> result = new ArrayList<Integer>(resultArray.length);
            int i = 0;
            while (i < resultArray.length) {
                result.add(resultArray[i]);
                ++i;
            }
            reply = new Message(231, result, false, this.master);
        }
        catch (SQLException sqle) {
            logger.error((Object)"processExecuteBatch() error", (Throwable)sqle);
            reply = new Message(232, null, false, this.master);
        }
        return reply;
    }

    protected Message processExecuteQuery(Message m, int clientId) {
        Message reply = null;
        ConnManager connManager = this.sm.getConnManager(clientId);
        if (connManager.isAborted()) {
            return new Message(94, null, false, this.master);
        }
        String sql = (String)m.getContents();
        try {
            Statement s = connManager.createStatement();
            ResultSet rs = s.executeQuery(sql);
            ResultSetData rsd = new ResultSetData(rs);
            reply = new Message(221, rsd, true, this.master);
        }
        catch (SQLException sqle) {
            logger.error((Object)"processExecuteQuery() error", (Throwable)sqle);
            reply = new Message(222, null, true, this.master);
        }
        return reply;
    }

    protected Message processExecuteUpdate(Message m, int clientId) {
        ConnManager connManager = this.sm.getConnManager(clientId);
        if (connManager.isAborted()) {
            return new Message(94, null, false, this.master);
        }
        Message reply = null;
        String sql = (String)m.getContents();
        try {
            Statement s = connManager.createStatement();
            int result = -1;
            if (m.getStatementOption() > 0) {
                result = s.executeUpdate(sql, 1);
                BFTRowSet rowset = new BFTRowSet();
                rowset.populate(s.getGeneratedKeys());
                reply = new Message(211, result, false, this.master, 1);
                reply.setRowset(rowset);
            } else {
                result = s.executeUpdate(sql);
                reply = new Message(211, result, false, this.master);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"processExecuteUpdate() error", (Throwable)sqle);
            reply = new Message(212, null, false, this.master);
        }
        return reply;
    }

    protected Message processLogin(Message m, int clientId) {
        logger.debug((Object)("ProcessLogin. clientId: " + clientId));
        LoginRequest lr = (LoginRequest)m.getContents();
        String database = lr.getDatabase(this.replicaId);
        String user = lr.getUser(this.replicaId);
        String password = lr.getPassword(this.replicaId);
        Message reply = this.sm.connect(clientId, database, user, password) ? new Message(101, null, false, this.master) : new Message(102, null, false, this.master);
        return reply;
    }

    protected Message getDBMetadata(int clientId) {
        Message reply = null;
        ConnManager connManager = this.sm.getConnManager(clientId);
        try {
            logger.debug((Object)("connManager is not null: " + (connManager != null)));
            DatabaseMetaData dbm = connManager.getMetaData();
            BFTDatabaseMetaData bftDBM = new BFTDatabaseMetaData(dbm);
            reply = dbm != null ? new Message(701, bftDBM, false, this.master) : new Message(702, bftDBM, false, this.master);
            return reply;
        }
        catch (SQLException sqle) {
            logger.error((Object)"getDBMetadata() error: ", (Throwable)sqle);
            return new Message(702, null, false, this.master);
        }
    }

    protected Message processCommit(Message m, int clientId) {
        logger.debug((Object)("---- processCommit(): " + clientId));
        FinishTransactionRequest finishReq = (FinishTransactionRequest)m.getContents();
        LinkedList<byte[]> resHashes = finishReq.getResHashes();
        LinkedList<Message> operations = finishReq.getOperations();
        Message reply = null;
        if (operations != null && operations.size() > 0) {
            reply = this.processFinishTransaction(m, clientId, 300);
        }
        if (reply == null || reply.getOpcode() == 301) {
            try {
                ConnManager connManager = this.sm.getConnManager(clientId);
                connManager.commit();
                if (reply == null) {
                    reply = new Message(301, null, false, this.master);
                }
            }
            catch (SQLException sqle) {
                logger.error((Object)"processCommit() error", (Throwable)sqle);
                reply = new Message(302, null, true, this.master);
            }
        }
        return reply;
    }

    private Message processFinishTransaction(Message m, int clientId, int opcode) {
        logger.debug((Object)("--- Entering processFinishTransaction(). Client: " + clientId));
        ConnManager connManager = this.sm.getConnManager(clientId);
        Message reply = null;
        int opcodeError = 302;
        int opcodeOK = 301;
        if (opcode == 400) {
            opcodeError = 402;
            opcodeOK = 410;
        }
        if (this.master != this.replicaId) {
            FinishTransactionRequest finishReq = (FinishTransactionRequest)m.getContents();
            LinkedList<byte[]> resHashes = finishReq.getResHashes();
            LinkedList<Message> operations = finishReq.getOperations();
            if (operations.size() != resHashes.size()) {
                logger.error((Object)("Operations size differs from results: " + operations.size() + "," + resHashes.size()));
            }
            LinkedList<byte[]> results = new LinkedList<byte[]>();
            connManager.setCommitingTransaction(true);
            for (Message msg : operations) {
                switch (msg.getOpcode()) {
                    case 200: {
                        reply = this.processExecute(msg, clientId);
                        break;
                    }
                    case 230: {
                        reply = this.processExecuteBatch(msg, clientId);
                        break;
                    }
                    case 220: {
                        reply = this.processExecuteQuery(msg, clientId);
                        break;
                    }
                    case 210: {
                        reply = this.processExecuteUpdate(msg, clientId);
                        break;
                    }
                    default: {
                        reply = new Message(302, null, false, this.master);
                    }
                }
                Object replyContent = reply.getContents();
                byte[] replyBytes = null;
                replyBytes = TOMUtil.getBytes((Object)String.valueOf(replyContent));
                byte[] replyHash = TOMUtil.computeHash((byte[])replyBytes);
                results.add(replyHash);
            }
            if (!this.compareHashes(resHashes, results)) {
                logger.debug((Object)("## Results hashes don't match ##. Results.size(): " + results.size() + ", resHashes.size(): " + resHashes.size() + ", ops.size()" + operations.size()));
                reply = new Message(opcodeError, null, true, this.master);
            } else {
                logger.debug((Object)("### Results hashes matches. Results.size(): " + results.size()));
                reply = new Message(opcodeOK, null, false, this.master);
            }
        } else {
            reply = new Message(opcodeOK, null, false, this.master);
        }
        logger.debug((Object)"--- Exiting processFinishTransaction()");
        return reply;
    }

    protected Message processRollback(Message m, int clientId) {
        Message reply = null;
        RollbackRequest rollReq = (RollbackRequest)m.getContents();
        logger.debug((Object)("---- processRollback(). " + rollReq.getOldMaster() + " " + this.replicaId));
        if (rollReq.isMasterChanged()) {
            ConnManager connManager = this.sm.getConnManager(clientId);
            if (rollReq.getOldMaster() == this.replicaId) {
                try {
                    logger.debug((Object)"Rolling back the transaction in the old master");
                    connManager.rollback();
                }
                catch (SQLException sqle) {
                    logger.error((Object)"processRollback() error", (Throwable)sqle);
                    reply = new Message(402, null, false, this.master);
                    return reply;
                }
            } else {
                logger.debug((Object)"Reseting transaction properties");
                connManager.reset();
            }
            reply = new Message(410, null, false, this.master);
        } else {
            FinishTransactionRequest finishReq = rollReq.getFinishReq();
            if (finishReq.getOperations() != null && finishReq.getOperations().size() > 0) {
                m = new Message(400, rollReq.getFinishReq(), false);
                reply = this.processFinishTransaction(m, clientId, 400);
            }
            if (reply == null || reply.getOpcode() == 410) {
                try {
                    ConnManager connManager = this.sm.getConnManager(clientId);
                    connManager.rollback();
                    if (reply == null) {
                        reply = new Message(410, null, false, this.master);
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Object)"processRollback() error", (Throwable)sqle);
                    reply = new Message(402, null, true, this.master);
                }
            }
        }
        return reply;
    }

    protected Message processAutoCommit(Message m, int clientId) {
        Message reply = null;
        boolean autoCommit = (Boolean)m.getContents();
        ConnManager connManager = this.sm.getConnManager(clientId);
        logger.debug((Object)("processAutoCommit(). ClientId: " + clientId + ", autocommit: " + autoCommit));
        try {
            connManager.setAutoCommit(autoCommit);
            reply = new Message(304, null, true, this.master);
        }
        catch (SQLException sqle) {
            logger.error((Object)"processAutoCommit() error", (Throwable)sqle);
            reply = new Message(305, null, true, this.master);
        }
        return reply;
    }

    public Message processSuspectMaster(Message m) {
        Message reply;
        long secondsSinceLastMC = System.currentTimeMillis() - this.lastMasterChange;
        logger.debug((Object)("processSuspectMaster() called by client " + m.getClientId()));
        if (secondsSinceLastMC > 60000L) {
            boolean opsOk;
            this.lastMasterChange = System.currentTimeMillis();
            this.master = (this.master + 1) % this.currentView.getN();
            logger.debug((Object)("processSuspectMaster(). Old: " + m.getContents() + ". New: " + this.master));
            reply = this.master == this.replicaId ? ((opsOk = this.executePendingOps()) ? new Message(91, this.master, true, this.master) : new Message(92, this.master, true, this.master)) : new Message(91, this.master, true, this.master);
        } else {
            reply = new Message(91, this.master, true, this.master);
        }
        return reply;
    }

    private boolean executePendingOps() {
        Map<Integer, Queue<Message>> pendingOps = this.sm.getPendingOps();
        for (Integer clientId : pendingOps.keySet()) {
            Queue<Message> ops = this.sm.getOperations(clientId);
            Message reply = null;
            logger.debug((Object)"Master change: executing pending ops in the new master");
            block7: for (Message msg : ops) {
                switch (msg.getOpcode()) {
                    case 200: {
                        reply = this.processExecute(msg, clientId);
                        if (reply.getOperationId() != 202) continue block7;
                        return false;
                    }
                    case 230: {
                        reply = this.processExecuteBatch(msg, clientId);
                        if (reply.getOperationId() != 232) continue block7;
                        return false;
                    }
                    case 220: {
                        reply = this.processExecuteQuery(msg, clientId);
                        if (reply.getOperationId() != 222) continue block7;
                        return false;
                    }
                    case 210: {
                        reply = this.processExecuteUpdate(msg, clientId);
                        if (reply.getOperationId() != 212) continue block7;
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            logger.debug((Object)"Master change: executed pending ops in the new master");
        }
        return true;
    }

    public Message processSetFetchSize(Message m, int clientId) {
        Message reply = new Message(-1, null, true, this.master);
        return reply;
    }

    public Message processSetMaxRows(Message m, int clientId) {
        Message reply = new Message(-1, null, true, this.master);
        return reply;
    }

    protected Message processClose(Message m, int clientId) {
        Message reply;
        logger.debug((Object)("processClose(): " + clientId));
        try {
            this.sm.close(clientId);
            reply = new Message(601, null, true, this.master);
        }
        catch (SQLException sqle) {
            logger.error((Object)"processClose() error", (Throwable)sqle);
            reply = new Message(602, null, true, this.master);
        }
        return reply;
    }

    private Normalizer getNormalizer(String driver) {
        if (driver.equalsIgnoreCase("org.firebirdsql.jdbc.FBDriver")) {
            return new FirebirdNormalizer();
        }
        return new NoNormalizer();
    }

    protected List<ConnectionState> getConnections() {
        return this.sm.getConnections();
    }

    protected void restoreOpenConnections(List<ConnectionState> connections) {
        for (ConnectionState connection : connections) {
            DBLoginParams login = connection.getDbLogin();
            logger.debug((Object)("----RESTORING CONNECTION FOR CLIENT " + connection.getClientId()));
            this.sm.connect(connection.getClientId(), "smartlighting" + this.replicaId, login.getUser(), login.getPassword(), connection.getTransQueue());
        }
        logger.debug((Object)"----RESTORED CONNECTIONS");
    }

    private LinkedList<byte[]> pendingOpsHashes(Queue<Message> queue) {
        LinkedList<byte[]> queueHashes = new LinkedList<byte[]>();
        for (Message m : queue) {
            byte[] hash = TOMUtil.computeHash((byte[])TOMUtil.getBytes((Object)m.getContents()));
            queueHashes.add(hash);
        }
        return queueHashes;
    }

    private boolean compareHashes(LinkedList<byte[]> a, LinkedList<byte[]> b) {
        if (a == null) {
            return b == null;
        }
        if (a != null) {
            if (b == null) {
                return false;
            }
            if (a.size() != b.size()) {
                return false;
            }
            int i = 0;
            while (i < a.size()) {
                if (!Arrays.equals(a.get(i), b.get(i))) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected void setCurrentView(View view) {
        this.currentView = view;
    }

    protected int getMaster() {
        return this.master;
    }
}

