/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.Replica;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lasige.divdb.comm.Message;
import org.apache.log4j.Logger;

public class ConnManagerWithLocks {
    private Connection conn;
    private Queue<Message> transQueue;
    private boolean readWriteTransaction = false;
    private boolean commitingTransaction = false;
    private Lock connectionLock = new ReentrantLock();
    private Condition correctState = this.connectionLock.newCondition();
    private int currentOperationId;
    private AtomicInteger operationCount;
    private static final int CONNECTION_TIMEOUT = 10;
    private Logger logger = Logger.getLogger((String)"divdb");

    protected ConnManagerWithLocks() {
        this.transQueue = new LinkedList<Message>();
        this.operationCount = new AtomicInteger();
    }

    protected boolean connect(String url, String user, String pass) {
        try {
            this.connectionLock.lock();
            url = String.valueOf(url) + ";MVCC=TRUE;LOCK_TIMEOUT=10";
            this.logger.info((Object)("CONNECTING TO DATABASE. URL: " + url));
            this.conn = DriverManager.getConnection(url, user, pass);
            this.currentOperationId = this.operationCount.incrementAndGet();
            this.correctState.signalAll();
            this.connectionLock.unlock();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.conn != null;
    }

    public void enqueueOperation(Message m) {
        this.connectionLock.lock();
        this.logger.debug((Object)("enqueueOperation. currentOperationId: " + this.currentOperationId + ", operationId: " + m.getOperationId()));
        while (m.getOperationId() != this.currentOperationId) {
            this.correctState.awaitUninterruptibly();
        }
        this.transQueue.offer(m);
        this.currentOperationId = this.operationCount.incrementAndGet();
        this.correctState.signalAll();
        this.connectionLock.unlock();
    }

    public Queue<Message> getTrans() {
        return this.transQueue;
    }

    public void clearTransaction() {
        this.transQueue = new LinkedList<Message>();
    }

    protected void closeConn() throws SQLException {
        this.conn.close();
    }

    protected void readWriteTransaction(int operationId) throws SQLException {
        this.connectionLock.lock();
        this.logger.debug((Object)("readWriteTransaction. currentOperationId: " + this.currentOperationId + ", operationId: " + operationId));
        while (operationId != this.currentOperationId) {
            this.correctState.awaitUninterruptibly();
        }
        if (!this.conn.getAutoCommit()) {
            this.readWriteTransaction = true;
        }
        this.connectionLock.unlock();
    }

    protected boolean isReadWriteTransaction() {
        boolean returnValue = this.readWriteTransaction;
        return returnValue;
    }

    protected boolean isCommitingTransaction() {
        boolean returnValue = this.commitingTransaction;
        return returnValue;
    }

    protected void setCommitingTransaction(boolean commitingTransaction) {
        this.commitingTransaction = commitingTransaction;
        if (!commitingTransaction) {
            this.readWriteTransaction = false;
        }
    }

    protected Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    protected DatabaseMetaData getMetaData(int operationId) throws SQLException {
        this.connectionLock.lock();
        this.logger.debug((Object)("getMetaData. currentOperationId: " + this.currentOperationId + ", operationId: " + operationId));
        while (operationId != this.currentOperationId) {
            try {
                this.correctState.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        DatabaseMetaData returnValue = this.conn.getMetaData();
        this.currentOperationId = this.operationCount.incrementAndGet();
        this.correctState.signalAll();
        this.connectionLock.unlock();
        return returnValue;
    }

    protected void setAutoCommit(boolean autoCommit, int operationId) throws SQLException {
        this.connectionLock.lock();
        this.logger.debug((Object)("setAutoCommit. currentOperationId: " + this.currentOperationId + ", operationId: " + operationId));
        while (this.currentOperationId != operationId) {
            try {
                this.correctState.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.conn.setAutoCommit(autoCommit);
        if (autoCommit) {
            this.readWriteTransaction = false;
        }
        this.currentOperationId = this.operationCount.incrementAndGet();
        this.correctState.signalAll();
        this.connectionLock.unlock();
    }

    protected void commit(int operationId) throws SQLException {
        this.connectionLock.lock();
        this.logger.debug((Object)("commit. currentOperationId: " + this.currentOperationId + ", operationId: " + operationId));
        while (this.currentOperationId != operationId) {
            try {
                this.correctState.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.commitingTransaction = false;
        this.readWriteTransaction = false;
        this.conn.commit();
        this.currentOperationId = this.operationCount.incrementAndGet();
        this.correctState.signalAll();
        this.connectionLock.unlock();
    }

    protected void rollback(int operationId) throws SQLException {
        this.connectionLock.lock();
        this.logger.debug((Object)("rollback. currentOperationId: " + this.currentOperationId + ", operationId: " + operationId));
        while (this.currentOperationId != operationId) {
            try {
                this.correctState.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.commitingTransaction = false;
        this.readWriteTransaction = false;
        this.conn.rollback();
        this.currentOperationId = this.operationCount.incrementAndGet();
        this.correctState.signalAll();
        this.connectionLock.unlock();
    }

    protected void initQueryExecution(int operationId) {
        this.connectionLock.lock();
        this.logger.debug((Object)("initQueryExecution. currentOperationId: " + this.currentOperationId + ", operationId: " + operationId));
        while (this.currentOperationId != operationId) {
            try {
                this.correctState.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.connectionLock.unlock();
    }

    protected void finishQueryExecution(int operationId) {
        this.connectionLock.lock();
        this.currentOperationId = this.operationCount.incrementAndGet();
        this.correctState.signalAll();
        this.connectionLock.unlock();
    }

    protected void waitForSync(int operationId) {
        this.connectionLock.lock();
        this.logger.debug((Object)("waitforSync. currentOperationId: " + this.currentOperationId + ", operationId: " + operationId));
        while (operationId != this.currentOperationId) {
            this.correctState.awaitUninterruptibly();
        }
        this.connectionLock.unlock();
    }
}

