/*
 * Decompiled with CFR 0.152.
 */
package lasige.divdb.Replica;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Queue;
import lasige.divdb.comm.Message;
import lasige.divdb.statemanagement.DBLoginParams;
import org.apache.log4j.Logger;

public class ConnManager {
    private Connection conn;
    private Queue<Message> transQueue;
    private DBLoginParams login;
    private boolean readWriteTransaction = false;
    private boolean commitingTransaction = false;
    private boolean aborted = false;
    private boolean connected = false;
    private static final int CONNECTION_TIMEOUT = 5000;
    private Logger logger = Logger.getLogger((String)"divdb");

    protected ConnManager() {
        this.transQueue = new LinkedList<Message>();
    }

    protected boolean connect(String url, String user, String pass) {
        try {
            url = String.valueOf(url) + ";MVCC=TRUE;LOCK_TIMEOUT=5000";
            this.logger.info((Object)("CONNECTING TO DATABASE. URL: " + url));
            this.conn = DriverManager.getConnection(url, user, pass);
            this.login = new DBLoginParams(null, user, pass);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (this.conn != null) {
            this.connected = true;
        }
        return this.conn != null;
    }

    public void enqueueOperation(Message m) {
        this.transQueue.offer(m);
    }

    public void setTransactionQueue(Queue<Message> transQueue) {
        this.transQueue = transQueue;
    }

    public Queue<Message> getTransactionQueue() {
        return this.transQueue;
    }

    public void clearTransaction() {
        this.transQueue = new LinkedList<Message>();
    }

    protected void closeConn() throws SQLException {
        this.conn.close();
        this.connected = false;
    }

    protected void readWriteTransaction() throws SQLException {
        if (!this.conn.getAutoCommit()) {
            this.readWriteTransaction = true;
        }
    }

    protected boolean isReadWriteTransaction() {
        boolean returnValue = this.readWriteTransaction;
        return returnValue;
    }

    protected boolean isCommitingTransaction() {
        boolean returnValue = this.commitingTransaction;
        return returnValue;
    }

    protected void setCommitingTransaction(boolean commitingTransaction) {
        this.commitingTransaction = commitingTransaction;
        if (!commitingTransaction) {
            this.readWriteTransaction = false;
        }
    }

    protected Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    protected DatabaseMetaData getMetaData() throws SQLException {
        this.logger.debug((Object)("conn is not null " + (this.conn != null)));
        DatabaseMetaData returnValue = this.conn.getMetaData();
        return returnValue;
    }

    protected void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
        if (autoCommit) {
            this.readWriteTransaction = false;
        }
        this.commitingTransaction = false;
    }

    protected void commit() throws SQLException {
        this.commitingTransaction = false;
        this.readWriteTransaction = false;
        this.conn.commit();
    }

    protected void rollback() throws SQLException {
        this.reset();
        this.conn.rollback();
    }

    protected void abort() {
        this.aborted = true;
    }

    protected boolean isAborted() {
        return this.aborted;
    }

    protected void reset() {
        this.transQueue = new LinkedList<Message>();
        this.readWriteTransaction = false;
        this.commitingTransaction = false;
        this.aborted = false;
    }

    protected boolean isAutoCommit() {
        boolean auto = true;
        try {
            auto = this.conn.getAutoCommit();
        }
        catch (SQLException e) {
            this.logger.error((Object)"error in getautocommi", (Throwable)e);
        }
        return auto;
    }

    protected DBLoginParams getLogin() {
        return this.login;
    }

    protected boolean isConnected() {
        return this.connected;
    }
}

