/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting;

import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pt.efacec.smartlighting.ITransaction;
import pt.efacec.smartlighting.business.core.entitydao.IControlDAO;
import pt.efacec.smartlighting.business.core.entitydao.IDtcDAO;
import pt.efacec.smartlighting.business.core.entitydao.IPeriodDAO;
import pt.efacec.smartlighting.business.core.entitydao.IProfileDAO;
import pt.efacec.smartlighting.business.core.entitydao.ISpecialDayDAO;
import pt.efacec.smartlighting.business.core.entitydao.ITimetableDAO;
import pt.efacec.smartlighting.business.core.entitydao.IUserDAO;
import pt.efacec.smartlighting.common.core.entity.Control;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.Period;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.SpecialDay;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.core.entity.User;

@Service
public class Transaction
implements ITransaction {
    @Autowired
    private IDtcDAO dtcDAO;
    @Autowired
    private IProfileDAO profileDAO;
    @Autowired
    private ISpecialDayDAO specialDayDAO;
    @Autowired
    private ITimetableDAO timetableDAO;
    @Autowired
    private IPeriodDAO periodDAO;
    @Autowired
    private IControlDAO controlDAO;
    @Autowired
    private IUserDAO userDAO;

    @Override
    @Transactional
    public Dtc findDtcById(String id) {
        return this.dtcDAO.findById(id);
    }

    @Override
    @Transactional
    public void save(Dtc entity) {
        this.dtcDAO.save(entity);
    }

    @Override
    @Transactional
    public void remove(Dtc entity) {
        this.dtcDAO.removeByIdAndVersion(entity.getId(), entity.getVersion());
    }

    @Override
    @Transactional
    public Profile findProfileById(String id) {
        return this.profileDAO.findById(id);
    }

    @Override
    @Transactional
    public void save(Profile entity) {
        this.profileDAO.save(entity);
    }

    @Override
    @Transactional
    public void remove(Profile entity) {
        this.profileDAO.removeByIdAndVersion(entity.getId(), entity.getVersion());
    }

    @Override
    @Transactional
    public SpecialDay findSpecialDayById(String id) {
        return this.specialDayDAO.findById(id);
    }

    @Override
    @Transactional
    public void save(SpecialDay entity) {
        this.specialDayDAO.save(entity);
    }

    @Override
    @Transactional
    public void remove(SpecialDay entity) {
        this.specialDayDAO.removeByIdAndVersion(entity.getId(), entity.getVersion());
    }

    @Override
    @Transactional
    public Timetable findTimetableById(String id) {
        Timetable entity = this.timetableDAO.findById(id);
        Set periods = this.timetableDAO.getPeriods(id);
        entity.setPeriods(periods);
        for (Period period : periods) {
            period.setControls(this.periodDAO.getControls(period.getId()));
        }
        return entity;
    }

    @Override
    @Transactional
    public void save(Timetable entity) {
        this.timetableDAO.save(entity);
        for (Period period : entity.getPeriods()) {
            this.periodDAO.save(period);
            for (Control control : period.getControls()) {
                this.controlDAO.save(control);
            }
        }
    }

    @Override
    @Transactional
    public void remove(Timetable entity) {
        for (Period period : entity.getPeriods()) {
            for (Control control : period.getControls()) {
                this.controlDAO.removeByIdAndVersion(control.getId(), control.getVersion());
            }
            this.periodDAO.removeByIdAndVersion(period.getId(), period.getVersion());
        }
        this.timetableDAO.removeByIdAndVersion(entity.getId(), entity.getVersion());
    }

    @Override
    @Transactional
    public User findUserById(String id) {
        return this.userDAO.findById(id);
    }

    @Override
    @Transactional
    public void save(User entity) {
        this.userDAO.save(entity);
    }

    @Override
    @Transactional
    public void remove(User entity) {
        this.userDAO.removeByIdAndVersion(entity.getId(), entity.getVersion());
    }
}

