/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting;

public class Statistic {
    private String name;
    private long sum;
    private long count;
    private long average;
    private long max;
    private long min;
    private boolean ok = true;

    public Statistic(String name) {
        this.name = name;
        this.min = Long.MAX_VALUE;
    }

    public void addStats(Statistic stat) {
        this.count += stat.getCount();
        this.sum += stat.getSum();
        if (this.count > 0L) {
            this.average = this.sum / this.count;
        }
        if (this.max < stat.getMax()) {
            this.max = stat.getMax();
        }
        if (this.min > stat.getMin()) {
            this.min = stat.getMin();
        }
        this.ok = this.ok && stat.isOk();
    }

    public void add(long value) {
        ++this.count;
        this.sum += value;
        if (this.count > 0L) {
            this.average = this.sum / this.count;
        }
        if (this.max < value) {
            this.max = value;
        }
        if (this.min > value) {
            this.min = value;
        }
    }

    public String getName() {
        return this.name;
    }

    public long getSum() {
        return this.sum;
    }

    public long getCount() {
        return this.count;
    }

    public long getAverage() {
        return this.average;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public boolean isOk() {
        return this.ok;
    }

    public void setOk(boolean ok) {
        this.ok = ok;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Statistic [name=\"");
        builder.append(this.name);
        builder.append("\", sum=");
        builder.append(this.sum);
        builder.append("ms, count=");
        builder.append(this.count);
        builder.append(", average=");
        builder.append(this.average);
        builder.append("ms, max=");
        builder.append(this.max);
        builder.append("ms, min=");
        builder.append(this.min);
        builder.append("ms, ok=");
        builder.append(this.ok);
        builder.append("]");
        return builder.toString();
    }

    public String csv() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append("\t");
        builder.append(this.count).append("\t");
        builder.append(this.average).append("\t");
        builder.append(this.max).append("\t");
        builder.append(this.count == 0L ? 0L : this.min).append("\t");
        builder.append(this.ok).append("\n");
        return builder.toString();
    }
}

