/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.Properties;

public class FileProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    private File store;

    public FileProperties(File file) {
        this(file, true);
    }

    public FileProperties(File file, boolean mandatory) {
        this.store = file;
        this.load(mandatory);
    }

    public void reload() {
        this.load(true);
    }

    private void load(boolean mandatory) {
        if (this.store.exists()) {
            try {
                this.load(new FileInputStream(this.store));
            }
            catch (Exception e) {
                throw new RuntimeException("=====> unable to load \"" + this.store.getAbsolutePath() + "\".", e);
            }
        } else if (mandatory) {
            throw new RuntimeException("=====> \"" + this.store.getAbsolutePath() + "\" wasn't found.");
        }
    }

    public void save() {
        try {
            this.store(new FileOutputStream(this.store), "--no comments--");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getInt(String name, int miss) {
        String number = this.getProperty(name, "" + miss);
        try {
            return new DecimalFormat("#0").parse(number).intValue();
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

