/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.mock;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import pt.efacec.smartlighting.business.core.entitydao.IAuditActionDAO;
import pt.efacec.smartlighting.business.spring.Safe;
import pt.efacec.smartlighting.common.core.lov.AuditActionContextLOV;
import pt.efacec.smartlighting.common.core.lov.AuditActionTypeLOV;
import pt.efacec.smartlighting.common.domain.DtcServiceMode;
import pt.efacec.smartlighting.common.domain.DtcServiceOffset;
import pt.efacec.smartlighting.common.domain.DtcServiceState;
import pt.efacec.smartlighting.common.domain.DtcServiceTimeTable;
import pt.efacec.smartlighting.common.domain.EMode;
import pt.efacec.smartlighting.common.domain.EModeExtended;
import pt.efacec.smartlighting.common.domain.EState;
import pt.efacec.smartlighting.common.domain.ETimeTableType;
import pt.efacec.smartlighting.common.domain.StandardPeriodDTO;
import pt.efacec.smartlighting.common.dto.AuditLog;
import pt.efacec.smartlighting.common.service.IGatewayService;
import pt.efacec.smartlighting.common.util.Context;

public class GatewayServiceMock
implements IGatewayService {
    private static final Logger logger = Logger.getLogger(GatewayServiceMock.class);
    private static final String SERVICE_1 = "STREETS";
    private static final String SERVICE_3 = "GARDENS";
    private static final long SLEEP_SET = 5000L;
    private static final long SLEEP_GET = 2000L;
    @Autowired
    private IAuditActionDAO auditActionDAO;
    private List<DtcServiceMode> modeList = new ArrayList<DtcServiceMode>();
    private List<DtcServiceState> stateList = new ArrayList<DtcServiceState>();
    private List<DtcServiceOffset> offsets = new ArrayList<DtcServiceOffset>();
    private List<DtcServiceTimeTable> timetables = new ArrayList<DtcServiceTimeTable>();
    private Map<String, List<DtcServiceTimeTable>> dtcTimetables = new ConcurrentHashMap<String, List<DtcServiceTimeTable>>();

    public GatewayServiceMock() {
        this.modeList.add(new DtcServiceMode(SERVICE_1, EMode.AUTO));
        this.modeList.add(new DtcServiceMode(SERVICE_3, EMode.MANUAL));
        this.stateList.add(new DtcServiceState(SERVICE_1, EState.ON));
        this.stateList.add(new DtcServiceState(SERVICE_3, EState.OFF));
        this.offsets.add(new DtcServiceOffset(SERVICE_1, Long.valueOf(10L)));
        this.offsets.add(new DtcServiceOffset(SERVICE_3, Long.valueOf(30L)));
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        SimpleDateFormat hm = new SimpleDateFormat("HH:mm");
        hm.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            DtcServiceTimeTable timetable = new DtcServiceTimeTable(SERVICE_1);
            timetable.setType(ETimeTableType.SERVICE);
            StandardPeriodDTO entry = new StandardPeriodDTO(sdf.parse("01-09-2012"), sdf.parse("30-09-2012"), EModeExtended.MANUAL, hm.parse("07:00"), null, EModeExtended.MANUAL, hm.parse("20:30"), null);
            timetable.addEntry(entry);
            this.timetables.add(timetable);
            timetable = new DtcServiceTimeTable(SERVICE_1);
            timetable.setType(ETimeTableType.SPECIAL_DAY);
            entry = new StandardPeriodDTO(sdf.parse("25-04-2012"), sdf.parse("25-04-2012"), EModeExtended.PHOTOCELL, null, null, EModeExtended.PHOTOCELL, null, null);
            timetable.addEntry(entry);
            entry = new StandardPeriodDTO(sdf.parse("18-08-2012"), sdf.parse("18-08-2012"), EModeExtended.SOLAR, null, Long.valueOf(10L), EModeExtended.SOLAR, null, Long.valueOf(10L));
            timetable.addEntry(entry);
            entry = new StandardPeriodDTO(sdf.parse("25-12-2012"), sdf.parse("25-12-2012"), EModeExtended.PHOTOCELL, null, null, EModeExtended.PHOTOCELL, null, null);
            timetable.addEntry(entry);
            this.timetables.add(timetable);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    @Safe(value={"USER"})
    public List<DtcServiceMode> getMode(String ip) throws Exception {
        Thread.sleep(2000L);
        return this.modeList;
    }

    @Safe(value={"USER"})
    public List<DtcServiceState> getState(String ip) throws Exception {
        Thread.sleep(2000L);
        return this.stateList;
    }

    @Safe(value={"OPERATOR"})
    @Transactional
    public boolean setMode(String serviceName, EMode mode, String ip) {
        AuditLog log = new AuditLog("DTC_CHGMODE");
        log.setService(serviceName);
        log.setMode(Boolean.valueOf(EMode.AUTO == mode));
        log.setIpAddress(ip);
        this.auditActionDAO.logAction(Context.get().getUser(), AuditActionContextLOV.DTC, AuditActionTypeLOV.CHGMODE, log);
        for (DtcServiceMode m : this.modeList) {
            if (!m.getName().equals(serviceName)) continue;
            m.setMode(mode);
            return true;
        }
        return false;
    }

    @Transactional
    @Safe(value={"OPERATOR"})
    public boolean setState(String serviceName, EState state, String ip) {
        AuditLog log = new AuditLog("DTC_CHGSTATE");
        log.setService(serviceName);
        log.setMode(Boolean.valueOf(EState.ON == state));
        log.setIpAddress(ip);
        Context ctx = Context.get();
        this.auditActionDAO.logAction(ctx.getUser(), AuditActionContextLOV.DTC, AuditActionTypeLOV.CHGSTATE, log);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (DtcServiceState s : this.stateList) {
            if (!s.getName().equals(serviceName)) continue;
            s.setState(state);
            return true;
        }
        return false;
    }

    @Safe(value={"USER"})
    public List<DtcServiceOffset> getOffset(String ip) throws Exception {
        Thread.sleep(2000L);
        return this.offsets;
    }

    @Safe(value={"USER"})
    public List<DtcServiceTimeTable> getTimetable(String ip) throws Exception {
        Thread.sleep(2000L);
        if (ip.equals("110.127.0.112")) {
            return new ArrayList<DtcServiceTimeTable>();
        }
        List<DtcServiceTimeTable> tt = this.dtcTimetables.get(ip);
        if (tt != null) {
            return tt;
        }
        return this.timetables;
    }

    @Safe(value={"OPERATOR"})
    public void setTimetable(String ip, List<DtcServiceTimeTable> timetables) throws Exception {
        if (ip != null && timetables != null) {
            StringBuilder stringified = new StringBuilder();
            for (DtcServiceTimeTable tt : timetables) {
                stringified.append(tt.stringified());
            }
            logger.debug((Object)stringified.toString());
            Thread.sleep(5000L);
            this.dtcTimetables.put(ip, timetables);
        }
    }
}

