/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.spring;

import org.apache.log4j.Logger;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.beans.factory.annotation.Autowired;
import pt.efacec.smartlighting.business.spring.Monitor;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.tclouds.ITracer;
import pt.efacec.smartlighting.common.util.Context;

@Aspect
public class MonitorAspect {
    private static final Logger logger = Logger.getLogger(MonitorAspect.class);
    private static final long THRESHOLD = 1000L;
    @Autowired
    private ITracer tracer;

    @Around(value="@annotation( monitor )")
    public Object doBasicProfiling(ProceedingJoinPoint pjp, Monitor monitor) throws Throwable {
        Context ctx = Context.get();
        StringBuilder sb = new StringBuilder();
        User user = ctx.getUser();
        if (user != null) {
            sb.append(user.getLogin());
        } else {
            sb.append("<unknown user>");
        }
        sb.append(" -> ").append(pjp.getSignature().toLongString()).append("( ");
        Object[] args = pjp.getArgs();
        boolean notFirst = false;
        if (args != null) {
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (notFirst) {
                    sb.append(", ");
                }
                sb.append(o);
                notFirst = true;
                ++n2;
            }
        }
        sb.append(" )");
        this.tracer.trace(sb.toString());
        long now = System.currentTimeMillis();
        Object retVal = pjp.proceed();
        long interval = System.currentTimeMillis() - now;
        if (interval > 1000L) {
            logger.warn((Object)String.format("O metodo %s foi executado em %sms (> %sms)", pjp.getSignature().toLongString(), interval, 1000L));
        }
        return retVal;
    }
}

