/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.service;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import pt.efacec.smartlighting.business.core.entitydao.IUserDAO;
import pt.efacec.smartlighting.business.core.service.IStartup;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.toolkit.misc.Strings;

public class Startup
implements IStartup {
    private static Logger logger = Logger.getLogger(Startup.class);
    @Autowired
    private IUserDAO userDAO;

    @Override
    @Transactional
    public void setAdminName(String name) {
        String admin = System.getenv("sl_admin");
        if (admin != null) {
            String password = System.getenv("sl_password");
            if (password != null) {
                if (this.create(name, admin, password)) {
                    logger.info((Object)String.format("Administrator creation: The administrator user with the name '%s' and login '%s' was created.", name, admin));
                } else {
                    logger.info((Object)String.format("Administrator creation: A user with the login '%s' already exists.", admin));
                }
            } else {
                logger.info((Object)"Environment variable 'sl_admin' is defined but 'sl_password' isn't defined. Aborting administrator creation.");
            }
        }
    }

    private boolean create(String name, String login, String password) {
        User user = this.userDAO.findByLogin(login);
        if (user == null) {
            user = new User();
            user.setName(name);
            user.setLogin(login);
            String salt = Strings.generateSalt();
            user.setSalt(salt);
            user.setPassword(Strings.getHash((String)password, (String)salt));
            user.setLocked(Boolean.valueOf(false));
            user.setLockedDate(null);
            user.setFailedLogins(Long.valueOf(0L));
            this.userDAO.save(user);
            return true;
        }
        return false;
    }
}

