/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.service;

import java.util.Date;
import javax.persistence.OptimisticLockException;
import org.springframework.transaction.annotation.Transactional;
import pt.efacec.smartlighting.business.spring.Monitor;
import pt.efacec.smartlighting.business.spring.Safe;
import pt.efacec.smartlighting.common.core.dto.AlarmReportDTO;
import pt.efacec.smartlighting.common.core.dto.AlarmReportSearchDTO;
import pt.efacec.smartlighting.common.core.dto.AuditReportDTO;
import pt.efacec.smartlighting.common.core.dto.AuditReportSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcStateDTO;
import pt.efacec.smartlighting.common.core.dto.DtcStateSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcSyncStateDTO;
import pt.efacec.smartlighting.common.core.dto.DtcSyncStateSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcTransitionDTO;
import pt.efacec.smartlighting.common.core.dto.DtcTransitionSearchDTO;
import pt.efacec.smartlighting.common.core.dto.ServiceSummaryDTO;
import pt.efacec.smartlighting.common.core.dto.ServiceSummarySearchDTO;
import pt.efacec.smartlighting.common.core.service.IReportService;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class ReportServiceBase
implements IReportService {
    private static final Log logger = Log.getLogger(ReportServiceBase.class);

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<ServiceSummaryDTO> searchServiceSummary(ServiceSummarySearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ReportService.searchServiceSummary", "criteria"});
        }
        try {
            return this.handleSearchServiceSummary(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchServiceSummary.", e);
        }
    }

    protected abstract Page<ServiceSummaryDTO> handleSearchServiceSummary(ServiceSummarySearchDTO var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<DtcSyncStateDTO> searchDtcSyncState(DtcSyncStateSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ReportService.searchDtcSyncState", "criteria"});
        }
        try {
            return this.handleSearchDtcSyncState(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchDtcSyncState.", e);
        }
    }

    protected abstract Page<DtcSyncStateDTO> handleSearchDtcSyncState(DtcSyncStateSearchDTO var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<DtcStateDTO> searchDtcState(DtcStateSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ReportService.searchDtcState", "criteria"});
        }
        try {
            return this.handleSearchDtcState(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchDtcState.", e);
        }
    }

    protected abstract Page<DtcStateDTO> handleSearchDtcState(DtcStateSearchDTO var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<DtcTransitionDTO> searchDtcTransitions(DtcTransitionSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ReportService.searchDtcTransitions", "criteria"});
        }
        try {
            return this.handleSearchDtcTransitions(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchDtcTransitions.", e);
        }
    }

    protected abstract Page<DtcTransitionDTO> handleSearchDtcTransitions(DtcTransitionSearchDTO var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<AlarmReportDTO> searchAlarms(AlarmReportSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ReportService.searchAlarms", "criteria"});
        }
        try {
            return this.handleSearchAlarms(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchAlarms.", e);
        }
    }

    protected abstract Page<AlarmReportDTO> handleSearchAlarms(AlarmReportSearchDTO var1) throws Exception;

    @Safe(value={"ADMIN"})
    @Monitor
    @Transactional
    public Page<AuditReportDTO> searchAudit(AuditReportSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ReportService.searchAudit", "criteria"});
        }
        try {
            return this.handleSearchAudit(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchAudit.", e);
        }
    }

    protected abstract Page<AuditReportDTO> handleSearchAudit(AuditReportSearchDTO var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Double fetchClientPower(Date start, Date end) {
        try {
            return this.handleFetchClientPower(start, end);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing fetchClientPower.", e);
        }
    }

    protected abstract Double handleFetchClientPower(Date var1, Date var2) throws Exception;
}

