/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.service;

import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pt.efacec.smartlighting.business.core.entitydao.IAlarmDAO;
import pt.efacec.smartlighting.business.core.entitydao.IAuditActionDAO;
import pt.efacec.smartlighting.business.core.entitydao.IDtcStateDAO;
import pt.efacec.smartlighting.business.core.entitydao.IEventDAO;
import pt.efacec.smartlighting.business.core.entitydao.IReportDAO;
import pt.efacec.smartlighting.business.core.entitydao.IServiceStopwatchDAO;
import pt.efacec.smartlighting.business.core.entitydao.IServiceStopwatchReportDAO;
import pt.efacec.smartlighting.business.core.service.ReportServiceBase;
import pt.efacec.smartlighting.common.core.dto.AlarmReportDTO;
import pt.efacec.smartlighting.common.core.dto.AlarmReportSearchDTO;
import pt.efacec.smartlighting.common.core.dto.AuditReportDTO;
import pt.efacec.smartlighting.common.core.dto.AuditReportSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcStateDTO;
import pt.efacec.smartlighting.common.core.dto.DtcStateSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcSyncStateDTO;
import pt.efacec.smartlighting.common.core.dto.DtcSyncStateSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcTransitionDTO;
import pt.efacec.smartlighting.common.core.dto.DtcTransitionSearchDTO;
import pt.efacec.smartlighting.common.core.dto.ServiceSummaryDTO;
import pt.efacec.smartlighting.common.core.dto.ServiceSummarySearchDTO;
import pt.efacec.smartlighting.common.core.entity.Report;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.util.Context;
import pt.efacec.toolkit.dao.Page;

@Service(value="reportService")
@Transactional
public class ReportService
extends ReportServiceBase {
    @Autowired
    private IServiceStopwatchDAO serviceStopwatchDAO;
    @Autowired
    private IServiceStopwatchReportDAO serviceStopwatchReportDAO;
    @Autowired
    private IReportDAO reportDAO;
    @Autowired
    private IDtcStateDAO dtcStateDAO;
    @Autowired
    private IEventDAO eventDAO;
    @Autowired
    private IAlarmDAO alarmDAO;
    @Autowired
    private IAuditActionDAO auditActionDAO;
    private static final long TIMEOUT = 600000L;

    @Override
    protected Page<ServiceSummaryDTO> handleSearchServiceSummary(ServiceSummarySearchDTO criteria) throws Exception {
        User user = Context.get().getUser();
        List<Report> reports = this.reportDAO.findTimedOut(600000L);
        for (Report report : reports) {
            this.serviceStopwatchReportDAO.clear(report.getId());
            this.reportDAO.remove(report);
        }
        boolean hasTimedOut = this.reportDAO.touch(criteria.getReportUid());
        if (hasTimedOut || criteria.getCountRecords().booleanValue()) {
            this.serviceStopwatchReportDAO.clear(criteria.getReportUid());
            Date now = new Date();
            if (criteria.getEndDate() == null) {
                criteria.setEndDate(now);
            }
            this.serviceStopwatchDAO.compute(criteria, user.getClientId(), user.getOperationalAreaId(), now);
        }
        Page<ServiceSummaryDTO> page = this.serviceStopwatchReportDAO.search(criteria);
        return page;
    }

    @Override
    protected Page<DtcSyncStateDTO> handleSearchDtcSyncState(DtcSyncStateSearchDTO criteria) throws Exception {
        User user = Context.get().getUser();
        if (user.getOperationalAreaId() != null) {
            criteria.setOperationalAreaId(user.getOperationalAreaId());
        } else if (user.getClientId() != null) {
            criteria.setClientId(user.getClientId());
        }
        return this.dtcStateDAO.searchSyncState(criteria);
    }

    @Override
    protected Page<DtcStateDTO> handleSearchDtcState(DtcStateSearchDTO criteria) throws Exception {
        User user = Context.get().getUser();
        if (user.getOperationalAreaId() != null) {
            criteria.setOperationalAreaId(user.getOperationalAreaId());
        } else if (user.getClientId() != null) {
            criteria.setClientId(user.getClientId());
        }
        return this.serviceStopwatchDAO.searchState(criteria);
    }

    @Override
    protected Page<DtcTransitionDTO> handleSearchDtcTransitions(DtcTransitionSearchDTO criteria) throws Exception {
        User user = Context.get().getUser();
        if (user.getOperationalAreaId() != null) {
            criteria.setOperationalAreaId(user.getOperationalAreaId());
        } else if (user.getClientId() != null) {
            criteria.setClientId(user.getClientId());
        }
        return this.eventDAO.searchDtcTransitions(criteria);
    }

    @Override
    protected Page<AlarmReportDTO> handleSearchAlarms(AlarmReportSearchDTO criteria) throws Exception {
        User user = Context.get().getUser();
        if (user.getOperationalAreaId() != null) {
            criteria.setOperationalAreaId(user.getOperationalAreaId());
        } else if (user.getClientId() != null) {
            criteria.setClientId(user.getClientId());
        }
        return this.alarmDAO.searchAlarms(criteria);
    }

    @Override
    protected Page<AuditReportDTO> handleSearchAudit(AuditReportSearchDTO criteria) throws Exception {
        return this.auditActionDAO.searchAudit(criteria);
    }

    @Override
    protected Double handleFetchClientPower(Date begin, Date end) throws Exception {
        User user = Context.get().getUser();
        return this.serviceStopwatchDAO.computeClientPower(user.getClientId(), begin, end);
    }
}

