/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.service;

import javax.persistence.OptimisticLockException;
import org.springframework.transaction.annotation.Transactional;
import pt.efacec.smartlighting.business.spring.Monitor;
import pt.efacec.smartlighting.business.spring.Safe;
import pt.efacec.smartlighting.common.core.dto.ClientSearchDTO;
import pt.efacec.smartlighting.common.core.dto.MyUserDTO;
import pt.efacec.smartlighting.common.core.dto.UserEditDTO;
import pt.efacec.smartlighting.common.core.dto.UserSearchDTO;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.core.service.IManagementService;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class ManagementServiceBase
implements IManagementService {
    private static final Log logger = Log.getLogger(ManagementServiceBase.class);

    @Safe
    @Monitor
    @Transactional
    public String getEmailSuport() {
        try {
            return this.handleGetEmailSuport();
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing getEmailSuport.", e);
        }
    }

    protected abstract String handleGetEmailSuport() throws Exception;

    @Safe(value={"ADMIN"})
    @Monitor
    @Transactional
    public void setEmailSuport(String value) {
        try {
            this.handleSetEmailSuport(value);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing setEmailSuport.", e);
        }
    }

    protected abstract void handleSetEmailSuport(String var1) throws Exception;

    @Safe
    @Monitor
    @Transactional
    public User authenticate(String login, String password) {
        if (login == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.authenticate", "login"});
        }
        if (password == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.authenticate", "password"});
        }
        try {
            return this.handleAuthenticate(login, password);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing authenticate.", e);
        }
    }

    protected abstract User handleAuthenticate(String var1, String var2) throws Exception;

    @Safe
    @Monitor
    @Transactional
    public void loggingoff(User user, Boolean timeout) {
        if (user == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.loggingoff", "user"});
        }
        if (timeout == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.loggingoff", "timeout"});
        }
        try {
            this.handleLoggingoff(user, timeout);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing loggingoff.", e);
        }
    }

    protected abstract void handleLoggingoff(User var1, Boolean var2) throws Exception;

    @Safe
    @Monitor
    @Transactional
    public Boolean checkUserUnlocked(String login) {
        if (login == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.checkUserUnlocked", "login"});
        }
        try {
            return this.handleCheckUserUnlocked(login);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing checkUserUnlocked.", e);
        }
    }

    protected abstract Boolean handleCheckUserUnlocked(String var1) throws Exception;

    @Safe(value={"ADMIN"})
    @Monitor
    @Transactional
    public void activateUser(String userId, Boolean active) {
        if (userId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.activateUser", "userId"});
        }
        if (active == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.activateUser", "active"});
        }
        try {
            this.handleActivateUser(userId, active);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing activateUser.", e);
        }
    }

    protected abstract void handleActivateUser(String var1, Boolean var2) throws Exception;

    @Safe
    @Monitor
    @Transactional
    public void resetPassword(String email) {
        if (email == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.resetPassword", "email"});
        }
        try {
            this.handleResetPassword(email);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing resetPassword.", e);
        }
    }

    protected abstract void handleResetPassword(String var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public User saveMyUser(MyUserDTO user) {
        if (user == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.saveMyUser", "user"});
        }
        try {
            return this.handleSaveMyUser(user);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing saveMyUser.", e);
        }
    }

    protected abstract User handleSaveMyUser(MyUserDTO var1) throws Exception;

    @Safe(value={"ADMIN"})
    @Monitor
    @Transactional
    public Page<User> searchUsers(UserSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.searchUsers", "criteria"});
        }
        try {
            return this.handleSearchUsers(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchUsers.", e);
        }
    }

    protected abstract Page<User> handleSearchUsers(UserSearchDTO var1) throws Exception;

    @Safe(value={"ADMIN"})
    @Monitor
    @Transactional
    public void removeUser(String id, Long version) {
        if (id == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.removeUser", "id"});
        }
        if (version == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.removeUser", "version"});
        }
        try {
            this.handleRemoveUser(id, version);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing removeUser.", e);
        }
    }

    protected abstract void handleRemoveUser(String var1, Long var2) throws Exception;

    @Safe(value={"ADMIN"})
    @Monitor
    @Transactional
    public UserEditDTO getUserEdit(String id) {
        try {
            return this.handleGetUserEdit(id);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing getUserEdit.", e);
        }
    }

    protected abstract UserEditDTO handleGetUserEdit(String var1) throws Exception;

    @Safe(value={"ADMIN"})
    @Monitor
    @Transactional
    public Boolean saveUser(User user) {
        if (user == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.saveUser", "user"});
        }
        try {
            return this.handleSaveUser(user);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing saveUser.", e);
        }
    }

    protected abstract Boolean handleSaveUser(User var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<ClientEntity> searchClients(ClientSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.searchClients", "criteria"});
        }
        try {
            return this.handleSearchClients(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchClients.", e);
        }
    }

    protected abstract Page<ClientEntity> handleSearchClients(ClientSearchDTO var1) throws Exception;

    @Safe(value={"ADMIN"})
    @Monitor
    @Transactional
    public void removeClient(String clientId) {
        if (clientId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.removeClient", "clientId"});
        }
        try {
            this.handleRemoveClient(clientId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing removeClient.", e);
        }
    }

    protected abstract void handleRemoveClient(String var1) throws Exception;

    @Safe(value={"ADMIN"})
    @Monitor
    @Transactional
    public ClientEntity addClient(ClientEntity entidade) {
        if (entidade == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ManagementService.addClient", "entidade"});
        }
        try {
            return this.handleAddClient(entidade);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing addClient.", e);
        }
    }

    protected abstract ClientEntity handleAddClient(ClientEntity var1) throws Exception;

    @Safe(value={"ADMIN"})
    @Monitor
    @Transactional
    public ClientEntity renameClient(String clientId, String name) {
        try {
            return this.handleRenameClient(clientId, name);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing renameClient.", e);
        }
    }

    protected abstract ClientEntity handleRenameClient(String var1, String var2) throws Exception;
}

