/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.mail.MessagingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pt.efacec.smartlighting.business.core.entitydao.IApplicationSettingDAO;
import pt.efacec.smartlighting.business.core.entitydao.IAuditActionDAO;
import pt.efacec.smartlighting.business.core.entitydao.IClientEntityDAO;
import pt.efacec.smartlighting.business.core.entitydao.IDtcDAO;
import pt.efacec.smartlighting.business.core.entitydao.IOperationalAreaDAO;
import pt.efacec.smartlighting.business.core.entitydao.IUserDAO;
import pt.efacec.smartlighting.business.core.service.ManagementServiceBase;
import pt.efacec.smartlighting.common.core.dto.ClientSearchDTO;
import pt.efacec.smartlighting.common.core.dto.MyUserDTO;
import pt.efacec.smartlighting.common.core.dto.UserEditDTO;
import pt.efacec.smartlighting.common.core.dto.UserSearchDTO;
import pt.efacec.smartlighting.common.core.entity.ApplicationSetting;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.core.lov.AuditActionContextLOV;
import pt.efacec.smartlighting.common.core.lov.AuditActionTypeLOV;
import pt.efacec.smartlighting.common.dto.AuditLog;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.smartlighting.common.mail.IMailClient;
import pt.efacec.smartlighting.common.util.Context;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;
import pt.efacec.toolkit.misc.Strings;

@Service(value="managementService")
@Transactional
public class ManagementService
extends ManagementServiceBase {
    private static final Log logger = Log.getLogger(ManagementService.class);
    public static final String EMAIL_SUPPORT = "EMAIL_SUPPORT";
    private static final String ADMIN_MAX_BLOCK_MINUTES = "ADMIN_MAX_BLOCK_MINUTES";
    private static final String ADMIN_MAX_ATTEMPTS = "ADMIN_MAX_ATTEMPTS";
    private static final String CLIENT_MAX_ATTEMPTS = "CLIENT_MAX_ATTEMPTS";
    private static final String OPERATOR_MAX_ATTEMPTS = "OPERATOR_MAX_ATTEMPTS";
    @Autowired
    private IApplicationSettingDAO applicationSettingDAO;
    @Autowired
    private IUserDAO userDAO;
    @Autowired
    private IAuditActionDAO auditActionDAO;
    @Autowired
    private IClientEntityDAO clientEntityDAO;
    @Autowired
    private IOperationalAreaDAO operationalAreaDAO;
    @Autowired
    private IDtcDAO dtcDAO;
    @Autowired
    private IMailClient mailClient;

    private void logAction(AuditActionContextLOV context, AuditActionTypeLOV action, AuditLog txt) {
        this.logAction(Context.get().getUser(), context, action, txt);
    }

    private void logAction(User user, AuditActionContextLOV context, AuditActionTypeLOV action, AuditLog txt) {
        this.auditActionDAO.logAction(user, context, action, txt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected User handleAuthenticate(String login, String password) throws Exception {
        boolean isAdmin;
        User usr = this.userDAO.findByLogin(login);
        if (usr == null) return null;
        boolean bl = isAdmin = usr.getClientId() == null && usr.getOperationalAreaId() == null;
        if (usr.getLocked().booleanValue()) {
            if (!isAdmin) return null;
            int maxAdminBlockMinutes = this.getAdminMaxBlockMinutes().intValue();
            Calendar reactivateDate = GregorianCalendar.getInstance();
            reactivateDate.setTime(usr.getLockedDate());
            reactivateDate.add(12, maxAdminBlockMinutes);
            Calendar currentDate = Calendar.getInstance();
            if (!reactivateDate.before(currentDate)) return null;
            usr = this.unlockUser(usr, true);
        }
        if (!usr.getPassword().equals(Strings.getHash((String)password, (String)usr.getSalt()))) {
            usr.setFailedLogins(Long.valueOf(usr.getFailedLogins() + 1L));
            long maxAttempts = this.getUserMaxAttempts(usr);
            if (maxAttempts <= 0L || usr.getFailedLogins() < maxAttempts) return null;
            this.unlockUser(usr, false);
            return null;
        }
        if (usr.getFailedLogins() > 0L) {
            usr.setFailedLogins(Long.valueOf(0L));
            usr = this.userDAO.save(usr);
        }
        this.logAction(usr, AuditActionContextLOV.USR, AuditActionTypeLOV.LOGIN, null);
        return this.userDAO.loadClientOrOperationalArea(usr);
    }

    @Override
    protected void handleLoggingoff(User user, Boolean timeout) throws Exception {
        String text = null;
        if (user != null) {
            text = user.getLogin();
        }
        AuditLog log = new AuditLog(timeout != false ? "LOG_SESTIMOUT" : "LOG_LOGOUT");
        log.setLogin(text);
        log.setDate(new Date());
        this.logAction(user, AuditActionContextLOV.LOG, timeout != false ? AuditActionTypeLOV.SESTIMOUT : AuditActionTypeLOV.LOGOUT, log);
    }

    @Override
    protected Boolean handleCheckUserUnlocked(String login) throws Exception {
        User user = this.userDAO.findByLogin(login);
        return user.getLocked();
    }

    @Override
    protected User handleSaveMyUser(MyUserDTO dto) throws Exception {
        User myUser = this.userDAO.findById(Context.get().getUser().getId());
        if (myUser.getSalt() == null) {
            myUser.setSalt(Strings.generateSalt());
        }
        String hashPass = Strings.getHash((String)dto.getOldPassword(), (String)myUser.getSalt());
        if (!myUser.getPassword().equals(hashPass)) {
            throw new BusinessCodedException("password.diferentPassword");
        }
        if (!Strings.isEmpty((String)dto.getNewPassword())) {
            myUser.setPassword(Strings.getHash((String)dto.getNewPassword(), (String)myUser.getSalt()));
        }
        if (dto.getEmail() != null) {
            User foundUser = this.userDAO.findByEmail(dto.getEmail());
            if (foundUser == null || foundUser.getId().equals(myUser.getId())) {
                myUser.setEmail(dto.getEmail().trim());
            } else {
                throw new BusinessCodedException("error.AlreadyExistsEMail", new Object[]{dto.getEmail()});
            }
        }
        myUser = this.userDAO.save(myUser);
        myUser = this.userDAO.loadClientOrOperationalArea(myUser);
        this.auditSaveUser(false, myUser, Context.get().getUser());
        return myUser;
    }

    @Override
    protected Boolean handleSaveUser(User user) throws Exception {
        User other = this.userDAO.findByLogin(user.getLogin());
        if (!(other == null || user.getId() != null && user.getId().equals(other.getId()))) {
            throw new BusinessCodedException("error.AlreadyExistsLogin", new Object[]{user.getLogin()});
        }
        other = this.userDAO.findByEmail(user.getEmail());
        if (!(other == null || user.getId() != null && user.getId().equals(other.getId()))) {
            throw new BusinessCodedException("error.AlreadyExistsEMail", new Object[]{user.getLogin()});
        }
        user.setLocked(Boolean.valueOf(false));
        user.setLockedDate(null);
        user.setFailedLogins(Long.valueOf(0L));
        boolean isNew = user.getVersion() == null;
        String realPassword = this.createPassword();
        if (isNew) {
            user.setSalt(Strings.generateSalt());
            user.setPassword(Strings.getHash((String)realPassword, (String)user.getSalt()));
            other = null;
        } else {
            other = this.userDAO.findById(user.getId());
            user.setPassword(other.getPassword());
        }
        user = this.userDAO.save(user);
        if (isNew) {
            try {
                this.sendPasswordEmail(user, realPassword);
            }
            catch (BusinessException e) {
                return false;
            }
        }
        this.auditSaveUser(isNew, user, other);
        return true;
    }

    private void auditSaveUser(boolean isNew, User user, User original) {
        AuditActionTypeLOV action = null;
        AuditLog log = null;
        if (isNew) {
            log = new AuditLog("USER_ADD");
            action = AuditActionTypeLOV.ADD;
            log.setLogin(user.getLogin());
        } else {
            boolean pwdChange = !user.getPassword().equals(original.getPassword());
            log = new AuditLog(pwdChange ? "USER_PWD_MODIFY" : "USER_MODIFY");
            log.setLogin(original.getLogin());
            log.setOldName(original.getLogin());
            log.setName(user.getLogin());
            log.setOldEmail(original.getEmail());
            log.setEmail(user.getEmail());
            action = AuditActionTypeLOV.MODIFY;
        }
        this.logAction(AuditActionContextLOV.USR, action, log);
    }

    @Override
    protected void handleActivateUser(String userId, Boolean active) throws Exception {
        User user = this.userDAO.findById(userId);
        this.unlockUser(user, active);
        AuditLog log = new AuditLog(active != false ? "USER_UNLOCK" : "USER_LOCK");
        log.setLogin(user.getLogin());
        this.logAction(AuditActionContextLOV.USR, active != false ? AuditActionTypeLOV.UNLOCK : AuditActionTypeLOV.LOCK, log);
    }

    private User unlockUser(User user, Boolean active) throws Exception {
        if (active.booleanValue()) {
            user.setLocked(Boolean.valueOf(false));
            user.setLockedDate(null);
            user.setFailedLogins(Long.valueOf(0L));
            this.userDAO.save(user);
        } else {
            user.setLocked(Boolean.valueOf(true));
            user.setLockedDate(new Date());
        }
        return this.userDAO.save(user);
    }

    private Long getUserMaxAttempts(User user) {
        if (user.getClientId() != null) {
            return this.getClientMaxAttempts();
        }
        if (user.getOperationalAreaId() != null) {
            return this.getClientMaxAttempts();
        }
        return this.getAdminMaxAttempts();
    }

    @Override
    protected void handleResetPassword(String email) throws Exception {
        User usr = this.userDAO.findByEmail(email);
        if (usr == null) {
            throw new BusinessCodedException("error.0005", new Object[]{email});
        }
        String realPassword = this.createPassword();
        if (usr.getSalt() == null) {
            usr.setSalt(Strings.generateSalt());
        }
        usr.setPassword(Strings.getHash((String)realPassword, (String)usr.getSalt()));
        long failedLogins = this.getUserMaxAttempts(usr) - 1L;
        usr.setFailedLogins(Long.valueOf(failedLogins));
        usr.setLocked(Boolean.valueOf(false));
        usr.setLockedDate(null);
        usr = this.userDAO.save(usr);
        this.sendPasswordEmail(usr, realPassword);
        AuditLog log = new AuditLog("USER_RESET");
        log.setLogin(usr.getLogin());
        this.logAction(AuditActionContextLOV.USR, AuditActionTypeLOV.RESET, log);
    }

    private String createPassword() {
        return UUID.randomUUID().toString().substring(0, 6);
    }

    private void sendPasswordEmail(User user, String realPassword) {
        if (user.getEmail() == null) {
            throw new BusinessCodedException("business.password.noemail", new Object[]{user.getLogin()});
        }
        try {
            Context ctx = Context.get();
            Locale currentLocale = new Locale(ctx.getLanguage(), ctx.getCountry());
            ResourceBundle myResources = ResourceBundle.getBundle(ManagementService.class.getName(), currentLocale);
            String body = MessageFormat.format(myResources.getString("mail.body"), user.getLogin(), realPassword);
            this.mailClient.sendMessage(null, user.getEmail(), myResources.getString("mail.subject"), body);
        }
        catch (MessagingException e) {
            logger.error("Unable to send e-mail", (Throwable)e);
            throw new BusinessCodedException("business.password.email.send");
        }
    }

    @Override
    protected Page<User> handleSearchUsers(UserSearchDTO criteria) throws Exception {
        Page<User> page = this.userDAO.search(criteria);
        if (page.getResults() != null) {
            for (User usr : page.getResults()) {
                this.userDAO.loadClientOrOperationalArea(usr);
            }
        }
        return page;
    }

    @Override
    protected void handleRemoveUser(String id, Long version) throws Exception {
        User user = this.userDAO.softDeleteByIdVersion(id, version);
        AuditLog log = new AuditLog("USER_REMOVE");
        log.setLogin(user.getLogin());
        this.logAction(AuditActionContextLOV.USR, AuditActionTypeLOV.REMOVE, log);
    }

    @Override
    protected Page<ClientEntity> handleSearchClients(ClientSearchDTO criteria) throws Exception {
        User user = Context.get().getUser();
        List<String> clientIds = null;
        if (user.getOperationalAreaId() != null) {
            clientIds = this.dtcDAO.findClientIdsNotInOperationalArea(user.getOperationalAreaId());
        } else if (user.getClientId() != null) {
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                page.setCount(1L);
            } else {
                ArrayList<ClientEntity> clients = new ArrayList<ClientEntity>();
                clients.add(this.clientEntityDAO.findById(user.getClientId()));
                page.setResults(clients);
                page.setLast(true);
            }
            return page;
        }
        return this.clientEntityDAO.search(criteria, clientIds);
    }

    @Override
    protected void handleRemoveClient(String clientId) throws Exception {
        ClientEntity client = this.clientEntityDAO.findById(clientId);
        if (client != null) {
            this.clientEntityDAO.loadDtcs(client);
            for (Dtc dtc : client.getDtcs()) {
                dtc.setClientId(null);
                this.dtcDAO.save(dtc);
            }
            this.clientEntityDAO.loadUsers(client);
            for (User user : client.getUsers()) {
                this.handleRemoveUser(user.getId(), user.getVersion().longValue());
            }
            this.clientEntityDAO.remove(client);
            AuditLog log = new AuditLog("CLIENT_REMOVE");
            log.setName(client.getName());
            this.logAction(AuditActionContextLOV.CLI, AuditActionTypeLOV.REMOVE, log);
        }
    }

    @Override
    protected ClientEntity handleAddClient(ClientEntity entidade) throws Exception {
        ClientEntity other = this.clientEntityDAO.findByName(entidade.getName());
        if (other != null) {
            throw new BusinessException("message.create.error.alreadyexists", new Object[]{entidade.getName()});
        }
        AuditLog log = new AuditLog("CLIENT_ADD");
        log.setName(entidade.getName());
        this.logAction(AuditActionContextLOV.CLI, AuditActionTypeLOV.ADD, log);
        return this.clientEntityDAO.save(entidade);
    }

    @Override
    protected ClientEntity handleRenameClient(String clientId, String name) throws Exception {
        ClientEntity client = this.clientEntityDAO.findById(clientId);
        ClientEntity ce = this.clientEntityDAO.findByName(name);
        if (ce != null && !ce.equals((Object)clientId)) {
            throw new BusinessCodedException("error.client.name.alreadyexists");
        }
        AuditLog log = new AuditLog("CLIENT_ADD");
        log.setOldName(client.getName());
        log.setName(name);
        this.logAction(AuditActionContextLOV.CLI, AuditActionTypeLOV.MODIFY, log);
        client.setName(name);
        return this.clientEntityDAO.save(client);
    }

    private void saveSetting(String name, String value) {
        ApplicationSetting as = this.applicationSettingDAO.findByName(name);
        if (as == null) {
            as = new ApplicationSetting();
        }
        as.setName(name);
        as.setValue(value);
        this.applicationSettingDAO.save(as);
    }

    private String findSetting(String name) {
        ApplicationSetting setting = this.applicationSettingDAO.findByName(name);
        if (setting != null) {
            return setting.getValue();
        }
        return null;
    }

    @Override
    protected String handleGetEmailSuport() throws Exception {
        return this.findSetting(EMAIL_SUPPORT);
    }

    @Override
    protected void handleSetEmailSuport(String value) throws Exception {
        this.saveSetting(EMAIL_SUPPORT, value);
    }

    protected Long getAdminMaxAttempts() {
        return Strings.toLong((String)this.findSetting(ADMIN_MAX_ATTEMPTS), (Long)3L);
    }

    protected void setAdminMaxAttempts(Long adminMaxAttempts) throws Exception {
        this.saveSetting(ADMIN_MAX_ATTEMPTS, adminMaxAttempts == null ? null : adminMaxAttempts.toString());
    }

    protected Long getClientMaxAttempts() {
        return Strings.toLong((String)this.findSetting(CLIENT_MAX_ATTEMPTS), (Long)3L);
    }

    protected void setClientMaxAttempts(Long clientMaxAttempts) {
        this.saveSetting(CLIENT_MAX_ATTEMPTS, clientMaxAttempts == null ? null : clientMaxAttempts.toString());
    }

    protected Long getOperatorMaxAttempts() throws Exception {
        return Strings.toLong((String)this.findSetting(OPERATOR_MAX_ATTEMPTS), (Long)3L);
    }

    protected void setOperatorMaxAttempts(Long operatorMaxAttempts) {
        this.saveSetting(OPERATOR_MAX_ATTEMPTS, operatorMaxAttempts == null ? null : operatorMaxAttempts.toString());
    }

    protected Long getAdminMaxBlockMinutes() throws Exception {
        return Strings.toLong((String)this.findSetting(ADMIN_MAX_BLOCK_MINUTES), (Long)10L);
    }

    protected void setAdminMaxBlockMinutes(Long adminMaxBlockMinutes) {
        this.saveSetting(ADMIN_MAX_BLOCK_MINUTES, adminMaxBlockMinutes == null ? null : adminMaxBlockMinutes.toString());
    }

    @Override
    protected UserEditDTO handleGetUserEdit(String id) throws Exception {
        UserEditDTO dto = new UserEditDTO();
        if (id != null) {
            User u = this.userDAO.findById(id);
            this.userDAO.loadClientOrOperationalArea(u);
            dto.setUser(u);
        }
        dto.setClients(this.clientEntityDAO.findAll());
        dto.setOperationalAreas(this.operationalAreaDAO.findAll());
        return dto;
    }
}

