/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.service;

import java.util.List;
import javax.persistence.OptimisticLockException;
import org.springframework.transaction.annotation.Transactional;
import pt.efacec.smartlighting.business.spring.Monitor;
import pt.efacec.smartlighting.business.spring.Safe;
import pt.efacec.smartlighting.common.core.entity.Alarm;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcState;
import pt.efacec.smartlighting.common.core.lov.SynchronizationErrorLOV;
import pt.efacec.smartlighting.common.core.service.IDtcManagementService;
import pt.efacec.smartlighting.common.dto.DtcScheduleDTO;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.misc.Log;

public abstract class DtcManagementServiceBase
implements IDtcManagementService {
    private static final Log logger = Log.getLogger(DtcManagementServiceBase.class);

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public void synchronizeDTCsForProfile(String profileId) {
        if (profileId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"DtcManagementService.synchronizeDTCsForProfile", "profileId"});
        }
        try {
            this.handleSynchronizeDTCsForProfile(profileId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing synchronizeDTCsForProfile.", e);
        }
    }

    protected abstract void handleSynchronizeDTCsForProfile(String var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public void synchronizeOneDTC(String dtcId) {
        try {
            this.handleSynchronizeOneDTC(dtcId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing synchronizeOneDTC.", e);
        }
    }

    protected abstract void handleSynchronizeOneDTC(String var1) throws Exception;

    @Safe(value={"USER", "OPERATOR"})
    @Monitor
    @Transactional
    public void synchronizeDTCs(List<String> dtcIds) {
        if (dtcIds == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"DtcManagementService.synchronizeDTCs", "dtcIds"});
        }
        try {
            this.handleSynchronizeDTCs(dtcIds);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing synchronizeDTCs.", e);
        }
    }

    protected abstract void handleSynchronizeDTCs(List<String> var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public DtcState markDtcAsUpdating(DtcState dtcState) {
        try {
            return this.handleMarkDtcAsUpdating(dtcState);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing markDtcAsUpdating.", e);
        }
    }

    protected abstract DtcState handleMarkDtcAsUpdating(DtcState var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public DtcState markDtcAsUpdated(DtcState dtcState) {
        try {
            return this.handleMarkDtcAsUpdated(dtcState);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing markDtcAsUpdated.", e);
        }
    }

    protected abstract DtcState handleMarkDtcAsUpdated(DtcState var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public DtcState markDtcAsFailed(DtcState dtcState, SynchronizationErrorLOV error) {
        try {
            return this.handleMarkDtcAsFailed(dtcState, error);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing markDtcAsFailed.", e);
        }
    }

    protected abstract DtcState handleMarkDtcAsFailed(DtcState var1, SynchronizationErrorLOV var2) throws Exception;

    @Safe(value={"INTERNAL"})
    @Monitor
    @Transactional
    public void sendTimetablesToDTC() {
        try {
            this.handleSendTimetablesToDTC();
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing sendTimetablesToDTC.", e);
        }
    }

    protected abstract void handleSendTimetablesToDTC() throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Alarm saveAlarm(Alarm alarm) {
        try {
            return this.handleSaveAlarm(alarm);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing saveAlarm.", e);
        }
    }

    protected abstract Alarm handleSaveAlarm(Alarm var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Dtc findDtcWithServices(String dtcId) {
        try {
            return this.handleFindDtcWithServices(dtcId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing findDtcWithServices.", e);
        }
    }

    protected abstract Dtc handleFindDtcWithServices(String var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public DtcScheduleDTO findTimetableForDtc(String dtcId, Boolean loadEntries) {
        try {
            return this.handleFindTimetableForDtc(dtcId, loadEntries);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing findTimetableForDtc.", e);
        }
    }

    protected abstract DtcScheduleDTO handleFindTimetableForDtc(String var1, Boolean var2) throws Exception;

    @Safe(value={"USER", "OPERATOR"})
    @Monitor
    @Transactional
    public void synchronizeDTCs() {
        try {
            this.handleSynchronizeDTCs();
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing synchronizeDTCs.", e);
        }
    }

    protected abstract void handleSynchronizeDTCs() throws Exception;
}

