/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.service;

import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import pt.efacec.smartlighting.business.core.entitydao.IAlarmDAO;
import pt.efacec.smartlighting.business.core.entitydao.IControlDAO;
import pt.efacec.smartlighting.business.core.entitydao.IDtcDAO;
import pt.efacec.smartlighting.business.core.entitydao.IDtcServiceDAO;
import pt.efacec.smartlighting.business.core.entitydao.IDtcStateDAO;
import pt.efacec.smartlighting.business.core.entitydao.IPeriodDAO;
import pt.efacec.smartlighting.business.core.entitydao.IProfileDAO;
import pt.efacec.smartlighting.business.core.entitydao.IServiceDAO;
import pt.efacec.smartlighting.business.core.entitydao.ISpecialDayDAO;
import pt.efacec.smartlighting.business.core.entitydao.ISpecialDayServiceDAO;
import pt.efacec.smartlighting.business.core.entitydao.ITimetableDAO;
import pt.efacec.smartlighting.business.core.service.DtcManagementServiceBase;
import pt.efacec.smartlighting.common.business.service.IDtcEntityService;
import pt.efacec.smartlighting.common.business.service.IDtcStateEntityService;
import pt.efacec.smartlighting.common.core.entity.Alarm;
import pt.efacec.smartlighting.common.core.entity.Control;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.DtcState;
import pt.efacec.smartlighting.common.core.entity.Period;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.Service;
import pt.efacec.smartlighting.common.core.entity.SpecialDay;
import pt.efacec.smartlighting.common.core.entity.SpecialDayService;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.core.lov.ModeLOV;
import pt.efacec.smartlighting.common.core.lov.SynchronizationErrorLOV;
import pt.efacec.smartlighting.common.core.lov.SynchronizationStateLOV;
import pt.efacec.smartlighting.common.core.service.IDtcManagementService;
import pt.efacec.smartlighting.common.domain.DtcServiceTimeTable;
import pt.efacec.smartlighting.common.domain.ETimeTableType;
import pt.efacec.smartlighting.common.domain.StandardPeriodDTO;
import pt.efacec.smartlighting.common.dto.DtcScheduleDTO;
import pt.efacec.smartlighting.common.dto.DtcScheduleInfo;
import pt.efacec.smartlighting.common.dto.DtcScheduleService;
import pt.efacec.smartlighting.common.misc.Converters;
import pt.efacec.smartlighting.common.service.IGatewayService;
import pt.efacec.smartlighting.common.util.Context;
import pt.efacec.smartlighting.common.util.SLContextRunnable;
import pt.efacec.toolkit.misc.Log;
import pt.efacec.toolkit.misc.Tool;

@org.springframework.stereotype.Service(value="dtcMangementService")
@Transactional
public class DtcManagementService
extends DtcManagementServiceBase {
    private static final Log logger = Log.getLogger(DtcManagementService.class);
    protected static final int POOL_SIZE = 10;
    protected static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(10);
    private static final Context.AttributeKey<Set<String>> DTC_IDS = new Context.AttributeKey<Set<String>>(){};
    @Autowired
    private IDtcDAO dtcDAO;
    @Autowired
    private IDtcStateDAO dtcStateDAO;
    @Autowired
    private IDtcStateEntityService dtcStateEntityService;
    @Autowired
    private IDtcEntityService dtcEntityService;
    @Resource
    private IGatewayService gatewayService;
    @Autowired
    private IAlarmDAO alarmDAO;
    @Autowired
    private IDtcServiceDAO dtcServiceDAO;
    @Autowired
    private IPeriodDAO periodDAO;
    @Autowired
    private IControlDAO controlDAO;
    @Autowired
    private IProfileDAO profileDAO;
    @Autowired
    private IServiceDAO serviceDAO;
    @Autowired
    private ISpecialDayDAO specialDayDAO;
    @Autowired
    private ISpecialDayServiceDAO specialDayServiceDAO;
    @Autowired
    private ITimetableDAO timetableDAO;
    @Resource
    private IDtcManagementService dtcMangementService;

    @Override
    protected void handleSynchronizeDTCsForProfile(String profileId) throws Exception {
        ArrayList<String> dtcIds = new ArrayList<String>();
        for (Dtc dtc : this.dtcDAO.findAllByProfile(profileId)) {
            dtcIds.add(dtc.getId());
        }
        if (!dtcIds.isEmpty()) {
            this.handleSynchronizeDTCs(dtcIds);
        }
    }

    @Override
    protected void handleSynchronizeOneDTC(String dtcId) throws Exception {
        if (dtcId != null) {
            this.handleSynchronizeDTCs(Arrays.asList(dtcId));
        }
    }

    @Override
    protected void handleSynchronizeDTCs(List<String> ids) {
        Context ctx = Context.get();
        HashSet<String> dtcIds = (HashSet<String>)ctx.getAttribute(DTC_IDS);
        if (dtcIds == null) {
            dtcIds = new HashSet<String>();
            ctx.setAttribute(DTC_IDS, dtcIds);
        }
        dtcIds.addAll(ids);
    }

    @Override
    protected void handleSendTimetablesToDTC() {
        Context ctx = Context.get();
        final Set dtcIds = (Set)ctx.getAttribute(DTC_IDS);
        if (dtcIds != null) {
            for (String id : dtcIds) {
                this.dtcStateDAO.markAsDirty(id);
            }
            ctx.removeAttribute(DTC_IDS);
            if (!dtcIds.isEmpty()) {
                scheduler.schedule((Runnable)new SLContextRunnable(){

                    public void execute() {
                        for (String dtcId : dtcIds) {
                            DtcState state = DtcManagementService.this.dtcStateEntityService.findById(dtcId);
                            if (state == null || state.getState() != SynchronizationStateLOV.PENDING) {
                                return;
                            }
                            Dtc dtc = DtcManagementService.this.dtcEntityService.findById(dtcId);
                            String ipAddress = dtc.getIpAddress();
                            String lastChange = state.getLastChange();
                            try {
                                state = DtcManagementService.this.dtcMangementService.markDtcAsUpdating(state);
                                List timetables = DtcManagementService.this.loadTimeTables(dtc);
                                StringBuilder stringified = new StringBuilder();
                                for (DtcServiceTimeTable tt : timetables) {
                                    stringified.append(tt.stringified());
                                }
                                if (!stringified.toString().equals(state.getLastChange())) {
                                    logger.debug((Object)"timetables have changed. propagating change to the gateway.");
                                    state.setLastChange(stringified.toString());
                                    DtcManagementService.this.gatewayService.setTimetable(ipAddress, timetables);
                                }
                                DtcManagementService.this.dtcMangementService.markDtcAsUpdated(state);
                            }
                            catch (Throwable e) {
                                SynchronizationErrorLOV error = null;
                                if (Tool.hasStackedException((Throwable)e, ConnectException.class)) {
                                    error = SynchronizationErrorLOV.GATEWAY_CONNECTION;
                                    logger.error((Object)"Gateway is offline");
                                } else {
                                    error = SynchronizationErrorLOV.UNKNOWN;
                                    logger.error("Unable to Synchronize DTC.", e);
                                }
                                state.setLastChange(lastChange);
                                DtcManagementService.this.dtcMangementService.markDtcAsFailed(state, error);
                            }
                        }
                    }
                }, 2L, TimeUnit.SECONDS);
            }
        }
    }

    private List<DtcServiceTimeTable> loadTimeTables(Dtc dtc) {
        List services;
        ArrayList<DtcServiceTimeTable> timetables = new ArrayList<DtcServiceTimeTable>();
        DtcScheduleDTO schedules = this.findTimetableForDtc(dtc.getId(), true);
        DtcScheduleInfo base = schedules.getBase();
        if (base != null && !base.getEntries().isEmpty()) {
            timetables.add(new DtcServiceTimeTable(base.getName(), ETimeTableType.BASE, base.getEntries()));
        }
        if ((services = schedules.getServices()) != null && !services.isEmpty()) {
            ArrayList<DtcServiceTimeTable> entries = new ArrayList<DtcServiceTimeTable>();
            for (DtcScheduleService schedule : services) {
                DtcScheduleInfo info = schedule.getSpecific();
                if (info.getEntries().isEmpty()) continue;
                entries.add(new DtcServiceTimeTable(schedule.getServiceName(), ETimeTableType.SERVICE, info.getEntries()));
            }
            if (!entries.isEmpty()) {
                Collections.sort(entries);
                timetables.addAll(entries);
            }
            entries = new ArrayList();
            for (DtcScheduleService schedule : services) {
                if (schedule.getSpecialDays().isEmpty()) continue;
                entries.add(new DtcServiceTimeTable(schedule.getServiceName(), ETimeTableType.SPECIAL_DAY, schedule.getSpecialDays()));
            }
            if (!entries.isEmpty()) {
                Collections.sort(entries);
                timetables.addAll(entries);
            }
        }
        return timetables;
    }

    private List<StandardPeriodDTO> getTimetableEntries(String timetableId) {
        ArrayList<StandardPeriodDTO> entries = new ArrayList<StandardPeriodDTO>();
        List<Period> periods = this.periodDAO.findAllByTimetableOrderByStart(timetableId);
        for (Period period : periods) {
            StandardPeriodDTO entry = new StandardPeriodDTO();
            entry.setStart(period.getStart());
            entry.setEnd(period.getEnd());
            this.getTimetableControlsByPeriod(entry, period.getId());
            entries.add(entry);
        }
        return entries;
    }

    private void getTimetableControlsByPeriod(StandardPeriodDTO entry, String periodId) {
        this.convertControls(entry, this.controlDAO.findAllByPeriodOrderByOrder(periodId));
    }

    private void getTimetableControlsBySepcialDayService(StandardPeriodDTO entry, String specialDayServiceId) {
        this.convertControls(entry, this.controlDAO.findAllBySpecialDayService(specialDayServiceId));
    }

    private void convertControls(StandardPeriodDTO entry, List<Control> controls) {
        for (Control control : controls) {
            if (control.getTargetState().booleanValue()) {
                entry.setOnMode(Converters.fromModeLOV((ModeLOV)control.getMode()));
                entry.setOnTime(control.getTime());
                entry.setOnOffset(control.getOffset());
                continue;
            }
            entry.setOffMode(Converters.fromModeLOV((ModeLOV)control.getMode()));
            entry.setOffTime(control.getTime());
            entry.setOffOffset(control.getOffset());
        }
    }

    @Override
    protected DtcState handleMarkDtcAsUpdating(DtcState dtcState) throws Exception {
        return this.markAs(dtcState, SynchronizationStateLOV.PENDING, null);
    }

    @Override
    protected DtcState handleMarkDtcAsUpdated(DtcState dtcState) throws Exception {
        return this.markAs(dtcState, SynchronizationStateLOV.UPDATED, null);
    }

    @Override
    protected DtcState handleMarkDtcAsFailed(DtcState dtcState, SynchronizationErrorLOV error) throws Exception {
        return this.markAs(dtcState, SynchronizationStateLOV.ERROR, error);
    }

    private DtcState markAs(DtcState dtcState, SynchronizationStateLOV state, SynchronizationErrorLOV error) {
        dtcState.setState(state);
        dtcState.setErrorType(error);
        dtcState.setOperationTime(new Date());
        return this.dtcStateDAO.save(dtcState);
    }

    @Override
    protected Alarm handleSaveAlarm(Alarm alarm) throws Exception {
        return this.alarmDAO.save(alarm);
    }

    @Override
    protected Dtc handleFindDtcWithServices(String dtcId) throws Exception {
        Dtc dtc = this.dtcDAO.findById(dtcId);
        this.dtcDAO.loadServices(dtc);
        return dtc;
    }

    private void loadSpecialDayEntriesForService(Map<Date, StandardPeriodDTO> entries, List<SpecialDay> specialDays, String serviceName) {
        for (SpecialDay specialDay : specialDays) {
            SpecialDayService specialDayService = this.specialDayServiceDAO.findByNameAndSpecialDay(serviceName, specialDay.getId());
            if (specialDayService == null) continue;
            StandardPeriodDTO entry = new StandardPeriodDTO();
            entry.setStart(specialDay.getDay());
            entry.setEnd(specialDay.getDay());
            this.getTimetableControlsBySepcialDayService(entry, specialDayService.getId());
            entries.put(specialDay.getDay(), entry);
        }
    }

    private List<StandardPeriodDTO> getTimetableForSpecialDays(Dtc dtc, String serviceName) {
        TreeMap<Date, StandardPeriodDTO> entries = new TreeMap<Date, StandardPeriodDTO>();
        if (dtc.getProfileId() != null) {
            this.loadSpecialDayEntriesForService(entries, this.specialDayDAO.findAllByProfile(dtc.getProfileId()), serviceName);
        }
        this.loadSpecialDayEntriesForService(entries, this.specialDayDAO.findAllByDtc(dtc.getId()), serviceName);
        return new ArrayList<StandardPeriodDTO>(entries.values());
    }

    private List<StandardPeriodDTO> getTimetableForDtc(Dtc dtc) {
        if (dtc.getTimetableId() != null) {
            return this.getTimetableEntries(dtc.getTimetableId());
        }
        if (dtc.getProfileId() != null) {
            Profile profile = this.profileDAO.findById(dtc.getProfileId());
            return this.getTimetableEntries(profile.getTimetableId());
        }
        return new ArrayList<StandardPeriodDTO>();
    }

    @Override
    protected DtcScheduleDTO handleFindTimetableForDtc(String dtcId, Boolean loadEntries) {
        Dtc dtc = this.dtcDAO.findById(dtcId);
        List<DtcService> services = this.dtcServiceDAO.findAllByDtc(dtcId);
        DtcScheduleDTO dto = new DtcScheduleDTO();
        DtcScheduleInfo base = new DtcScheduleInfo();
        dto.setBase(base);
        Timetable tt = null;
        if (dtc.getTimetableId() != null) {
            tt = this.timetableDAO.findById(dtc.getTimetableId());
        } else if (dtc.getProfileId() != null) {
            Profile profile = this.profileDAO.findById(dtc.getProfileId());
            tt = this.timetableDAO.findById(profile.getTimetableId());
        }
        if (tt != null) {
            base.setName(tt.getName());
            base.setId(tt.getId());
            if (loadEntries.booleanValue()) {
                base.setEntries(this.getTimetableForDtc(dtc));
            }
        }
        ArrayList<DtcScheduleService> dtcServices = new ArrayList<DtcScheduleService>();
        dto.setServices(dtcServices);
        if (dtc.getProfileId() != null) {
            for (DtcService service : services) {
                DtcScheduleService dtcScheduleService = new DtcScheduleService();
                dtcServices.add(dtcScheduleService);
                dtcScheduleService.setServiceName(service.getName());
                DtcScheduleInfo specific = new DtcScheduleInfo();
                dtcScheduleService.setSpecific(specific);
                Service srv = this.serviceDAO.findByNameAndProfile(service.getName(), dtc.getProfileId());
                if (srv != null && srv.getTimetableId() != null) {
                    tt = this.timetableDAO.findById(srv.getTimetableId());
                    specific.setName(tt.getName());
                    specific.setId(tt.getId());
                    if (loadEntries.booleanValue()) {
                        specific.setEntries(this.getTimetableEntries(tt.getId()));
                    }
                }
                if (!loadEntries.booleanValue()) continue;
                dtcScheduleService.setSpecialDays(this.getTimetableForSpecialDays(dtc, srv.getName()));
            }
        }
        this.dtcDAO.loadState(dtc);
        SynchronizationStateLOV state = dtc.getState().getState();
        dto.setUnsynchronized(Boolean.valueOf(state == SynchronizationStateLOV.DIRTY || state == SynchronizationStateLOV.ERROR));
        return dto;
    }

    @Override
    protected void handleSynchronizeDTCs() throws Exception {
        List<String> ids = this.dtcStateDAO.findIdsToSynchronize();
        if (!ids.isEmpty()) {
            this.synchronizeDTCs(ids);
            this.sendTimetablesToDTC();
        }
    }
}

