/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.service;

import java.util.List;
import javax.persistence.OptimisticLockException;
import org.springframework.transaction.annotation.Transactional;
import pt.efacec.smartlighting.business.spring.Monitor;
import pt.efacec.smartlighting.business.spring.Safe;
import pt.efacec.smartlighting.common.core.dto.ClientDtcSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcAssociationSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcChildSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcClientAssociationSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcEditDTO;
import pt.efacec.smartlighting.common.core.dto.ProfileChildSearchDTO;
import pt.efacec.smartlighting.common.core.dto.ProfileEditDTO;
import pt.efacec.smartlighting.common.core.dto.ProfileSearchDTO;
import pt.efacec.smartlighting.common.core.dto.ScheduleDTO;
import pt.efacec.smartlighting.common.core.dto.ServiceEditDTO;
import pt.efacec.smartlighting.common.core.dto.SpecialDaySearchDTO;
import pt.efacec.smartlighting.common.core.dto.SpecialDayServiceSearchDTO;
import pt.efacec.smartlighting.common.core.dto.TimetableSearchDTO;
import pt.efacec.smartlighting.common.core.entity.District;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.Municipality;
import pt.efacec.smartlighting.common.core.entity.OperationalArea;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.Service;
import pt.efacec.smartlighting.common.core.entity.SpecialDay;
import pt.efacec.smartlighting.common.core.entity.SpecialDayService;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.core.service.IConfigurationService;
import pt.efacec.smartlighting.common.domain.StandardPeriodDTO;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class ConfigurationServiceBase
implements IConfigurationService {
    private static final Log logger = Log.getLogger(ConfigurationServiceBase.class);

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<Profile> searchProfiles(ProfileSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.searchProfiles", "criteria"});
        }
        try {
            return this.handleSearchProfiles(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchProfiles.", e);
        }
    }

    protected abstract Page<Profile> handleSearchProfiles(ProfileSearchDTO var1) throws Exception;

    @Safe(value={"OPERATOR"})
    @Monitor
    @Transactional
    public void removeProfile(String profileId) {
        try {
            this.handleRemoveProfile(profileId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing removeProfile.", e);
        }
    }

    protected abstract void handleRemoveProfile(String var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public ProfileEditDTO getProfileForEdit(String profileId) {
        try {
            return this.handleGetProfileForEdit(profileId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing getProfileForEdit.", e);
        }
    }

    protected abstract ProfileEditDTO handleGetProfileForEdit(String var1) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public Profile saveProfile(Profile profile) {
        try {
            return this.handleSaveProfile(profile);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing saveProfile.", e);
        }
    }

    protected abstract Profile handleSaveProfile(Profile var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public List<Timetable> getTimetables(String operationalAreaId) {
        if (operationalAreaId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.getTimetables", "operationalAreaId"});
        }
        try {
            return this.handleGetTimetables(operationalAreaId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing getTimetables.", e);
        }
    }

    protected abstract List<Timetable> handleGetTimetables(String var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<ScheduleDTO> searchTimetables(TimetableSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.searchTimetables", "criteria"});
        }
        try {
            return this.handleSearchTimetables(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchTimetables.", e);
        }
    }

    protected abstract Page<ScheduleDTO> handleSearchTimetables(TimetableSearchDTO var1) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public void removeTimetable(String timetableId, Long version) {
        if (timetableId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.removeTimetable", "timetableId"});
        }
        if (version == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.removeTimetable", "version"});
        }
        try {
            this.handleRemoveTimetable(timetableId, version);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing removeTimetable.", e);
        }
    }

    protected abstract void handleRemoveTimetable(String var1, Long var2) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public String copyTimetable(String timetableId, String suffix) {
        if (timetableId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.copyTimetable", "timetableId"});
        }
        try {
            return this.handleCopyTimetable(timetableId, suffix);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing copyTimetable.", e);
        }
    }

    protected abstract String handleCopyTimetable(String var1, String var2) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Timetable findTimetableByServiceAndDtc(String serviceName, String dtcId) {
        try {
            return this.handleFindTimetableByServiceAndDtc(serviceName, dtcId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing findTimetableByServiceAndDtc.", e);
        }
    }

    protected abstract Timetable handleFindTimetableByServiceAndDtc(String var1, String var2) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public List<StandardPeriodDTO> findPeriodsByTimetable(String timetableId) {
        if (timetableId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.findPeriodsByTimetable", "timetableId"});
        }
        try {
            return this.handleFindPeriodsByTimetable(timetableId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing findPeriodsByTimetable.", e);
        }
    }

    protected abstract List<StandardPeriodDTO> handleFindPeriodsByTimetable(String var1) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public void saveTimetable(Timetable timetable, List<StandardPeriodDTO> periods) {
        if (periods == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.saveTimetable", "periods"});
        }
        try {
            this.handleSaveTimetable(timetable, periods);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing saveTimetable.", e);
        }
    }

    protected abstract void handleSaveTimetable(Timetable var1, List<StandardPeriodDTO> var2) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<SpecialDay> searchProfileSpecialDays(ProfileChildSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.searchProfileSpecialDays", "criteria"});
        }
        try {
            return this.handleSearchProfileSpecialDays(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchProfileSpecialDays.", e);
        }
    }

    protected abstract Page<SpecialDay> handleSearchProfileSpecialDays(ProfileChildSearchDTO var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<Service> searchProfileServices(ProfileChildSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.searchProfileServices", "criteria"});
        }
        try {
            return this.handleSearchProfileServices(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchProfileServices.", e);
        }
    }

    protected abstract Page<Service> handleSearchProfileServices(ProfileChildSearchDTO var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<Dtc> searchProfileDTCs(ProfileChildSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.searchProfileDTCs", "criteria"});
        }
        try {
            return this.handleSearchProfileDTCs(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchProfileDTCs.", e);
        }
    }

    protected abstract Page<Dtc> handleSearchProfileDTCs(ProfileChildSearchDTO var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public DtcEditDTO getDtcForEdit(String dtcId) {
        try {
            return this.handleGetDtcForEdit(dtcId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing getDtcForEdit.", e);
        }
    }

    protected abstract DtcEditDTO handleGetDtcForEdit(String var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Long saveDtcTimetable(String dtcId, Long version, String timetableId) {
        if (dtcId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.saveDtcTimetable", "dtcId"});
        }
        if (version == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.saveDtcTimetable", "version"});
        }
        try {
            return this.handleSaveDtcTimetable(dtcId, version, timetableId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing saveDtcTimetable.", e);
        }
    }

    protected abstract Long handleSaveDtcTimetable(String var1, Long var2, String var3) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<SpecialDay> searchDtcSpecialDays(DtcChildSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.searchDtcSpecialDays", "criteria"});
        }
        try {
            return this.handleSearchDtcSpecialDays(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchDtcSpecialDays.", e);
        }
    }

    protected abstract Page<SpecialDay> handleSearchDtcSpecialDays(DtcChildSearchDTO var1) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public List<Timetable> findTimetablesByOperationArea(String operationAreaId) {
        try {
            return this.handleFindTimetablesByOperationArea(operationAreaId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing findTimetablesByOperationArea.", e);
        }
    }

    protected abstract List<Timetable> handleFindTimetablesByOperationArea(String var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public List<Service> findServicesByDtc(String dtcId) {
        try {
            return this.handleFindServicesByDtc(dtcId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing findServicesByDtc.", e);
        }
    }

    protected abstract List<Service> handleFindServicesByDtc(String var1) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public void removeSpecialDay(String id, Long version) {
        if (id == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.removeSpecialDay", "id"});
        }
        if (version == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.removeSpecialDay", "version"});
        }
        try {
            this.handleRemoveSpecialDay(id, version);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing removeSpecialDay.", e);
        }
    }

    protected abstract void handleRemoveSpecialDay(String var1, Long var2) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public void setServiceTimetable(String serviceId, String timetableId) {
        try {
            this.handleSetServiceTimetable(serviceId, timetableId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing setServiceTimetable.", e);
        }
    }

    protected abstract void handleSetServiceTimetable(String var1, String var2) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public void unassignDTC(String dtcId, Long dtcVersion) {
        try {
            this.handleUnassignDTC(dtcId, dtcVersion);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing unassignDTC.", e);
        }
    }

    protected abstract void handleUnassignDTC(String var1, Long var2) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public void assignDTC(String dtcId, String profileId) {
        try {
            this.handleAssignDTC(dtcId, profileId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing assignDTC.", e);
        }
    }

    protected abstract void handleAssignDTC(String var1, String var2) throws Exception;

    @Safe(value={"OPERATOR"})
    @Monitor
    @Transactional
    public void unassignDTCFromClient(String dtcId, Long dtcVersion) {
        try {
            this.handleUnassignDTCFromClient(dtcId, dtcVersion);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing unassignDTCFromClient.", e);
        }
    }

    protected abstract void handleUnassignDTCFromClient(String var1, Long var2) throws Exception;

    @Safe(value={"OPERATOR"})
    @Monitor
    @Transactional
    public void assignDTCToClient(String dtcId, String clientId) {
        try {
            this.handleAssignDTCToClient(dtcId, clientId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing assignDTCToClient.", e);
        }
    }

    protected abstract void handleAssignDTCToClient(String var1, String var2) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<SpecialDayService> searchSpecialDayService(SpecialDayServiceSearchDTO criteria) {
        try {
            return this.handleSearchSpecialDayService(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchSpecialDayService.", e);
        }
    }

    protected abstract Page<SpecialDayService> handleSearchSpecialDayService(SpecialDayServiceSearchDTO var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public SpecialDay findSpecialDay(String specialDayId) {
        try {
            return this.handleFindSpecialDay(specialDayId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing findSpecialDay.", e);
        }
    }

    protected abstract SpecialDay handleFindSpecialDay(String var1) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public SpecialDay saveSpecialDay(SpecialDay specialDay) {
        try {
            return this.handleSaveSpecialDay(specialDay);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing saveSpecialDay.", e);
        }
    }

    protected abstract SpecialDay handleSaveSpecialDay(SpecialDay var1) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public SpecialDayService findSpecialDayService(String specialDayServiceId) {
        try {
            return this.handleFindSpecialDayService(specialDayServiceId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing findSpecialDayService.", e);
        }
    }

    protected abstract SpecialDayService handleFindSpecialDayService(String var1) throws Exception;

    @Safe(value={"OPERATOR", "ADMIN"})
    @Monitor
    @Transactional
    public SpecialDayService saveSpecialDayService(SpecialDayService specialDayService) {
        try {
            return this.handleSaveSpecialDayService(specialDayService);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing saveSpecialDayService.", e);
        }
    }

    protected abstract SpecialDayService handleSaveSpecialDayService(SpecialDayService var1) throws Exception;

    @Safe(value={"OPERATOR"})
    @Monitor
    @Transactional
    public void removeSpecialDayService(String id, Long version) {
        if (id == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.removeSpecialDayService", "id"});
        }
        if (version == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.removeSpecialDayService", "version"});
        }
        try {
            this.handleRemoveSpecialDayService(id, version);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing removeSpecialDayService.", e);
        }
    }

    protected abstract void handleRemoveSpecialDayService(String var1, Long var2) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<Dtc> searchAssociatedDtcs(DtcAssociationSearchDTO criteria) {
        try {
            return this.handleSearchAssociatedDtcs(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchAssociatedDtcs.", e);
        }
    }

    protected abstract Page<Dtc> handleSearchAssociatedDtcs(DtcAssociationSearchDTO var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<Dtc> searchClientAssociatedDtcs(DtcClientAssociationSearchDTO criteria) {
        try {
            return this.handleSearchClientAssociatedDtcs(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchClientAssociatedDtcs.", e);
        }
    }

    protected abstract Page<Dtc> handleSearchClientAssociatedDtcs(DtcClientAssociationSearchDTO var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public List<District> findAllDistricts() {
        try {
            return this.handleFindAllDistricts();
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing findAllDistricts.", e);
        }
    }

    protected abstract List<District> handleFindAllDistricts() throws Exception;

    @Safe
    @Monitor
    @Transactional
    public List<Municipality> findMunicipalitiesByDistrict(String districtId) {
        if (districtId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.findMunicipalitiesByDistrict", "districtId"});
        }
        try {
            return this.handleFindMunicipalitiesByDistrict(districtId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing findMunicipalitiesByDistrict.", e);
        }
    }

    protected abstract List<Municipality> handleFindMunicipalitiesByDistrict(String var1) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public ServiceEditDTO getServiceForEdit(String serviceId, String operationalAreaId) {
        if (serviceId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.getServiceForEdit", "serviceId"});
        }
        if (operationalAreaId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.getServiceForEdit", "operationalAreaId"});
        }
        try {
            return this.handleGetServiceForEdit(serviceId, operationalAreaId);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing getServiceForEdit.", e);
        }
    }

    protected abstract ServiceEditDTO handleGetServiceForEdit(String var1, String var2) throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<SpecialDay> searchSpecialDays(SpecialDaySearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ConfigurationService.searchSpecialDays", "criteria"});
        }
        try {
            return this.handleSearchSpecialDays(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchSpecialDays.", e);
        }
    }

    protected abstract Page<SpecialDay> handleSearchSpecialDays(SpecialDaySearchDTO var1) throws Exception;

    @Safe(value={"ADMIN"})
    @Monitor
    @Transactional
    public List<OperationalArea> findAllOperationalAreas() {
        try {
            return this.handleFindAllOperationalAreas();
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing findAllOperationalAreas.", e);
        }
    }

    protected abstract List<OperationalArea> handleFindAllOperationalAreas() throws Exception;

    @Safe(value={"USER"})
    @Monitor
    @Transactional
    public Page<Dtc> searchClientDtcs(ClientDtcSearchDTO criteria) {
        try {
            return this.handleSearchClientDtcs(criteria);
        }
        catch (OptimisticLockException e) {
            logger.debug((Object)e);
            throw new BusinessCodedException("error.OptimisticLockException");
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("An error ocurred when executing searchClientDtcs.", e);
        }
    }

    protected abstract Page<Dtc> handleSearchClientDtcs(ClientDtcSearchDTO var1) throws Exception;
}

