/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import pt.efacec.smartlighting.business.core.entitydao.IAuditActionDAO;
import pt.efacec.smartlighting.business.core.entitydao.IClientEntityDAO;
import pt.efacec.smartlighting.business.core.entitydao.IControlDAO;
import pt.efacec.smartlighting.business.core.entitydao.IDistrictDAO;
import pt.efacec.smartlighting.business.core.entitydao.IDtcDAO;
import pt.efacec.smartlighting.business.core.entitydao.IMunicipalityDAO;
import pt.efacec.smartlighting.business.core.entitydao.IOperationalAreaDAO;
import pt.efacec.smartlighting.business.core.entitydao.IPeriodDAO;
import pt.efacec.smartlighting.business.core.entitydao.IProfileDAO;
import pt.efacec.smartlighting.business.core.entitydao.IServiceDAO;
import pt.efacec.smartlighting.business.core.entitydao.ISpecialDayDAO;
import pt.efacec.smartlighting.business.core.entitydao.ISpecialDayServiceDAO;
import pt.efacec.smartlighting.business.core.entitydao.ITimetableDAO;
import pt.efacec.smartlighting.business.core.service.ConfigurationServiceBase;
import pt.efacec.smartlighting.common.core.dto.ClientDtcSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcAssociationSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcChildSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcClientAssociationSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcEditDTO;
import pt.efacec.smartlighting.common.core.dto.ProfileChildSearchDTO;
import pt.efacec.smartlighting.common.core.dto.ProfileEditDTO;
import pt.efacec.smartlighting.common.core.dto.ProfileSearchDTO;
import pt.efacec.smartlighting.common.core.dto.ScheduleDTO;
import pt.efacec.smartlighting.common.core.dto.ServiceEditDTO;
import pt.efacec.smartlighting.common.core.dto.SpecialDaySearchDTO;
import pt.efacec.smartlighting.common.core.dto.SpecialDayServiceSearchDTO;
import pt.efacec.smartlighting.common.core.dto.TimetableSearchDTO;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.Control;
import pt.efacec.smartlighting.common.core.entity.District;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.Municipality;
import pt.efacec.smartlighting.common.core.entity.OperationalArea;
import pt.efacec.smartlighting.common.core.entity.Period;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.Service;
import pt.efacec.smartlighting.common.core.entity.SpecialDay;
import pt.efacec.smartlighting.common.core.entity.SpecialDayService;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.core.lov.AuditActionContextLOV;
import pt.efacec.smartlighting.common.core.lov.AuditActionTypeLOV;
import pt.efacec.smartlighting.common.core.lov.ModeLOV;
import pt.efacec.smartlighting.common.core.service.IDtcManagementService;
import pt.efacec.smartlighting.common.domain.EModeExtended;
import pt.efacec.smartlighting.common.domain.StandardPeriodDTO;
import pt.efacec.smartlighting.common.dto.AuditLog;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.misc.Converters;
import pt.efacec.smartlighting.common.util.Context;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Strings;
import pt.efacec.toolkit.misc.Tool;
import pt.efacec.toolkit.misc.Transformer;

@org.springframework.stereotype.Service(value="configurationService")
@Transactional
public class ConfigurationService
extends ConfigurationServiceBase {
    @Autowired
    private IProfileDAO profileDAO;
    @Autowired
    private IDtcDAO dtcDAO;
    @Autowired
    private IServiceDAO serviceDAO;
    @Autowired
    private ISpecialDayDAO specialDayDAO;
    @Autowired
    private ISpecialDayServiceDAO specialDayServiceDAO;
    @Autowired
    private IOperationalAreaDAO operationalAreaDAO;
    @Autowired
    private ITimetableDAO timetableDAO;
    @Autowired
    private IPeriodDAO periodDAO;
    @Autowired
    private IControlDAO controlDAO;
    @Autowired
    private IDistrictDAO districtDAO;
    @Autowired
    private IMunicipalityDAO municipalityDAO;
    @Autowired
    private IClientEntityDAO clientEntityDAO;
    @Autowired
    private IAuditActionDAO auditActionDAO;
    @Autowired
    private IDtcManagementService dtcMangementService;
    private static final String ORDER_OA = "operationalArea";
    private static final String ORDER_CLIENT = "client";

    private void logAction(AuditActionContextLOV context, AuditActionTypeLOV action, AuditLog log) {
        this.auditActionDAO.logAction(Context.get().getUser(), context, action, log);
    }

    @Override
    protected Page<Profile> handleSearchProfiles(ProfileSearchDTO criteria) throws Exception {
        User user = Context.get().getUser();
        Page<Profile> page = this.profileDAO.search(criteria, user.getClientId(), user.getOperationalAreaId());
        if (!criteria.getCountRecords().booleanValue()) {
            List profiles = page.getResults();
            for (Profile profile : profiles) {
                this.profileDAO.loadOperationalArea(profile);
            }
        }
        return page;
    }

    @Override
    protected void handleRemoveProfile(String profileId) throws Exception {
        Profile profile = this.profileDAO.findById(profileId);
        if (profile != null) {
            this.profileDAO.loadDtcs(profile);
            if (profile.getDtcs().size() > 0) {
                throw new BusinessCodedException("dependencies.violation");
            }
            for (Service service : this.serviceDAO.findAllByProfile(profileId)) {
                this.serviceDAO.remove(service);
            }
            for (SpecialDay specialDay : this.specialDayDAO.findAllByProfile(profileId)) {
                this.internalRemoveSpecialDay(specialDay);
            }
            this.profileDAO.remove(profile);
            OperationalArea oa = this.operationalAreaDAO.findById(profile.getOperationalAreaId());
            AuditLog log = new AuditLog("PROFILE_REMOVE");
            log.setProfile(profile.getName());
            log.setOperationalArea(oa.getName());
            this.logAction(AuditActionContextLOV.PRF, AuditActionTypeLOV.REMOVE, log);
        }
    }

    @Override
    protected ProfileEditDTO handleGetProfileForEdit(String profileId) throws Exception {
        User user = Context.get().getUser();
        ProfileEditDTO dto = new ProfileEditDTO();
        Profile profile = null;
        if (profileId != null) {
            profile = this.profileDAO.findById(profileId);
            dto.setProfile(profile);
            this.profileDAO.loadOperationalArea(profile);
            this.profileDAO.loadTimetable(profile);
        }
        if (user.getClientId() != null) {
            if (profile != null) {
                dto.setOperationalAreas(Arrays.asList(profile.getOperationalArea()));
                dto.setTimetables(Arrays.asList(profile.getTimetable()));
            }
        } else if (user.getOperationalAreaId() != null) {
            dto.setOperationalAreas(Arrays.asList(this.operationalAreaDAO.findById(user.getOperationalAreaId())));
            dto.setTimetables(this.timetableDAO.findAllByOperationalArea(user.getOperationalAreaId()));
        } else {
            dto.setOperationalAreas(this.operationalAreaDAO.findAll());
            dto.setTimetables(new ArrayList());
        }
        return dto;
    }

    @Override
    protected List<Timetable> handleGetTimetables(String operationalAreaId) throws Exception {
        return new ArrayList<Timetable>(this.operationalAreaDAO.getTimetables(operationalAreaId));
    }

    private void checkProfileAccess(String profileId) {
        User user = Context.get().getUser();
        boolean found = false;
        if (user.getClientId() != null) {
            List<Dtc> dtcs = this.dtcDAO.findAllByClient(user.getClientId());
            for (Dtc dtc : dtcs) {
                if (dtc.getProfileId() == null || !dtc.getProfileId().equals(profileId)) continue;
                found = true;
                break;
            }
        } else if (user.getOperationalAreaId() != null) {
            Profile profile = this.profileDAO.findById(profileId);
            if (profile != null && profile.getOperationalAreaId().equals(user.getOperationalAreaId())) {
                found = true;
            }
        } else {
            found = true;
        }
        if (!found) {
            throw new BusinessCodedException("profile.invalid.request");
        }
    }

    @Override
    protected Page<SpecialDay> handleSearchProfileSpecialDays(ProfileChildSearchDTO criteria) throws Exception {
        this.checkProfileAccess(criteria.getProfileId());
        return this.specialDayDAO.searchForProfile(criteria);
    }

    @Override
    protected Page<Dtc> handleSearchProfileDTCs(ProfileChildSearchDTO criteria) throws Exception {
        this.checkProfileAccess(criteria.getProfileId());
        Page<Dtc> page = this.dtcDAO.search(criteria);
        if (page.getResults() != null) {
            for (Dtc dtc : page.getResults()) {
                this.dtcDAO.loadServices(dtc);
            }
        }
        return page;
    }

    @Override
    protected Page<Service> handleSearchProfileServices(ProfileChildSearchDTO criteria) throws Exception {
        this.checkProfileAccess(criteria.getProfileId());
        Page<Service> page = this.serviceDAO.search(criteria);
        if (page.getResults() != null) {
            for (Service service : page.getResults()) {
                this.serviceDAO.loadTimetable(service);
            }
        }
        return page;
    }

    @Override
    protected List<Timetable> handleFindTimetablesByOperationArea(String operationAreaId) throws Exception {
        User user = Context.get().getUser();
        if (user.getOperationalAreaId() != null) {
            return this.timetableDAO.findAllByOperationalArea(user.getOperationalAreaId());
        }
        return this.timetableDAO.findAllByOperationalArea(operationAreaId);
    }

    @Override
    protected Profile handleSaveProfile(Profile profile) throws Exception {
        User user = Context.get().getUser();
        boolean isNew = profile.getVersion() == null;
        String oaId = null;
        oaId = user.getOperationalAreaId() != null ? user.getOperationalAreaId() : profile.getOperationalAreaId();
        Profile prof = this.profileDAO.findByNameAndOperationalArea(profile.getName(), oaId);
        if (isNew ? prof != null : prof != null && !prof.getId().equals(profile.getId())) {
            throw new BusinessCodedException("profile.error.alreadyExists");
        }
        OperationalArea oa = this.operationalAreaDAO.findById(oaId);
        Timetable tt = this.timetableDAO.findById(profile.getTimetableId());
        if (isNew) {
            profile = this.profileDAO.save(profile);
            AuditLog log = new AuditLog("PROFILE_ADD");
            log.setProfile(profile.getName());
            log.setOperationalArea(oa.getName());
            log.setSchedule(tt.getName());
            this.logAction(AuditActionContextLOV.PRF, AuditActionTypeLOV.ADD, log);
        } else {
            Profile original = this.profileDAO.findPersisted(profile);
            Timetable ttOriginal = this.timetableDAO.findById(original.getTimetableId());
            profile = this.profileDAO.save(profile);
            AuditLog log = new AuditLog("PROFILE_MODIFY");
            log.setOldProfile(original.getName());
            log.setProfile(profile.getName());
            log.setOperationalArea(oa.getName());
            log.setOldSchedule(ttOriginal.getName());
            log.setSchedule(tt.getName());
            this.logAction(AuditActionContextLOV.PRF, AuditActionTypeLOV.MODIFY, log);
        }
        this.dtcMangementService.sendTimetablesToDTC();
        return profile;
    }

    @Override
    protected void handleRemoveSpecialDay(String id, Long version) throws Exception {
        SpecialDay specialDay = this.specialDayDAO.findById(id);
        specialDay.setVersion(Integer.valueOf(version.intValue()));
        this.internalRemoveSpecialDay(specialDay);
        this.dtcMangementService.sendTimetablesToDTC();
    }

    private void internalRemoveSpecialDay(SpecialDay specialDay) throws Exception {
        Set<SpecialDayService> specialDayServices = this.specialDayDAO.getSpecialDayServices(specialDay.getId());
        for (SpecialDayService specialDayService : specialDayServices) {
            this.internalRemoveSpecialDayService(specialDayService);
        }
        this.specialDayDAO.remove(specialDay);
        AuditLog log = new AuditLog(specialDay.getProfileId() != null ? "SPECIAL_DAY_PROFILE_REMOVE" : "SPECIAL_DAY_DTC_REMOVE");
        log.setName(specialDay.getName());
        log.setDate(specialDay.getDay());
        if (specialDay.getProfileId() != null) {
            Profile p = this.profileDAO.findById(specialDay.getProfileId());
            log.setProfile(p.getName());
        } else {
            Dtc dtc = this.dtcDAO.findById(specialDay.getDtcId());
            log.setDtc(dtc.getName());
        }
        this.logAction(AuditActionContextLOV.SPD, AuditActionTypeLOV.REMOVE, log);
    }

    @Override
    protected void handleSetServiceTimetable(String serviceId, String timetableId) throws Exception {
        Service service = this.serviceDAO.findById(serviceId);
        if (service == null) {
            return;
        }
        service.setTimetableId(timetableId);
        this.serviceDAO.save(service);
        this.dtcMangementService.sendTimetablesToDTC();
    }

    @Override
    protected void handleUnassignDTC(String dtcId, Long dtcVersion) throws Exception {
        Dtc dtc = this.dtcDAO.findById(dtcId);
        String profileId = dtc.getProfileId();
        if (profileId == null) {
            throw new BusinessCodedException("error.dtc.not.assigned");
        }
        dtc.setVersion(Integer.valueOf(dtcVersion.intValue()));
        dtc.setProfileId(null);
        this.dtcDAO.save(dtc);
        this.rebuildProfileServices(profileId);
        Profile profile = this.profileDAO.findById(profileId);
        OperationalArea oa = this.operationalAreaDAO.findById(profile.getOperationalAreaId());
        AuditLog log = new AuditLog("PROFILE_UNASSIGN");
        log.setProfile(profile.getName());
        log.setOperationalArea(oa.getName());
        log.setDtc(dtc.getName());
        this.logAction(AuditActionContextLOV.PRF, AuditActionTypeLOV.UNASSIGN, log);
        this.dtcMangementService.sendTimetablesToDTC();
    }

    @Override
    protected void handleAssignDTC(String dtcId, String profileId) throws Exception {
        Dtc dtc = this.dtcDAO.findById(dtcId);
        dtc.setProfileId(profileId);
        this.dtcDAO.save(dtc);
        this.rebuildProfileServices(profileId);
        Profile profile = this.profileDAO.findById(profileId);
        OperationalArea oa = this.operationalAreaDAO.findById(profile.getOperationalAreaId());
        AuditLog log = new AuditLog("PROFILE_ASSIGN");
        log.setProfile(profile.getName());
        log.setOperationalArea(oa.getName());
        log.setDtc(dtc.getName());
        this.logAction(AuditActionContextLOV.PRF, AuditActionTypeLOV.ASSIGN, log);
        this.dtcMangementService.sendTimetablesToDTC();
    }

    @Override
    protected void handleUnassignDTCFromClient(String dtcId, Long dtcVersion) throws Exception {
        Dtc dtc = this.dtcDAO.findById(dtcId);
        ClientEntity client = this.dtcDAO.getClient(dtc.getClientId());
        dtc.setVersion(Integer.valueOf(dtcVersion.intValue()));
        dtc.setClientId(null);
        this.dtcDAO.save(dtc);
        AuditLog log = new AuditLog("CLIENT_UNASSIGN");
        log.setName(client.getName());
        log.setDtc(dtc.getName());
        this.logAction(AuditActionContextLOV.CLI, AuditActionTypeLOV.UNASSIGN, log);
    }

    @Override
    protected void handleAssignDTCToClient(String dtcId, String clientId) throws Exception {
        Dtc dtc = this.dtcDAO.findById(dtcId);
        dtc.setClientId(clientId);
        this.dtcDAO.save(dtc);
        ClientEntity client = this.clientEntityDAO.findById(clientId);
        AuditLog log = new AuditLog("CLIENT_ASSIGN");
        log.setName(client.getName());
        log.setDtc(dtc.getName());
        this.logAction(AuditActionContextLOV.CLI, AuditActionTypeLOV.ASSIGN, log);
    }

    private void rebuildProfileServices(String profileId) {
        if (profileId != null) {
            Set<Dtc> dtcs = this.profileDAO.getDtcs(profileId);
            HashSet<String> dtcServiceNames = new HashSet<String>();
            for (Dtc d : dtcs) {
                Set<DtcService> dtcServices = this.dtcDAO.getServices(d.getId());
                for (DtcService dtcService : dtcServices) {
                    dtcServiceNames.add(dtcService.getName());
                }
            }
            HashSet<String> profileServiceNames = new HashSet<String>();
            Set<Service> services = this.profileDAO.getServices(profileId);
            for (Service service : services) {
                profileServiceNames.add(service.getName());
            }
            for (String name : dtcServiceNames) {
                if (profileServiceNames.contains(name)) continue;
                Service service = new Service();
                service.setName(name);
                service.setProfileId(profileId);
                this.serviceDAO.save(service);
            }
            for (Service service : services) {
                if (dtcServiceNames.contains(service.getName())) continue;
                this.serviceDAO.remove(service);
            }
        }
    }

    @Override
    protected Page<SpecialDayService> handleSearchSpecialDayService(SpecialDayServiceSearchDTO criteria) throws Exception {
        Page<SpecialDayService> page = this.specialDayServiceDAO.search(criteria);
        if (!criteria.getCountRecords().booleanValue()) {
            for (SpecialDayService sds : page.getResults()) {
                this.specialDayServiceDAO.loadControls(sds);
            }
        }
        return page;
    }

    @Override
    protected SpecialDay handleSaveSpecialDay(SpecialDay specialDay) throws Exception {
        SpecialDay persisted = null;
        if (specialDay.getVersion() != null) {
            persisted = this.specialDayDAO.findPersisted(specialDay);
        }
        SpecialDay sd = this.specialDayDAO.save(specialDay);
        if (persisted == null) {
            AuditLog log = new AuditLog(specialDay.getProfileId() != null ? "SPECIAL_DAY_PROFILE_ADD" : "SPECIAL_DAY_DTC_ADD");
            log.setName(specialDay.getName());
            log.setDate(specialDay.getDay());
            if (specialDay.getProfileId() != null) {
                Profile p = this.profileDAO.findById(specialDay.getProfileId());
                log.setProfile(p.getName());
            } else {
                Dtc dtc = this.dtcDAO.findById(specialDay.getDtcId());
                log.setDtc(dtc.getName());
            }
            this.auditActionDAO.logAction(Context.get().getUser(), AuditActionContextLOV.SPD, AuditActionTypeLOV.ADD, log);
        } else {
            AuditLog log = new AuditLog(specialDay.getProfileId() != null ? "SPECIAL_DAY_PROFILE_MODIFY" : "SPECIAL_DAY_DTC_MODIFY");
            log.setOldName(persisted.getName());
            log.setDate(persisted.getDay());
            log.setName(specialDay.getName());
            log.setDate(specialDay.getDay());
            if (specialDay.getProfileId() != null) {
                Profile p = this.profileDAO.findById(specialDay.getProfileId());
                log.setProfile(p.getName());
            } else {
                Dtc dtc = this.dtcDAO.findById(specialDay.getDtcId());
                log.setDtc(dtc.getName());
            }
            this.auditActionDAO.logAction(Context.get().getUser(), AuditActionContextLOV.SPD, AuditActionTypeLOV.MODIFY, log);
        }
        this.dtcMangementService.sendTimetablesToDTC();
        return sd;
    }

    @Override
    protected List<Service> handleFindServicesByDtc(String dtcId) throws Exception {
        Dtc dtc = this.dtcDAO.findById(dtcId);
        if (dtc != null && dtc.getProfileId() != null) {
            return this.serviceDAO.findAllByProfile(dtc.getProfileId());
        }
        return new ArrayList<Service>();
    }

    @Override
    protected SpecialDayService handleSaveSpecialDayService(SpecialDayService specialDayService) throws Exception {
        SpecialDay spDay = this.specialDayDAO.findById(specialDayService.getSpecialDayId());
        if (spDay == null) {
            throw new BusinessCodedException("error.specialday.not.found");
        }
        SpecialDayService ssd = this.specialDayServiceDAO.findByNameAndSpecialDay(specialDayService.getServiceName(), specialDayService.getSpecialDayId());
        if (ssd == null) {
            ssd = this.specialDayServiceDAO.save(specialDayService);
        } else {
            this.controlDAO.removeBySpecialDayService(ssd.getId());
        }
        for (Control control : specialDayService.getControls()) {
            control.setSpecialDayService(ssd);
            this.controlDAO.save(control);
        }
        this.auditModifySpecialDayService(spDay);
        this.dtcMangementService.sendTimetablesToDTC();
        return ssd;
    }

    @Override
    protected void handleRemoveSpecialDayService(String id, Long version) throws Exception {
        SpecialDayService specialDayService = this.specialDayServiceDAO.findById(id);
        specialDayService.setVersion(Integer.valueOf(version.intValue()));
        this.internalRemoveSpecialDayService(specialDayService);
        SpecialDay specialDay = this.specialDayDAO.findById(specialDayService.getSpecialDayId());
        this.auditModifySpecialDayService(specialDay);
        this.dtcMangementService.sendTimetablesToDTC();
    }

    private void internalRemoveSpecialDayService(SpecialDayService specialDayService) throws Exception {
        this.controlDAO.removeBySpecialDayService(specialDayService.getId());
        this.specialDayServiceDAO.remove(specialDayService);
    }

    private void auditModifySpecialDayService(SpecialDay specialDay) {
        AuditLog log = new AuditLog(specialDay.getProfileId() != null ? "SPECIAL_DAY_PROFILE_MODIFY" : "SPECIAL_DAY_DTC_MODIFY");
        log.setOldName(specialDay.getName());
        log.setOldDate(specialDay.getDay());
        log.setName(specialDay.getName());
        log.setDate(specialDay.getDay());
        if (specialDay.getProfileId() != null) {
            log.setProfile(this.profileDAO.findById(specialDay.getProfileId()).getName());
        } else {
            log.setDtc(this.dtcDAO.findById(specialDay.getDtcId()).getName());
        }
        this.logAction(AuditActionContextLOV.SPD, AuditActionTypeLOV.MODIFY, log);
    }

    @Override
    protected Page<Dtc> handleSearchAssociatedDtcs(DtcAssociationSearchDTO criteria) throws Exception {
        User user = Context.get().getUser();
        String operationalAreaId = user.getOperationalAreaId();
        if (operationalAreaId == null) {
            Profile profile = this.profileDAO.findById(criteria.getProfileId());
            operationalAreaId = profile.getOperationalAreaId();
        }
        Page<Dtc> page = this.dtcDAO.searchAssociated(criteria, operationalAreaId);
        if (!criteria.getCountRecords().booleanValue()) {
            for (Dtc dtc : page.getResults()) {
                this.dtcDAO.loadProfile(dtc);
            }
        }
        return page;
    }

    @Override
    protected Page<Dtc> handleSearchClientAssociatedDtcs(final DtcClientAssociationSearchDTO criteria) throws Exception {
        User user = Context.get().getUser();
        String oaId = user.getOperationalAreaId() != null ? user.getOperationalAreaId() : null;
        Page<Dtc> page = null;
        String order = criteria.getOrderBy();
        if (!criteria.getCountRecords().booleanValue() && (ORDER_OA.equals(order) || ORDER_CLIENT.equals(order))) {
            Long max = criteria.getMaxResult() != null ? criteria.getMaxResult() : -1L;
            Long first = criteria.getFirstRecord() != null ? criteria.getFirstRecord() : 0L;
            criteria.setFirstRecord(null);
            criteria.setMaxResult(null);
            page = this.dtcDAO.searchAssociatedForClient(criteria, oaId);
            this.loadOperationalAreaAndClient(page);
            List dtcs = page.getResults();
            if (ORDER_OA.equals(order)) {
                Collections.sort(dtcs, new Comparator<Dtc>(){

                    @Override
                    public int compare(Dtc t1, Dtc t2) {
                        String name1 = t1.getOperationalArea() != null ? t1.getOperationalArea().getName() : null;
                        String name2 = t2.getOperationalArea() != null ? t2.getOperationalArea().getName() : null;
                        int result = 0;
                        if (name1 != null && name2 != null) {
                            result = name1.compareTo(name2);
                        } else if (name1 != null) {
                            result = 1;
                        } else if (name2 != null) {
                            result = -1;
                        }
                        return criteria.getOrderAscending() != false ? result : -result;
                    }
                });
            } else {
                Collections.sort(dtcs, new Comparator<Dtc>(){

                    @Override
                    public int compare(Dtc t1, Dtc t2) {
                        String name1 = t1.getClient() != null ? t1.getClient().getName() : null;
                        String name2 = t2.getClient() != null ? t2.getClient().getName() : null;
                        int result = 0;
                        if (name1 != null && name2 != null) {
                            result = name1.compareTo(name2);
                        } else if (name1 != null) {
                            result = 1;
                        } else if (name2 != null) {
                            result = -1;
                        }
                        return criteria.getOrderAscending() != false ? result : -result;
                    }
                });
            }
            page.setLast(max != -1L ? (long)dtcs.size() <= max - first : true);
            dtcs = Tool.subList((List)dtcs, (int)first.intValue(), (int)max.intValue());
        } else {
            page = this.dtcDAO.searchAssociatedForClient(criteria, oaId);
            this.loadOperationalAreaAndClient(page);
        }
        return page;
    }

    private void loadOperationalAreaAndClient(Page<Dtc> page) {
        if (page.getResults() != null) {
            for (Dtc dtc : page.getResults()) {
                this.dtcDAO.loadOperationalArea(dtc);
                this.dtcDAO.loadClient(dtc);
            }
        }
    }

    @Override
    protected List<District> handleFindAllDistricts() throws Exception {
        return this.districtDAO.findAll();
    }

    @Override
    protected List<Municipality> handleFindMunicipalitiesByDistrict(String districtId) throws Exception {
        return this.municipalityDAO.findAllByDistrict(districtId);
    }

    @Override
    protected DtcEditDTO handleGetDtcForEdit(String dtcId) throws Exception {
        DtcEditDTO dto = new DtcEditDTO();
        Dtc dtc = this.dtcDAO.findById(dtcId);
        if (dtc != null) {
            this.loadDtcDetail(dtc);
            dto.setDtc(dtc);
            if (dtc.getOperationalAreaId() != null) {
                dto.setTimetables(this.timetableDAO.findAllByOperationalArea(dtc.getOperationalAreaId()));
            }
        }
        return dto;
    }

    @Override
    protected Long handleSaveDtcTimetable(String dtcId, Long version, String timetableId) throws Exception {
        Dtc dtc = this.dtcDAO.findById(dtcId);
        dtc.setVersion(Integer.valueOf(version.intValue()));
        dtc.setTimetableId(timetableId);
        dtc = this.dtcDAO.save(dtc);
        this.dtcMangementService.sendTimetablesToDTC();
        return dtc.getVersion().longValue();
    }

    private void loadDtcDetail(Dtc dtc) {
        if (dtc != null) {
            this.dtcDAO.loadClient(dtc);
            this.dtcDAO.loadOperationalArea(dtc);
            this.dtcDAO.loadTimetable(dtc);
            this.dtcDAO.loadProfile(dtc);
            this.dtcDAO.loadState(dtc);
            this.dtcDAO.loadDistrict(dtc);
            this.dtcDAO.loadMunicipality(dtc);
            if (dtc.getProfile() != null) {
                this.profileDAO.loadTimetable(dtc.getProfile());
            }
        }
    }

    @Override
    protected Page<SpecialDay> handleSearchDtcSpecialDays(DtcChildSearchDTO criteria) throws Exception {
        return this.specialDayDAO.searchForDtc(criteria);
    }

    @Override
    protected Timetable handleFindTimetableByServiceAndDtc(String serviceName, String dtcId) throws Exception {
        Service service;
        Dtc dtc = this.dtcDAO.findById(dtcId);
        if (dtc.getProfileId() != null && (service = this.serviceDAO.findByNameAndProfile(serviceName, dtc.getProfileId())) != null && service.getTimetableId() != null) {
            return this.timetableDAO.findById(service.getTimetableId());
        }
        return null;
    }

    @Override
    protected ServiceEditDTO handleGetServiceForEdit(String serviceId, String operationalAreaId) throws Exception {
        ServiceEditDTO dto = new ServiceEditDTO();
        Service service = this.serviceDAO.findById(serviceId);
        if (service == null) {
            return null;
        }
        this.serviceDAO.loadTimetable(service);
        dto.setService(service);
        dto.setTimetables(this.timetableDAO.findAllByOperationalArea(operationalAreaId));
        return dto;
    }

    @Override
    protected SpecialDayService handleFindSpecialDayService(String specialDayServiceId) throws Exception {
        SpecialDayService specialDayService = this.specialDayServiceDAO.findById(specialDayServiceId);
        this.specialDayServiceDAO.loadControls(specialDayService);
        return specialDayService;
    }

    @Override
    protected Page<SpecialDay> handleSearchSpecialDays(SpecialDaySearchDTO criteria) throws Exception {
        ArrayList<String> profileIds = null;
        ArrayList<String> dtcIds = null;
        User user = Context.get().getUser();
        if (user.getOperationalAreaId() != null) {
            profileIds = new ArrayList<String>();
            for (Profile profile : this.profileDAO.findAllByOperationalArea(user.getOperationalAreaId())) {
                profileIds.add(profile.getId());
            }
        } else if (user.getClientId() != null) {
            dtcIds = new ArrayList<String>();
            for (Dtc dtc : this.dtcDAO.findAllByClient(user.getClientId())) {
                dtcIds.add(dtc.getId());
            }
        }
        Page<SpecialDay> page = this.specialDayDAO.search(criteria, profileIds, dtcIds);
        if (page.getResults() != null) {
            for (SpecialDay specialDay : page.getResults()) {
                this.specialDayDAO.loadDtc(specialDay);
                this.specialDayDAO.loadProfile(specialDay);
            }
        }
        return page;
    }

    @Override
    protected Page<ScheduleDTO> handleSearchTimetables(final TimetableSearchDTO criteria) throws Exception {
        User user = Context.get().getUser();
        String oaId = user.getOperationalAreaId() != null ? user.getOperationalAreaId() : criteria.getOperationalAreaId();
        Transformer<Timetable, ScheduleDTO> transformer = new Transformer<Timetable, ScheduleDTO>(){

            public ScheduleDTO transform(Timetable timetable) {
                ConfigurationService.this.timetableDAO.loadOperationalArea(timetable);
                String oaName = timetable.getOperationalArea() != null ? timetable.getOperationalArea().getName() : criteria.getScheduleModelDescription();
                return new ScheduleDTO(timetable.getId(), Long.valueOf(timetable.getVersion().longValue()), timetable.getName(), timetable.getOperationalAreaId(), oaName);
            }
        };
        Page pageDTO = new Page();
        Page<Timetable> page = null;
        List dtos = null;
        if (!criteria.getCountRecords().booleanValue() && ORDER_OA.equals(criteria.getOrderBy())) {
            Long max = criteria.getMaxResult() != null ? criteria.getMaxResult() : -1L;
            Long first = criteria.getFirstRecord() != null ? criteria.getFirstRecord() : 0L;
            criteria.setFirstRecord(null);
            criteria.setMaxResult(null);
            page = this.timetableDAO.search(criteria, user.getClientId(), oaId);
            dtos = Tool.transformCollection((List)page.getResults(), (Transformer)transformer);
            Collections.sort(dtos, new Comparator<ScheduleDTO>(){

                @Override
                public int compare(ScheduleDTO t1, ScheduleDTO t2) {
                    int result = t1.getOperationalAreaName().compareTo(t2.getOperationalAreaName());
                    return criteria.getOrderAscending() != false ? result : -result;
                }
            });
            pageDTO.setLast(max != -1L ? (long)dtos.size() <= max - first : true);
            dtos = Tool.subList((List)dtos, (int)first.intValue(), (int)max.intValue());
        } else {
            page = this.timetableDAO.search(criteria, user.getClientId(), oaId);
            if (page.getResults() != null) {
                dtos = Tool.transformCollection((List)page.getResults(), (Transformer)transformer);
            }
        }
        pageDTO.setCount(page.getCount());
        pageDTO.setLast(page.isLast());
        pageDTO.setResults(dtos);
        return pageDTO;
    }

    @Override
    protected void handleRemoveTimetable(String timetableId, Long version) throws Exception {
        Timetable tt = this.timetableDAO.findById(timetableId);
        if (tt == null) {
            throw new BusinessCodedException("error.schedule.not.found");
        }
        String errorType = null;
        if (this.timetableDAO.getProfiles(timetableId).size() > 0) {
            errorType = "error.timetable.dependencies.profiles";
        } else if (this.timetableDAO.getDtcs(timetableId).size() > 0) {
            errorType = "error.timetable.dependencies.dtcs";
        } else if (this.timetableDAO.getServices(timetableId).size() > 0) {
            errorType = "error.timetable.dependencies.services";
        }
        if (errorType != null) {
            throw new BusinessCodedException("error.timetable.dependencies.violation", new Object[]{tt.getName(), errorType});
        }
        if (tt.getVersion() != null) {
            for (Period period : this.periodDAO.findAllByTimetable(timetableId)) {
                for (Control control : this.controlDAO.findAllByPeriod(period.getId())) {
                    this.controlDAO.remove(control);
                }
                this.periodDAO.remove(period);
            }
        }
        tt.setVersion(Integer.valueOf(version.intValue()));
        this.timetableDAO.remove(tt);
        this.timetableDAO.loadOperationalArea(tt);
        AuditLog log = new AuditLog(tt.getOperationalArea() != null ? "SCHEDULE_REMOVE" : "SCHEDULE_TEMPLATE_REMOVE");
        log.setName(tt.getName());
        if (tt.getOperationalArea() != null) {
            log.setOperationalArea(tt.getOperationalArea().getName());
        }
        this.logAction(AuditActionContextLOV.SCH, AuditActionTypeLOV.REMOVE, log);
    }

    @Override
    protected String handleCopyTimetable(String timetableId, String suffix) throws Exception {
        User user = Context.get().getUser();
        Timetable timetable = this.timetableDAO.findById(timetableId);
        if (user.getOperationalAreaId() != null && timetable.getOperationalAreaId() != null && !user.getOperationalAreaId().equals(timetable.getOperationalAreaId())) {
            throw new BusinessCodedException("error.timetable.copy.violation");
        }
        String name = this.getValidCopyName(timetable.getOperationalAreaId(), timetable.getName(), suffix);
        Timetable tt = new Timetable(timetable);
        tt.setName(name);
        tt.setOperationalAreaId(user.getOperationalAreaId());
        tt = this.timetableDAO.save(tt);
        List<Period> periods = this.periodDAO.findAllByTimetable(timetableId);
        for (Period period : periods) {
            Period p = new Period(period);
            p.setTimetable(tt);
            p = this.periodDAO.save(p);
            for (Control control : this.controlDAO.findAllByPeriod(period.getId())) {
                Control c = new Control(control);
                c.setPeriod(p);
                c = this.controlDAO.save(c);
            }
        }
        this.auditSaveTimetable(tt, null, !periods.isEmpty());
        return tt.getId();
    }

    private String getValidCopyName(String operationalAreaId, String originalName, String nameSuffix) {
        String name = "";
        name = nameSuffix == null ? String.format("%s - Copy", originalName) : String.format("%s - %s", originalName, nameSuffix);
        int count = 0;
        while (this.timetableDAO.exists(operationalAreaId, name).booleanValue()) {
            name = String.format("%s%d", name, ++count);
        }
        return name;
    }

    @Override
    protected List<OperationalArea> handleFindAllOperationalAreas() throws Exception {
        return this.operationalAreaDAO.findAll();
    }

    @Override
    protected List<StandardPeriodDTO> handleFindPeriodsByTimetable(String timetableId) throws Exception {
        List<Period> periods = this.periodDAO.findAllByTimetableOrderByStart(timetableId);
        ArrayList<StandardPeriodDTO> dtos = new ArrayList<StandardPeriodDTO>();
        block0: for (Period period : periods) {
            StandardPeriodDTO dto = new StandardPeriodDTO();
            dto.setStart(period.getStart());
            dto.setEnd(period.getEnd());
            dtos.add(dto);
            List<Control> controls = this.controlDAO.findAllByPeriodOrderByOrder(period.getId());
            int cnt = 0;
            for (Control control : controls) {
                if (cnt == 0) {
                    dto.setOffMode(Converters.fromModeLOV((ModeLOV)control.getMode()));
                    dto.setOffTime(control.getTime());
                    dto.setOffOffset(control.getOffset());
                } else {
                    if (cnt != true) continue block0;
                    dto.setOnMode(Converters.fromModeLOV((ModeLOV)control.getMode()));
                    dto.setOnTime(control.getTime());
                    dto.setOnOffset(control.getOffset());
                }
                ++cnt;
            }
        }
        return dtos;
    }

    @Override
    protected void handleSaveTimetable(Timetable timetable, List<StandardPeriodDTO> periods) throws Exception {
        if (timetable == null || Strings.isEmpty((String)timetable.getName())) {
            throw new BusinessCodedException("timetable.name.exists");
        }
        User user = Context.get().getUser();
        String oaId = null;
        oaId = user.getOperationalAreaId() != null ? user.getOperationalAreaId() : timetable.getOperationalAreaId();
        boolean isOld = timetable.getVersion() != null;
        Timetable persisted = null;
        if (isOld) {
            persisted = this.timetableDAO.findPersisted(timetable);
            if (!Tool.similar((Object)user.getOperationalAreaId(), (Object)persisted.getOperationalAreaId())) {
                return;
            }
        } else if (user.getOperationalAreaId() != null) {
            timetable.setOperationalAreaId(user.getOperationalAreaId());
        } else if (user.getClientId() == null) {
            timetable.setOperationalAreaId(null);
        }
        if (!isOld && this.timetableDAO.exists(oaId, timetable.getName()).booleanValue()) {
            throw new BusinessCodedException("timetable.name.exists");
        }
        timetable = this.timetableDAO.save(timetable);
        if (isOld) {
            for (Period period : this.periodDAO.findAllByTimetable(timetable.getId())) {
                this.controlDAO.removeByPeriod(period.getId());
                this.periodDAO.remove(period);
            }
        }
        for (StandardPeriodDTO dto : periods) {
            Period period = new Period();
            period.setTimetable(timetable);
            period.setStart(dto.getStart());
            period.setEnd(dto.getEnd());
            period = this.periodDAO.save(period);
            Control control = new Control();
            control.setPeriod(period);
            control.setOrder(Long.valueOf(1L));
            control.setTargetState(Boolean.FALSE);
            control.setMode(Converters.toModeLOV((EModeExtended)dto.getOffMode()));
            control.setTime(dto.getOffTime());
            control.setOffset(dto.getOffOffset());
            this.controlDAO.save(control);
            control = new Control();
            control.setPeriod(period);
            control.setOrder(Long.valueOf(2L));
            control.setTargetState(Boolean.TRUE);
            control.setMode(Converters.toModeLOV((EModeExtended)dto.getOnMode()));
            control.setTime(dto.getOnTime());
            control.setOffset(dto.getOnOffset());
            this.controlDAO.save(control);
        }
        this.auditSaveTimetable(timetable, persisted, !periods.isEmpty());
        this.dtcMangementService.sendTimetablesToDTC();
    }

    private void auditSaveTimetable(Timetable timetable, Timetable original, boolean hasPeriods) {
        this.timetableDAO.loadOperationalArea(timetable);
        if (original == null) {
            AuditLog log = new AuditLog(timetable.getOperationalArea() != null ? "SCHEDULE_ADD" : "SCHEDULE_TEMPLATE_ADD");
            log.setName(timetable.getName());
            if (timetable.getOperationalArea() != null) {
                log.setOperationalArea(timetable.getOperationalArea().getName());
            }
            this.logAction(AuditActionContextLOV.SCH, AuditActionTypeLOV.ADD, log);
        } else {
            AuditLog log = new AuditLog(timetable.getOperationalArea() != null ? (hasPeriods ? "SCHEDULE_PERIOD_MODIFY" : "SCHEDULE_MODIFY") : (hasPeriods ? "SCHEDULE_TEMPLATE_PERIOD_MODIFY" : "SCHEDULE_TEMPLATE_MODIFY"));
            log.setOldName(original.getName());
            log.setName(timetable.getName());
            if (timetable.getOperationalArea() != null) {
                log.setOperationalArea(timetable.getOperationalArea().getName());
            }
            this.logAction(AuditActionContextLOV.SCH, AuditActionTypeLOV.MODIFY, log);
        }
    }

    @Override
    protected Page<Dtc> handleSearchClientDtcs(ClientDtcSearchDTO criteria) throws Exception {
        User user = Context.get().getUser();
        String oaId = user.getOperationalAreaId() != null ? user.getOperationalAreaId() : null;
        Page<Dtc> page = this.dtcDAO.searchForClient(criteria, oaId);
        this.loadServicesAndMunicipalities(page);
        return page;
    }

    private void loadServicesAndMunicipalities(Page<Dtc> page) {
        if (page.getResults() != null) {
            for (Dtc dtc : page.getResults()) {
                this.dtcDAO.loadServices(dtc);
                this.dtcDAO.loadMunicipality(dtc);
            }
        }
    }

    @Override
    protected SpecialDay handleFindSpecialDay(String specialDayId) throws Exception {
        SpecialDay specialDay = this.specialDayDAO.findById(specialDayId);
        if (specialDay != null) {
            this.specialDayDAO.loadDtc(specialDay);
            this.specialDayDAO.loadProfile(specialDay);
        }
        return specialDay;
    }
}

