/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IUserDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.UserSearchDTO;
import pt.efacec.smartlighting.common.core.entity.AuditAction;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.DtcState;
import pt.efacec.smartlighting.common.core.entity.OperationalArea;
import pt.efacec.smartlighting.common.core.entity.QAuditAction;
import pt.efacec.smartlighting.common.core.entity.QClientEntity;
import pt.efacec.smartlighting.common.core.entity.QDtcState;
import pt.efacec.smartlighting.common.core.entity.QOperationalArea;
import pt.efacec.smartlighting.common.core.entity.QUser;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class UserDAOBase
implements IUserDAO {
    private static final Log logger = Log.getLogger(UserDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from User e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(User entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public User save(User entity) {
        String temp = null;
        temp = entity.getDeleted();
        if (temp != null && temp.length() > 255) {
            entity.setDeleted(temp.substring(0, 255));
        }
        if ((temp = entity.getLogin()) != null && temp.length() > 30) {
            entity.setLogin(temp.substring(0, 30));
        }
        if ((temp = entity.getSalt()) != null && temp.length() > 16) {
            entity.setSalt(temp.substring(0, 16));
        }
        if ((temp = entity.getPassword()) != null && temp.length() > 256) {
            entity.setPassword(temp.substring(0, 256));
        }
        if ((temp = entity.getName()) != null && temp.length() > 100) {
            entity.setName(temp.substring(0, 100));
        }
        if ((temp = entity.getEmail()) != null && temp.length() > 255) {
            entity.setEmail(temp.substring(0, 255));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (User)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public User findPersisted(User entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            User persisted = (User)this.em.find(User.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public User findById(String entityId) {
        return (User)this.em.find(User.class, (Object)entityId);
    }

    @Override
    public List<User> findAll() {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{QUser.user.deleted.eq((Object)"0")})).list((Expression)QUser.user);
    }

    @Override
    public List<User> findAllWithDeleted() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).list((Expression)QUser.user);
    }

    @Override
    public User findByLogin(String login) {
        return (User)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{QUser.user.login.equalsIgnoreCase(login).and((Predicate)QUser.user.deleted.eq((Object)"0"))})).uniqueResult((Expression)QUser.user);
    }

    @Override
    public User findByEmail(String email) {
        return (User)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{QUser.user.email.eq((Object)email).and((Predicate)QUser.user.deleted.eq((Object)"0"))})).uniqueResult((Expression)QUser.user);
    }

    @Override
    public void loadClient(User entity) {
        if (entity != null) {
            entity.setClient(this.getClient(entity.getClientId()));
        }
    }

    @Override
    public ClientEntity getClient(String clientEntityId) {
        if (clientEntityId != null) {
            return (ClientEntity)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QClientEntity.clientEntity})).where(new Predicate[]{QClientEntity.clientEntity.id.eq((Object)clientEntityId)})).uniqueResult((Expression)QClientEntity.clientEntity);
        }
        return null;
    }

    @Override
    public List<User> findAllByClient(String clientEntityId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{clientEntityId == null ? QUser.user.clientId.isNull() : QUser.user.clientId.eq((Object)clientEntityId).and((Predicate)QUser.user.deleted.eq((Object)"0"))})).list((Expression)QUser.user);
    }

    @Override
    public List<User> findAllWithDeletedByClient(String clientEntityId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{clientEntityId == null ? QUser.user.clientId.isNull() : QUser.user.clientId.eq((Object)clientEntityId)})).list((Expression)QUser.user);
    }

    @Override
    public void loadOperationalArea(User entity) {
        if (entity != null) {
            entity.setOperationalArea(this.getOperationalArea(entity.getOperationalAreaId()));
        }
    }

    @Override
    public OperationalArea getOperationalArea(String operationalAreaId) {
        if (operationalAreaId != null) {
            return (OperationalArea)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QOperationalArea.operationalArea})).where(new Predicate[]{QOperationalArea.operationalArea.id.eq((Object)operationalAreaId)})).uniqueResult((Expression)QOperationalArea.operationalArea);
        }
        return null;
    }

    @Override
    public List<User> findAllByOperationalArea(String operationalAreaId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{operationalAreaId == null ? QUser.user.operationalAreaId.isNull() : QUser.user.operationalAreaId.eq((Object)operationalAreaId).and((Predicate)QUser.user.deleted.eq((Object)"0"))})).list((Expression)QUser.user);
    }

    @Override
    public List<User> findAllWithDeletedByOperationalArea(String operationalAreaId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{operationalAreaId == null ? QUser.user.operationalAreaId.isNull() : QUser.user.operationalAreaId.eq((Object)operationalAreaId)})).list((Expression)QUser.user);
    }

    @Override
    public void loadAuditActions(User entity) {
        if (entity != null && entity.getAuditActions() == null) {
            entity.setAuditActions(this.getAuditActions(entity.getId()));
        }
    }

    @Override
    public Set<AuditAction> getAuditActions(String userId) {
        if (userId != null) {
            return new HashSet<AuditAction>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QAuditAction.auditAction})).where(new Predicate[]{QAuditAction.auditAction.userId.eq((Object)userId)})).list((Expression)QAuditAction.auditAction));
        }
        return new HashSet<AuditAction>();
    }

    @Override
    public void loadStates(User entity) {
        if (entity != null && entity.getStates() == null) {
            entity.setStates(this.getStates(entity.getId()));
        }
    }

    @Override
    public Set<DtcState> getStates(String userId) {
        if (userId != null) {
            return new HashSet<DtcState>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcState.dtcState})).where(new Predicate[]{QDtcState.dtcState.submiterId.eq((Object)userId)})).list((Expression)QDtcState.dtcState));
        }
        return new HashSet<DtcState>();
    }

    @Override
    public User softDelete(User user) {
        if (user == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"UserDAO.softDelete", "user"});
        }
        try {
            return this.handleSoftDelete(user);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing softDelete.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing softDelete.", e);
        }
    }

    protected abstract User handleSoftDelete(User var1);

    @Override
    public User softDeleteByIdVersion(String id, Long version) {
        if (id == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"UserDAO.softDeleteByIdVersion", "id"});
        }
        if (version == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"UserDAO.softDeleteByIdVersion", "version"});
        }
        try {
            return this.handleSoftDeleteByIdVersion(id, version);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing softDeleteByIdVersion.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing softDeleteByIdVersion.", e);
        }
    }

    protected abstract User handleSoftDeleteByIdVersion(String var1, Long var2);

    @Override
    public User loadClientOrOperationalArea(User user) {
        if (user == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"UserDAO.loadClientOrOperationalArea", "user"});
        }
        try {
            return this.handleLoadClientOrOperationalArea(user);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing loadClientOrOperationalArea.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing loadClientOrOperationalArea.", e);
        }
    }

    protected abstract User handleLoadClientOrOperationalArea(User var1);

    @Override
    public Page<User> search(UserSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"UserDAO.search", "criteria"});
        }
        try {
            SearchParam searchParam = this.buildSearchSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearch(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearch(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<User> list = this.queryForSearch(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing search.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing search.", e);
        }
    }

    protected JPAQuery createQueryForSearch(UserSearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user});
    }

    protected List<User> queryForSearch(JPAQuery query) {
        return query.list((Expression)QUser.user);
    }

    protected abstract SearchParam buildSearchSearchParam(UserSearchDTO var1);

    @Override
    public User findByLoginCaseInsensitive(String login) {
        if (login == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"UserDAO.findByLoginCaseInsensitive", "login"});
        }
        try {
            return this.handleFindByLoginCaseInsensitive(login);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing findByLoginCaseInsensitive.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing findByLoginCaseInsensitive.", e);
        }
    }

    protected abstract User handleFindByLoginCaseInsensitive(String var1);

    @Override
    public User findByEmailCaseInsensitive(String email) {
        if (email == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"UserDAO.findByEmailCaseInsensitive", "email"});
        }
        try {
            return this.handleFindByEmailCaseInsensitive(email);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing findByEmailCaseInsensitive.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing findByEmailCaseInsensitive.", e);
        }
    }

    protected abstract User handleFindByEmailCaseInsensitive(String var1);
}

