/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.UUID;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.UserDAOBase;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.UserSearchDTO;
import pt.efacec.smartlighting.common.core.entity.QUser;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.toolkit.misc.Strings;

@Repository(value="userDAO")
public class UserDAO
extends UserDAOBase {
    @Override
    public User save(User entity) {
        if (entity.getDeleted() == null) {
            entity.setDeleted("0");
        }
        return super.save(entity);
    }

    @Override
    protected User handleSoftDeleteByIdVersion(String id, Long version) {
        User user = this.findById(id);
        user.setVersion(Integer.valueOf(version.intValue()));
        return this.handleSoftDelete(user);
    }

    @Override
    protected User handleSoftDelete(User user) {
        if ("0".equals(user.getDeleted())) {
            user.setDeleted(UUID.randomUUID().toString());
            user = this.save(user);
        }
        return user;
    }

    @Override
    protected User handleLoadClientOrOperationalArea(User user) {
        if (user.getClientId() != null) {
            this.loadClient(user);
        } else if (user.getOperationalAreaId() != null) {
            this.loadOperationalArea(user);
        }
        return user;
    }

    @Override
    protected SearchParam buildSearchSearchParam(UserSearchDTO criteria) {
        SearchParam searchParam;
        block16: {
            searchParam = new SearchParam();
            BooleanExpression expression = QUser.user.deleted.eq((Object)"0");
            if (criteria.getClientId() != null) {
                expression = expression.and((Predicate)QUser.user.clientId.eq((Object)criteria.getClientId()));
            }
            if (criteria.getOperationalAreaId() != null) {
                expression = expression.and((Predicate)QUser.user.operationalAreaId.eq((Object)criteria.getOperationalAreaId()));
            }
            if (!Strings.isEmpty((String)criteria.getName())) {
                expression = expression.and((Predicate)QUser.user.name.upper().like(criteria.getName().toUpperCase()));
            }
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block16;
            switch (criteria.getOrderBy()) {
                case "name": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QUser.user.name.asc() : QUser.user.name.desc());
                    break;
                }
                case "login": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QUser.user.login.asc() : QUser.user.login.desc());
                    break;
                }
                case "active": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QUser.user.locked.asc() : QUser.user.locked.desc());
                }
            }
        }
        return searchParam;
    }

    @Override
    protected User handleFindByLoginCaseInsensitive(String login) {
        return (User)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{QUser.user.login.equalsIgnoreCase(login).and((Predicate)QUser.user.deleted.eq((Object)"0"))})).uniqueResult((Expression)QUser.user);
    }

    @Override
    protected User handleFindByEmailCaseInsensitive(String email) {
        return (User)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{QUser.user.email.equalsIgnoreCase(email).and((Predicate)QUser.user.deleted.eq((Object)"0"))})).uniqueResult((Expression)QUser.user);
    }
}

