/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.ITimetableDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.TimetableSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.OperationalArea;
import pt.efacec.smartlighting.common.core.entity.Period;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QOperationalArea;
import pt.efacec.smartlighting.common.core.entity.QPeriod;
import pt.efacec.smartlighting.common.core.entity.QProfile;
import pt.efacec.smartlighting.common.core.entity.QService;
import pt.efacec.smartlighting.common.core.entity.QTimetable;
import pt.efacec.smartlighting.common.core.entity.Service;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class TimetableDAOBase
implements ITimetableDAO {
    private static final Log logger = Log.getLogger(TimetableDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from Timetable e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(Timetable entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public Timetable save(Timetable entity) {
        String temp = null;
        temp = entity.getName();
        if (temp != null && temp.length() > 100) {
            entity.setName(temp.substring(0, 100));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (Timetable)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public Timetable findPersisted(Timetable entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            Timetable persisted = (Timetable)this.em.find(Timetable.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public Timetable findById(String entityId) {
        return (Timetable)this.em.find(Timetable.class, (Object)entityId);
    }

    @Override
    public List<Timetable> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QTimetable.timetable})).list((Expression)QTimetable.timetable);
    }

    @Override
    public void loadOperationalArea(Timetable entity) {
        if (entity != null) {
            entity.setOperationalArea(this.getOperationalArea(entity.getOperationalAreaId()));
        }
    }

    @Override
    public OperationalArea getOperationalArea(String operationalAreaId) {
        if (operationalAreaId != null) {
            return (OperationalArea)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QOperationalArea.operationalArea})).where(new Predicate[]{QOperationalArea.operationalArea.id.eq((Object)operationalAreaId)})).uniqueResult((Expression)QOperationalArea.operationalArea);
        }
        return null;
    }

    @Override
    public List<Timetable> findAllByOperationalArea(String operationalAreaId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QTimetable.timetable})).where(new Predicate[]{operationalAreaId == null ? QTimetable.timetable.operationalAreaId.isNull() : QTimetable.timetable.operationalAreaId.eq((Object)operationalAreaId)})).list((Expression)QTimetable.timetable);
    }

    @Override
    public void loadDtcs(Timetable entity) {
        if (entity != null && entity.getDtcs() == null) {
            entity.setDtcs(this.getDtcs(entity.getId()));
        }
    }

    @Override
    public Set<Dtc> getDtcs(String timetableId) {
        if (timetableId != null) {
            return new HashSet<Dtc>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.timetableId.eq((Object)timetableId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc));
        }
        return new HashSet<Dtc>();
    }

    @Override
    public void loadPeriods(Timetable entity) {
        if (entity != null && entity.getPeriods() == null) {
            entity.setPeriods(this.getPeriods(entity.getId()));
        }
    }

    @Override
    public Set<Period> getPeriods(String timetableId) {
        if (timetableId != null) {
            return new HashSet<Period>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QPeriod.period})).where(new Predicate[]{QPeriod.period.timetableId.eq((Object)timetableId)})).list((Expression)QPeriod.period));
        }
        return new HashSet<Period>();
    }

    @Override
    public void loadServices(Timetable entity) {
        if (entity != null && entity.getServices() == null) {
            entity.setServices(this.getServices(entity.getId()));
        }
    }

    @Override
    public Set<Service> getServices(String timetableId) {
        if (timetableId != null) {
            return new HashSet<Service>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QService.service})).where(new Predicate[]{QService.service.timetableId.eq((Object)timetableId)})).list((Expression)QService.service));
        }
        return new HashSet<Service>();
    }

    @Override
    public void loadProfiles(Timetable entity) {
        if (entity != null && entity.getProfiles() == null) {
            entity.setProfiles(this.getProfiles(entity.getId()));
        }
    }

    @Override
    public Set<Profile> getProfiles(String timetableId) {
        if (timetableId != null) {
            return new HashSet<Profile>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QProfile.profile})).where(new Predicate[]{QProfile.profile.timetableId.eq((Object)timetableId)})).list((Expression)QProfile.profile));
        }
        return new HashSet<Profile>();
    }

    @Override
    public Page<Timetable> search(TimetableSearchDTO criteria, String clientId, String operationalAreaId) {
        try {
            SearchParam searchParam = this.buildSearchSearchParam(criteria, clientId, operationalAreaId);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearch(criteria, clientId, operationalAreaId);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearch(criteria, clientId, operationalAreaId);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<Timetable> list = this.queryForSearch(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing search.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing search.", e);
        }
    }

    protected JPAQuery createQueryForSearch(TimetableSearchDTO criteria, String clientId, String operationalAreaId) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QTimetable.timetable});
    }

    protected List<Timetable> queryForSearch(JPAQuery query) {
        return query.list((Expression)QTimetable.timetable);
    }

    protected abstract SearchParam buildSearchSearchParam(TimetableSearchDTO var1, String var2, String var3);

    @Override
    public Boolean exists(String operationalAreaId, String name) {
        try {
            return this.handleExists(operationalAreaId, name);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing exists.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing exists.", e);
        }
    }

    protected abstract Boolean handleExists(String var1, String var2);
}

