/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.IDtcDAO;
import pt.efacec.smartlighting.business.core.entitydao.TimetableDAOBase;
import pt.efacec.smartlighting.business.misc.SLUtil;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.TimetableSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.QTimetable;
import pt.efacec.smartlighting.common.core.entity.Service;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.core.service.IDtcManagementService;
import pt.efacec.toolkit.misc.Strings;

@Repository(value="timetable")
public class TimetableDAO
extends TimetableDAOBase {
    @Autowired
    private IDtcDAO dtcDAO;
    @Autowired
    private IDtcManagementService dtcMangementService;

    @Override
    public Timetable save(Timetable entity) {
        boolean isNew = entity.getVersion() == null;
        Timetable e = super.save(entity);
        if (!isNew) {
            Set<Profile> profiles = this.getProfiles(entity.getId());
            for (Profile profile : profiles) {
                this.dtcMangementService.synchronizeDTCsForProfile(profile.getId());
            }
            HashSet<String> profileIds = new HashSet<String>();
            Set<Service> services = this.getServices(entity.getId());
            for (Service service : services) {
                profileIds.add(service.getProfileId());
            }
            for (String profileId : profileIds) {
                this.dtcMangementService.synchronizeDTCsForProfile(profileId);
            }
            Set<Dtc> dtcs = this.getDtcs(entity.getId());
            for (Dtc dtc : dtcs) {
                this.dtcMangementService.synchronizeOneDTC(dtc.getId());
            }
        }
        return e;
    }

    @Override
    protected SearchParam buildSearchSearchParam(TimetableSearchDTO criteria, String clientId, String operationalAreaId) {
        SearchParam searchParam;
        block14: {
            searchParam = new SearchParam();
            BooleanExpression expression = null;
            if (criteria.getOperationalAreaId() != null) {
                expression = QTimetable.timetable.operationalAreaId.eq((Object)criteria.getOperationalAreaId());
            } else if (operationalAreaId != null) {
                expression = QTimetable.timetable.operationalAreaId.isNull().or((Predicate)QTimetable.timetable.operationalAreaId.eq((Object)operationalAreaId));
            } else if (clientId != null) {
                HashSet<String> timetaleIds = new HashSet<String>();
                for (Dtc dtc : this.dtcDAO.findAllByClient(clientId)) {
                    if (dtc.getTimetableId() == null) continue;
                    timetaleIds.add(dtc.getTimetableId());
                }
                expression = timetaleIds.size() > 0 ? QTimetable.timetable.id.in(timetaleIds) : QTimetable.timetable.id.eq((Object)"0");
            }
            if (!Strings.isEmpty((String)criteria.getName())) {
                expression = SLUtil.and(expression, QTimetable.timetable.name.upper().like(criteria.getName().toUpperCase()));
            }
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block14;
            switch (criteria.getOrderBy()) {
                case "name": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QTimetable.timetable.name.asc() : QTimetable.timetable.name.desc());
                }
            }
        }
        return searchParam;
    }

    @Override
    protected Boolean handleExists(String operationalAreaId, String name) {
        JPAQuery query = (JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QTimetable.timetable})).where(new Predicate[]{(operationalAreaId == null ? QTimetable.timetable.operationalAreaId.isNull() : QTimetable.timetable.operationalAreaId.eq((Object)operationalAreaId)).and((Predicate)QTimetable.timetable.name.upper().eq((Object)name.toUpperCase()))});
        if (query.count() > 0L) {
            return true;
        }
        return false;
    }
}

