/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.ISpecialDayServiceDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.SpecialDayServiceSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Control;
import pt.efacec.smartlighting.common.core.entity.QControl;
import pt.efacec.smartlighting.common.core.entity.QSpecialDay;
import pt.efacec.smartlighting.common.core.entity.QSpecialDayService;
import pt.efacec.smartlighting.common.core.entity.SpecialDay;
import pt.efacec.smartlighting.common.core.entity.SpecialDayService;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class SpecialDayServiceDAOBase
implements ISpecialDayServiceDAO {
    private static final Log logger = Log.getLogger(SpecialDayServiceDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from SpecialDayService e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(SpecialDayService entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public SpecialDayService save(SpecialDayService entity) {
        String temp = null;
        temp = entity.getServiceName();
        if (temp != null && temp.length() > 255) {
            entity.setServiceName(temp.substring(0, 255));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (SpecialDayService)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public SpecialDayService findPersisted(SpecialDayService entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            SpecialDayService persisted = (SpecialDayService)this.em.find(SpecialDayService.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public SpecialDayService findById(String entityId) {
        return (SpecialDayService)this.em.find(SpecialDayService.class, (Object)entityId);
    }

    @Override
    public List<SpecialDayService> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDayService.specialDayService})).list((Expression)QSpecialDayService.specialDayService);
    }

    @Override
    public SpecialDayService findByNameAndSpecialDay(String serviceName, String specialDayId) {
        return (SpecialDayService)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDayService.specialDayService})).where(new Predicate[]{QSpecialDayService.specialDayService.serviceName.eq((Object)serviceName).and((Predicate)QSpecialDayService.specialDayService.specialDayId.eq((Object)specialDayId))})).uniqueResult((Expression)QSpecialDayService.specialDayService);
    }

    @Override
    public void loadSpecialDay(SpecialDayService entity) {
        if (entity != null) {
            entity.setSpecialDay(this.getSpecialDay(entity.getSpecialDayId()));
        }
    }

    @Override
    public SpecialDay getSpecialDay(String specialDayId) {
        if (specialDayId != null) {
            return (SpecialDay)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDay.specialDay})).where(new Predicate[]{QSpecialDay.specialDay.id.eq((Object)specialDayId)})).uniqueResult((Expression)QSpecialDay.specialDay);
        }
        return null;
    }

    @Override
    public List<SpecialDayService> findAllBySpecialDay(String specialDayId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDayService.specialDayService})).where(new Predicate[]{specialDayId == null ? QSpecialDayService.specialDayService.specialDayId.isNull() : QSpecialDayService.specialDayService.specialDayId.eq((Object)specialDayId)})).list((Expression)QSpecialDayService.specialDayService);
    }

    @Override
    public void loadControls(SpecialDayService entity) {
        if (entity != null && entity.getControls() == null) {
            entity.setControls(this.getControls(entity.getId()));
        }
    }

    @Override
    public Set<Control> getControls(String specialDayServiceId) {
        if (specialDayServiceId != null) {
            return new HashSet<Control>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QControl.control})).where(new Predicate[]{QControl.control.specialDayServiceId.eq((Object)specialDayServiceId)})).list((Expression)QControl.control));
        }
        return new HashSet<Control>();
    }

    @Override
    public Page<SpecialDayService> search(SpecialDayServiceSearchDTO criteria) {
        try {
            SearchParam searchParam = this.buildSearchSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearch(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearch(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<SpecialDayService> list = this.queryForSearch(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing search.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing search.", e);
        }
    }

    protected JPAQuery createQueryForSearch(SpecialDayServiceSearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDayService.specialDayService});
    }

    protected List<SpecialDayService> queryForSearch(JPAQuery query) {
        return query.list((Expression)QSpecialDayService.specialDayService);
    }

    protected abstract SearchParam buildSearchSearchParam(SpecialDayServiceSearchDTO var1);
}

