/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.SpecialDayServiceDAOBase;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.SpecialDayServiceSearchDTO;
import pt.efacec.smartlighting.common.core.entity.QSpecialDayService;
import pt.efacec.smartlighting.common.core.entity.SpecialDay;
import pt.efacec.smartlighting.common.core.entity.SpecialDayService;
import pt.efacec.smartlighting.common.core.service.IDtcManagementService;

@Repository(value="specialDayService")
public class SpecialDayServiceDAO
extends SpecialDayServiceDAOBase {
    @Autowired
    private IDtcManagementService dtcMangementService;

    @Override
    public SpecialDayService save(SpecialDayService entity) {
        SpecialDayService e = super.save(entity);
        SpecialDay sd = this.getSpecialDay(entity.getSpecialDayId());
        if (sd.getProfileId() != null) {
            this.dtcMangementService.synchronizeDTCsForProfile(sd.getProfileId());
        } else if (sd.getDtcId() != null) {
            this.dtcMangementService.synchronizeOneDTC(sd.getDtcId());
        }
        return e;
    }

    @Override
    public void remove(SpecialDayService entity) {
        super.remove(entity);
        SpecialDay sd = this.getSpecialDay(entity.getSpecialDayId());
        if (sd.getProfileId() != null) {
            this.dtcMangementService.synchronizeDTCsForProfile(sd.getProfileId());
        } else if (sd.getDtcId() != null) {
            this.dtcMangementService.synchronizeOneDTC(sd.getDtcId());
        }
    }

    @Override
    protected SearchParam buildSearchSearchParam(SpecialDayServiceSearchDTO criteria) {
        SearchParam searchParam;
        block7: {
            searchParam = new SearchParam();
            searchParam.setPredicate(QSpecialDayService.specialDayService.specialDayId.eq((Object)criteria.getSpecialDayId()));
            if (criteria.getOrderBy() == null) break block7;
            switch (criteria.getOrderBy()) {
                case "serviceName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QSpecialDayService.specialDayService.serviceName.asc() : QSpecialDayService.specialDayService.serviceName.desc());
                }
            }
        }
        return searchParam;
    }
}

