/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.ISpecialDayDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.DtcChildSearchDTO;
import pt.efacec.smartlighting.common.core.dto.ProfileChildSearchDTO;
import pt.efacec.smartlighting.common.core.dto.SpecialDaySearchDTO;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QProfile;
import pt.efacec.smartlighting.common.core.entity.QSpecialDay;
import pt.efacec.smartlighting.common.core.entity.QSpecialDayService;
import pt.efacec.smartlighting.common.core.entity.SpecialDay;
import pt.efacec.smartlighting.common.core.entity.SpecialDayService;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class SpecialDayDAOBase
implements ISpecialDayDAO {
    private static final Log logger = Log.getLogger(SpecialDayDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from SpecialDay e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(SpecialDay entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public SpecialDay save(SpecialDay entity) {
        String temp = null;
        temp = entity.getName();
        if (temp != null && temp.length() > 100) {
            entity.setName(temp.substring(0, 100));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (SpecialDay)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public SpecialDay findPersisted(SpecialDay entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            SpecialDay persisted = (SpecialDay)this.em.find(SpecialDay.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public SpecialDay findById(String entityId) {
        return (SpecialDay)this.em.find(SpecialDay.class, (Object)entityId);
    }

    @Override
    public List<SpecialDay> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDay.specialDay})).list((Expression)QSpecialDay.specialDay);
    }

    @Override
    public void loadProfile(SpecialDay entity) {
        if (entity != null) {
            entity.setProfile(this.getProfile(entity.getProfileId()));
        }
    }

    @Override
    public Profile getProfile(String profileId) {
        if (profileId != null) {
            return (Profile)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QProfile.profile})).where(new Predicate[]{QProfile.profile.id.eq((Object)profileId)})).uniqueResult((Expression)QProfile.profile);
        }
        return null;
    }

    @Override
    public List<SpecialDay> findAllByProfile(String profileId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDay.specialDay})).where(new Predicate[]{profileId == null ? QSpecialDay.specialDay.profileId.isNull() : QSpecialDay.specialDay.profileId.eq((Object)profileId)})).list((Expression)QSpecialDay.specialDay);
    }

    @Override
    public void loadDtc(SpecialDay entity) {
        if (entity != null) {
            entity.setDtc(this.getDtc(entity.getDtcId()));
        }
    }

    @Override
    public Dtc getDtc(String dtcId) {
        if (dtcId != null) {
            return (Dtc)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.id.eq((Object)dtcId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).uniqueResult((Expression)QDtc.dtc);
        }
        return null;
    }

    @Override
    public List<SpecialDay> findAllByDtc(String dtcId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDay.specialDay})).where(new Predicate[]{dtcId == null ? QSpecialDay.specialDay.dtcId.isNull() : QSpecialDay.specialDay.dtcId.eq((Object)dtcId)})).list((Expression)QSpecialDay.specialDay);
    }

    @Override
    public void loadSpecialDayServices(SpecialDay entity) {
        if (entity != null && entity.getSpecialDayServices() == null) {
            entity.setSpecialDayServices(this.getSpecialDayServices(entity.getId()));
        }
    }

    @Override
    public Set<SpecialDayService> getSpecialDayServices(String specialDayId) {
        if (specialDayId != null) {
            return new HashSet<SpecialDayService>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDayService.specialDayService})).where(new Predicate[]{QSpecialDayService.specialDayService.specialDayId.eq((Object)specialDayId)})).list((Expression)QSpecialDayService.specialDayService));
        }
        return new HashSet<SpecialDayService>();
    }

    @Override
    public Page<SpecialDay> search(SpecialDaySearchDTO criteria, List<String> profileIds, List<String> dtcIds) {
        try {
            SearchParam searchParam = this.buildSearchSearchParam(criteria, profileIds, dtcIds);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearch(criteria, profileIds, dtcIds);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearch(criteria, profileIds, dtcIds);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<SpecialDay> list = this.queryForSearch(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing search.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing search.", e);
        }
    }

    protected JPAQuery createQueryForSearch(SpecialDaySearchDTO criteria, List<String> profileIds, List<String> dtcIds) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDay.specialDay});
    }

    protected List<SpecialDay> queryForSearch(JPAQuery query) {
        return query.list((Expression)QSpecialDay.specialDay);
    }

    protected abstract SearchParam buildSearchSearchParam(SpecialDaySearchDTO var1, List<String> var2, List<String> var3);

    @Override
    public Page<SpecialDay> searchForProfile(ProfileChildSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"SpecialDayDAO.searchForProfile", "criteria"});
        }
        try {
            SearchParam searchParam = this.buildSearchForProfileSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearchForProfile(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearchForProfile(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<SpecialDay> list = this.queryForSearchForProfile(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing searchForProfile.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing searchForProfile.", e);
        }
    }

    protected JPAQuery createQueryForSearchForProfile(ProfileChildSearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDay.specialDay});
    }

    protected List<SpecialDay> queryForSearchForProfile(JPAQuery query) {
        return query.list((Expression)QSpecialDay.specialDay);
    }

    protected abstract SearchParam buildSearchForProfileSearchParam(ProfileChildSearchDTO var1);

    @Override
    public Page<SpecialDay> searchForDtc(DtcChildSearchDTO criteria) {
        try {
            SearchParam searchParam = this.buildSearchForDtcSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearchForDtc(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearchForDtc(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<SpecialDay> list = this.queryForSearchForDtc(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing searchForDtc.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing searchForDtc.", e);
        }
    }

    protected JPAQuery createQueryForSearchForDtc(DtcChildSearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDay.specialDay});
    }

    protected List<SpecialDay> queryForSearchForDtc(JPAQuery query) {
        return query.list((Expression)QSpecialDay.specialDay);
    }

    protected abstract SearchParam buildSearchForDtcSearchParam(DtcChildSearchDTO var1);
}

