/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.types.expr.BooleanExpression;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.SpecialDayDAOBase;
import pt.efacec.smartlighting.business.misc.SLUtil;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.DtcChildSearchDTO;
import pt.efacec.smartlighting.common.core.dto.PageDTO;
import pt.efacec.smartlighting.common.core.dto.ProfileChildSearchDTO;
import pt.efacec.smartlighting.common.core.dto.SpecialDaySearchDTO;
import pt.efacec.smartlighting.common.core.entity.QSpecialDay;
import pt.efacec.smartlighting.common.core.entity.SpecialDay;
import pt.efacec.smartlighting.common.core.service.IDtcManagementService;
import pt.efacec.toolkit.misc.Strings;
import pt.efacec.toolkit.misc.Tool;

@Repository(value="specialDay")
public class SpecialDayDAO
extends SpecialDayDAOBase {
    @Autowired
    private IDtcManagementService dtcMangementService;

    @Override
    public SpecialDay save(SpecialDay entity) {
        SpecialDay persisted;
        boolean isNew = entity.getVersion() == null;
        boolean changed = false;
        changed = isNew ? true : !Tool.similar((Object)(persisted = this.findPersisted(entity)).getDay(), (Object)entity.getDay());
        SpecialDay e = super.save(entity);
        if (entity.getProfileId() != null && changed) {
            this.dtcMangementService.synchronizeDTCsForProfile(entity.getProfileId());
        } else if (entity.getDtcId() != null && changed) {
            this.dtcMangementService.synchronizeOneDTC(entity.getDtcId());
        }
        return e;
    }

    @Override
    public void remove(SpecialDay entity) {
        String profileId = entity.getProfileId();
        String dtcId = entity.getDtcId();
        super.remove(entity);
        if (profileId != null) {
            this.dtcMangementService.synchronizeDTCsForProfile(profileId);
        } else if (dtcId != null) {
            this.dtcMangementService.synchronizeOneDTC(dtcId);
        }
    }

    @Override
    protected SearchParam buildSearchForProfileSearchParam(ProfileChildSearchDTO criteria) {
        BooleanExpression expression = null;
        if (!Strings.isEmpty((String)criteria.getProfileId())) {
            expression = SLUtil.and(expression, QSpecialDay.specialDay.profileId.eq((Object)criteria.getProfileId()));
        }
        return this.common(expression, (PageDTO)criteria);
    }

    @Override
    protected SearchParam buildSearchForDtcSearchParam(DtcChildSearchDTO criteria) {
        BooleanExpression expression = null;
        if (!Strings.isEmpty((String)criteria.getDtcId())) {
            expression = SLUtil.and(expression, QSpecialDay.specialDay.dtcId.eq((Object)criteria.getDtcId()));
        }
        return this.common(expression, (PageDTO)criteria);
    }

    private SearchParam common(BooleanExpression expression, PageDTO page) {
        SearchParam searchParam;
        block10: {
            searchParam = new SearchParam();
            searchParam.setPredicate(expression);
            if (page.getOrderBy() == null) break block10;
            switch (page.getOrderBy()) {
                case "name": {
                    searchParam.setOrderSpecifier(page.getOrderAscending() != false ? QSpecialDay.specialDay.name.asc() : QSpecialDay.specialDay.name.desc());
                    break;
                }
                case "day": {
                    searchParam.setOrderSpecifier(page.getOrderAscending() != false ? QSpecialDay.specialDay.day.asc() : QSpecialDay.specialDay.day.desc());
                }
            }
        }
        return searchParam;
    }

    @Override
    protected SearchParam buildSearchSearchParam(SpecialDaySearchDTO criteria, List<String> profileId, List<String> dtcIds) {
        BooleanExpression expression = null;
        if (!Strings.isEmpty((String)criteria.getName())) {
            expression = SLUtil.and(expression, QSpecialDay.specialDay.name.upper().like(criteria.getName().toUpperCase()));
        }
        if (profileId != null && !profileId.isEmpty()) {
            expression = SLUtil.and(expression, QSpecialDay.specialDay.profileId.in(profileId));
        }
        if (dtcIds != null && !dtcIds.isEmpty()) {
            expression = SLUtil.and(expression, QSpecialDay.specialDay.dtcId.in(dtcIds));
        }
        return this.common(expression, (PageDTO)criteria);
    }
}

