/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IServiceStopwatchReportDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.ServiceSummaryDTO;
import pt.efacec.smartlighting.common.core.dto.ServiceSummarySearchDTO;
import pt.efacec.smartlighting.common.core.entity.QReport;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatchReport;
import pt.efacec.smartlighting.common.core.entity.Report;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatchReport;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class ServiceStopwatchReportDAOBase
implements IServiceStopwatchReportDAO {
    private static final Log logger = Log.getLogger(ServiceStopwatchReportDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from ServiceStopwatchReport e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(ServiceStopwatchReport entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public ServiceStopwatchReport save(ServiceStopwatchReport entity) {
        String temp = null;
        temp = entity.getDtcId();
        if (temp != null && temp.length() > 255) {
            entity.setDtcId(temp.substring(0, 255));
        }
        if ((temp = entity.getDtcName()) != null && temp.length() > 255) {
            entity.setDtcName(temp.substring(0, 255));
        }
        if ((temp = entity.getServiceName()) != null && temp.length() > 255) {
            entity.setServiceName(temp.substring(0, 255));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (ServiceStopwatchReport)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public ServiceStopwatchReport findPersisted(ServiceStopwatchReport entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            ServiceStopwatchReport persisted = (ServiceStopwatchReport)this.em.find(ServiceStopwatchReport.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public ServiceStopwatchReport findById(String entityId) {
        return (ServiceStopwatchReport)this.em.find(ServiceStopwatchReport.class, (Object)entityId);
    }

    @Override
    public List<ServiceStopwatchReport> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatchReport.serviceStopwatchReport})).list((Expression)QServiceStopwatchReport.serviceStopwatchReport);
    }

    @Override
    public void loadReportAccess(ServiceStopwatchReport entity) {
        if (entity != null) {
            entity.setReportAccess(this.getReportAccess(entity.getReportAccessId()));
        }
    }

    @Override
    public Report getReportAccess(String reportId) {
        if (reportId != null) {
            return (Report)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QReport.report})).where(new Predicate[]{QReport.report.id.eq((Object)reportId)})).uniqueResult((Expression)QReport.report);
        }
        return null;
    }

    @Override
    public List<ServiceStopwatchReport> findAllByReportAccess(String reportId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatchReport.serviceStopwatchReport})).where(new Predicate[]{reportId == null ? QServiceStopwatchReport.serviceStopwatchReport.reportAccessId.isNull() : QServiceStopwatchReport.serviceStopwatchReport.reportAccessId.eq((Object)reportId)})).list((Expression)QServiceStopwatchReport.serviceStopwatchReport);
    }

    @Override
    public void clear(String reportUid) {
        try {
            this.handleClear(reportUid);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing clear.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing clear.", e);
        }
    }

    protected abstract void handleClear(String var1);

    @Override
    public Page<ServiceSummaryDTO> search(ServiceSummarySearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceStopwatchReportDAO.search", "criteria"});
        }
        try {
            SearchParam searchParam = this.buildSearchSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearch(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearch(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<ServiceSummaryDTO> list = this.queryForSearch(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing search.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing search.", e);
        }
    }

    protected JPAQuery createQueryForSearch(ServiceSummarySearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatchReport.serviceStopwatchReport});
    }

    protected abstract List<ServiceSummaryDTO> queryForSearch(JPAQuery var1);

    protected abstract SearchParam buildSearchSearchParam(ServiceSummarySearchDTO var1);

    @Override
    public void addOrCreate(String reportId, String dtcId, String dtcName, String serviceName, Boolean state, Long minutes) {
        if (reportId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceStopwatchReportDAO.addOrCreate", "reportId"});
        }
        if (dtcId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceStopwatchReportDAO.addOrCreate", "dtcId"});
        }
        if (dtcName == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceStopwatchReportDAO.addOrCreate", "dtcName"});
        }
        if (serviceName == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceStopwatchReportDAO.addOrCreate", "serviceName"});
        }
        if (state == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceStopwatchReportDAO.addOrCreate", "state"});
        }
        if (minutes == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceStopwatchReportDAO.addOrCreate", "minutes"});
        }
        try {
            this.handleAddOrCreate(reportId, dtcId, dtcName, serviceName, state, minutes);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing addOrCreate.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing addOrCreate.", e);
        }
    }

    protected abstract void handleAddOrCreate(String var1, String var2, String var3, String var4, Boolean var5, Long var6);
}

