/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPAUpdateClause;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.ServiceStopwatchReportDAOBase;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.ServiceSummaryDTO;
import pt.efacec.smartlighting.common.core.dto.ServiceSummarySearchDTO;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatchReport;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatchReport;

@Repository(value="serviceStopwatchReport")
public class ServiceStopwatchReportDAO
extends ServiceStopwatchReportDAOBase {
    @Override
    protected void handleClear(String reportUid) {
        new JPADeleteClause(this.em, (EntityPath)QServiceStopwatchReport.serviceStopwatchReport).where(new Predicate[]{QServiceStopwatchReport.serviceStopwatchReport.reportAccessId.eq((Object)reportUid)}).execute();
        this.em.flush();
    }

    @Override
    protected SearchParam buildSearchSearchParam(ServiceSummarySearchDTO criteria) {
        SearchParam searchParam;
        block16: {
            searchParam = new SearchParam();
            searchParam.setPredicate(QServiceStopwatchReport.serviceStopwatchReport.reportAccessId.eq((Object)criteria.getReportUid()));
            if (criteria.getOrderBy() == null) break block16;
            switch (criteria.getOrderBy()) {
                case "dtcName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QServiceStopwatchReport.serviceStopwatchReport.dtcName.asc() : QServiceStopwatchReport.serviceStopwatchReport.dtcName.desc());
                    break;
                }
                case "serviceName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QServiceStopwatchReport.serviceStopwatchReport.serviceName.asc() : QServiceStopwatchReport.serviceStopwatchReport.serviceName.desc());
                    break;
                }
                case "state": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QServiceStopwatchReport.serviceStopwatchReport.state.asc() : QServiceStopwatchReport.serviceStopwatchReport.state.desc());
                    break;
                }
                case "minutes": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QServiceStopwatchReport.serviceStopwatchReport.minutes.asc() : QServiceStopwatchReport.serviceStopwatchReport.minutes.desc());
                }
            }
        }
        return searchParam;
    }

    @Override
    protected List<ServiceSummaryDTO> queryForSearch(JPAQuery query) {
        List result = query.list((Expression)QServiceStopwatchReport.serviceStopwatchReport);
        ArrayList<ServiceSummaryDTO> dtos = new ArrayList<ServiceSummaryDTO>();
        for (ServiceStopwatchReport r : result) {
            dtos.add(new ServiceSummaryDTO(r.getDtcId(), r.getDtcName(), r.getServiceName(), r.getState(), r.getMinutes()));
        }
        return dtos;
    }

    @Override
    protected void handleAddOrCreate(String reportId, String dtcId, String dtcName, String serviceName, Boolean state, Long minutes) {
        long result = new JPAUpdateClause(this.em, (EntityPath)QServiceStopwatchReport.serviceStopwatchReport).set(QServiceStopwatchReport.serviceStopwatchReport.minutes, (Expression)QServiceStopwatchReport.serviceStopwatchReport.minutes.add((Number)minutes)).where(new Predicate[]{QServiceStopwatchReport.serviceStopwatchReport.reportAccessId.eq((Object)reportId).and((Predicate)QServiceStopwatchReport.serviceStopwatchReport.dtcId.eq((Object)dtcId)).and((Predicate)QServiceStopwatchReport.serviceStopwatchReport.dtcName.eq((Object)dtcName)).and((Predicate)QServiceStopwatchReport.serviceStopwatchReport.serviceName.eq((Object)serviceName)).and((Predicate)QServiceStopwatchReport.serviceStopwatchReport.state.eq(state))}).execute();
        this.em.flush();
        this.em.clear();
        if (result == 0L) {
            ServiceStopwatchReport rep = new ServiceStopwatchReport();
            rep.setReportAccessId(reportId);
            rep.setDtcId(dtcId);
            rep.setDtcName(dtcName);
            rep.setServiceName(serviceName);
            rep.setState(state);
            rep.setMinutes(minutes);
            this.save(rep);
        }
    }
}

