/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IServiceStopwatchDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.DtcStateDTO;
import pt.efacec.smartlighting.common.core.dto.DtcStateSearchDTO;
import pt.efacec.smartlighting.common.core.dto.ServiceSummarySearchDTO;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.District;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.Municipality;
import pt.efacec.smartlighting.common.core.entity.OperationalArea;
import pt.efacec.smartlighting.common.core.entity.QClientEntity;
import pt.efacec.smartlighting.common.core.entity.QDistrict;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QDtcService;
import pt.efacec.smartlighting.common.core.entity.QMunicipality;
import pt.efacec.smartlighting.common.core.entity.QOperationalArea;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatch;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class ServiceStopwatchDAOBase
implements IServiceStopwatchDAO {
    private static final Log logger = Log.getLogger(ServiceStopwatchDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from ServiceStopwatch e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(ServiceStopwatch entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public ServiceStopwatch save(ServiceStopwatch entity) {
        String temp = null;
        temp = entity.getDtcName();
        if (temp != null && temp.length() > 255) {
            entity.setDtcName(temp.substring(0, 255));
        }
        if ((temp = entity.getServiceName()) != null && temp.length() > 255) {
            entity.setServiceName(temp.substring(0, 255));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (ServiceStopwatch)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public ServiceStopwatch findPersisted(ServiceStopwatch entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            ServiceStopwatch persisted = (ServiceStopwatch)this.em.find(ServiceStopwatch.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public ServiceStopwatch findById(String entityId) {
        return (ServiceStopwatch)this.em.find(ServiceStopwatch.class, (Object)entityId);
    }

    @Override
    public List<ServiceStopwatch> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).list((Expression)QServiceStopwatch.serviceStopwatch);
    }

    @Override
    public void loadOperationalArea(ServiceStopwatch entity) {
        if (entity != null) {
            entity.setOperationalArea(this.getOperationalArea(entity.getOperationalAreaId()));
        }
    }

    @Override
    public OperationalArea getOperationalArea(String operationalAreaId) {
        if (operationalAreaId != null) {
            return (OperationalArea)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QOperationalArea.operationalArea})).where(new Predicate[]{QOperationalArea.operationalArea.id.eq((Object)operationalAreaId)})).uniqueResult((Expression)QOperationalArea.operationalArea);
        }
        return null;
    }

    @Override
    public List<ServiceStopwatch> findAllByOperationalArea(String operationalAreaId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{operationalAreaId == null ? QServiceStopwatch.serviceStopwatch.operationalAreaId.isNull() : QServiceStopwatch.serviceStopwatch.operationalAreaId.eq((Object)operationalAreaId)})).list((Expression)QServiceStopwatch.serviceStopwatch);
    }

    @Override
    public void loadClient(ServiceStopwatch entity) {
        if (entity != null) {
            entity.setClient(this.getClient(entity.getClientId()));
        }
    }

    @Override
    public ClientEntity getClient(String clientEntityId) {
        if (clientEntityId != null) {
            return (ClientEntity)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QClientEntity.clientEntity})).where(new Predicate[]{QClientEntity.clientEntity.id.eq((Object)clientEntityId)})).uniqueResult((Expression)QClientEntity.clientEntity);
        }
        return null;
    }

    @Override
    public List<ServiceStopwatch> findAllByClient(String clientEntityId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{clientEntityId == null ? QServiceStopwatch.serviceStopwatch.clientId.isNull() : QServiceStopwatch.serviceStopwatch.clientId.eq((Object)clientEntityId)})).list((Expression)QServiceStopwatch.serviceStopwatch);
    }

    @Override
    public void loadService(ServiceStopwatch entity) {
        if (entity != null) {
            entity.setService(this.getService(entity.getServiceId()));
        }
    }

    @Override
    public DtcService getService(String dtcServiceId) {
        if (dtcServiceId != null) {
            return (DtcService)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcService.dtcService})).where(new Predicate[]{QDtcService.dtcService.id.eq((Object)dtcServiceId).and((Predicate)QDtcService.dtcService.deleted.eq((Object)"0"))})).uniqueResult((Expression)QDtcService.dtcService);
        }
        return null;
    }

    @Override
    public List<ServiceStopwatch> findAllByService(String dtcServiceId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{dtcServiceId == null ? QServiceStopwatch.serviceStopwatch.serviceId.isNull() : QServiceStopwatch.serviceStopwatch.serviceId.eq((Object)dtcServiceId)})).list((Expression)QServiceStopwatch.serviceStopwatch);
    }

    @Override
    public void loadDistrict(ServiceStopwatch entity) {
        if (entity != null) {
            entity.setDistrict(this.getDistrict(entity.getDistrictId()));
        }
    }

    @Override
    public District getDistrict(String districtId) {
        if (districtId != null) {
            return (District)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDistrict.district})).where(new Predicate[]{QDistrict.district.id.eq((Object)districtId)})).uniqueResult((Expression)QDistrict.district);
        }
        return null;
    }

    @Override
    public List<ServiceStopwatch> findAllByDistrict(String districtId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{districtId == null ? QServiceStopwatch.serviceStopwatch.districtId.isNull() : QServiceStopwatch.serviceStopwatch.districtId.eq((Object)districtId)})).list((Expression)QServiceStopwatch.serviceStopwatch);
    }

    @Override
    public void loadMunicipality(ServiceStopwatch entity) {
        if (entity != null) {
            entity.setMunicipality(this.getMunicipality(entity.getMunicipalityId()));
        }
    }

    @Override
    public Municipality getMunicipality(String municipalityId) {
        if (municipalityId != null) {
            return (Municipality)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QMunicipality.municipality})).where(new Predicate[]{QMunicipality.municipality.id.eq((Object)municipalityId)})).uniqueResult((Expression)QMunicipality.municipality);
        }
        return null;
    }

    @Override
    public List<ServiceStopwatch> findAllByMunicipality(String municipalityId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{municipalityId == null ? QServiceStopwatch.serviceStopwatch.municipalityId.isNull() : QServiceStopwatch.serviceStopwatch.municipalityId.eq((Object)municipalityId)})).list((Expression)QServiceStopwatch.serviceStopwatch);
    }

    @Override
    public void loadDtc(ServiceStopwatch entity) {
        if (entity != null) {
            entity.setDtc(this.getDtc(entity.getDtcId()));
        }
    }

    @Override
    public Dtc getDtc(String dtcId) {
        if (dtcId != null) {
            return (Dtc)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.id.eq((Object)dtcId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).uniqueResult((Expression)QDtc.dtc);
        }
        return null;
    }

    @Override
    public List<ServiceStopwatch> findAllByDtc(String dtcId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{dtcId == null ? QServiceStopwatch.serviceStopwatch.dtcId.isNull() : QServiceStopwatch.serviceStopwatch.dtcId.eq((Object)dtcId)})).list((Expression)QServiceStopwatch.serviceStopwatch);
    }

    @Override
    public void compute(ServiceSummarySearchDTO criteria, String clientId, String operationalId, Date now) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceStopwatchDAO.compute", "criteria"});
        }
        try {
            this.handleCompute(criteria, clientId, operationalId, now);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing compute.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing compute.", e);
        }
    }

    protected abstract void handleCompute(ServiceSummarySearchDTO var1, String var2, String var3, Date var4);

    @Override
    public ServiceStopwatch findRunning(String serviceId, Boolean state) {
        try {
            return this.handleFindRunning(serviceId, state);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing findRunning.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing findRunning.", e);
        }
    }

    protected abstract ServiceStopwatch handleFindRunning(String var1, Boolean var2);

    @Override
    public Page<DtcStateDTO> searchState(DtcStateSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceStopwatchDAO.searchState", "criteria"});
        }
        try {
            SearchParam searchParam = this.buildSearchStateSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearchState(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearchState(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<DtcStateDTO> list = this.queryForSearchState(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing searchState.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing searchState.", e);
        }
    }

    protected JPAQuery createQueryForSearchState(DtcStateSearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch});
    }

    protected abstract List<DtcStateDTO> queryForSearchState(JPAQuery var1);

    protected abstract SearchParam buildSearchStateSearchParam(DtcStateSearchDTO var1);

    @Override
    public Double computeClientPower(String clientId, Date start, Date end) {
        if (clientId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceStopwatchDAO.computeClientPower", "clientId"});
        }
        if (start == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceStopwatchDAO.computeClientPower", "start"});
        }
        try {
            return this.handleComputeClientPower(clientId, start, end);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing computeClientPower.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing computeClientPower.", e);
        }
    }

    protected abstract Double handleComputeClientPower(String var1, Date var2, Date var3);
}

