/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.BooleanBuilder;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.IDtcServiceDAO;
import pt.efacec.smartlighting.business.core.entitydao.IServiceStopwatchReportDAO;
import pt.efacec.smartlighting.business.core.entitydao.ServiceStopwatchDAOBase;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.DtcStateDTO;
import pt.efacec.smartlighting.common.core.dto.DtcStateSearchDTO;
import pt.efacec.smartlighting.common.core.dto.ServiceSummarySearchDTO;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatchReport;
import pt.efacec.toolkit.misc.Strings;
import pt.efacec.toolkit.misc.Tool;

@Repository(value="serviceStopwatch")
public class ServiceStopwatchDAO
extends ServiceStopwatchDAOBase {
    private static final int CHUNCK = 1000;
    @Autowired
    private IServiceStopwatchReportDAO stopwatchReportDAO;
    @Autowired
    private IDtcServiceDAO dtcServiceDAO;

    private BooleanBuilder createPredicate(ServiceSummarySearchDTO criteria, String clientId, String operationalId) {
        BooleanBuilder builder = new BooleanBuilder();
        if (clientId != null) {
            builder.and((Predicate)QServiceStopwatch.serviceStopwatch.clientId.eq((Object)clientId));
        }
        if (operationalId != null) {
            builder.and((Predicate)QServiceStopwatch.serviceStopwatch.operationalAreaId.eq((Object)operationalId));
        }
        if (criteria.getState() != null) {
            builder.and((Predicate)QServiceStopwatch.serviceStopwatch.state.eq(criteria.getState()));
        }
        if (criteria.getDistrictId() != null) {
            builder.and((Predicate)QServiceStopwatch.serviceStopwatch.districtId.eq((Object)criteria.getDistrictId()));
        }
        if (criteria.getMunicipalityId() != null) {
            builder.and((Predicate)QServiceStopwatch.serviceStopwatch.municipalityId.eq((Object)criteria.getMunicipalityId()));
        }
        if (!Strings.isEmpty((String)criteria.getDtcName())) {
            builder.and((Predicate)QServiceStopwatch.serviceStopwatch.dtcName.upper().like(criteria.getDtcName().toUpperCase()));
        }
        if (!Strings.isEmpty((String)criteria.getServiceName())) {
            builder.and((Predicate)QServiceStopwatch.serviceStopwatch.serviceName.upper().like(criteria.getServiceName().toUpperCase()));
        }
        return builder;
    }

    @Override
    protected void handleCompute(ServiceSummarySearchDTO criteria, String clientId, String operationalId, Date now) {
        List result;
        Date begin = criteria.getBeginDate();
        Date end = criteria.getEndDate() != null ? criteria.getEndDate() : now;
        BooleanBuilder builder = this.createPredicate(criteria, clientId, operationalId);
        builder.and((Predicate)QServiceStopwatch.serviceStopwatch.beginDate.gt((Comparable)begin).and((Predicate)QServiceStopwatch.serviceStopwatch.endDate.lt((Comparable)end)));
        JPAQuery query = (JPAQuery)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).groupBy(new Expression[]{QServiceStopwatch.serviceStopwatch.dtcName, QServiceStopwatch.serviceStopwatch.serviceName, QServiceStopwatch.serviceStopwatch.state})).where(new Predicate[]{builder});
        boolean more = true;
        long offset = 0L;
        while (more) {
            query.offset(offset);
            query.limit(offset + 1000L + 1L);
            result = query.list((Expression)QServiceStopwatch.serviceStopwatch.dtcId, (Expression)QServiceStopwatch.serviceStopwatch.dtcName, new Expression[]{QServiceStopwatch.serviceStopwatch.serviceName, QServiceStopwatch.serviceStopwatch.state, QServiceStopwatch.serviceStopwatch.minutes.sum()});
            if (result.size() <= 1000) {
                more = false;
            } else {
                result.get(result.size() - 1);
            }
            for (ServiceStopwatch sw : result) {
                ServiceStopwatchReport rep = new ServiceStopwatchReport();
                rep.setReportAccessId(criteria.getReportUid());
                rep.setDtcId((String)sw[0]);
                rep.setDtcName((String)sw[1]);
                rep.setServiceName((String)sw[2]);
                rep.setState((Boolean)sw[3]);
                rep.setMinutes(Long.valueOf(((Number)sw[4]).longValue()));
                this.stopwatchReportDAO.save(rep);
            }
            this.em.clear();
            offset += 1000L;
        }
        builder = this.createPredicate(criteria, clientId, operationalId);
        builder.and((Predicate)QServiceStopwatch.serviceStopwatch.beginDate.loe((Comparable)begin).and((Predicate)QServiceStopwatch.serviceStopwatch.endDate.goe((Comparable)begin)).or((Predicate)QServiceStopwatch.serviceStopwatch.beginDate.loe((Comparable)end).and((Predicate)QServiceStopwatch.serviceStopwatch.endDate.goe((Comparable)end))).or((Predicate)QServiceStopwatch.serviceStopwatch.running.isTrue().and((Predicate)QServiceStopwatch.serviceStopwatch.beginDate.loe((Comparable)begin).or((Predicate)QServiceStopwatch.serviceStopwatch.beginDate.loe((Comparable)end)))));
        query = (JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{builder});
        more = true;
        offset = 0L;
        while (more) {
            query.offset(offset);
            query.limit(offset + 1000L + 1L);
            result = query.list((Expression)QServiceStopwatch.serviceStopwatch);
            if (result.size() <= 1000) {
                more = false;
            } else {
                result.get(result.size() - 1);
            }
            for (ServiceStopwatch sw : result) {
                Date left = (Date)Tool.highest((Comparable[])new Date[]{begin, sw.getBeginDate()});
                Date right = (Date)Tool.lowest((Comparable[])new Date[]{end, sw.getEndDate() != null ? sw.getEndDate() : now});
                long minutes = (right.getTime() - left.getTime()) / 60000L;
                this.stopwatchReportDAO.addOrCreate(criteria.getReportUid(), sw.getDtcId(), sw.getDtcName(), sw.getServiceName(), sw.getState(), minutes);
            }
            this.em.clear();
            offset += 1000L;
        }
    }

    @Override
    protected ServiceStopwatch handleFindRunning(String serviceId, Boolean state) {
        return (ServiceStopwatch)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{QServiceStopwatch.serviceStopwatch.running.eq(Boolean.valueOf(true)).and((Predicate)QServiceStopwatch.serviceStopwatch.state.eq(state)).and((Predicate)QServiceStopwatch.serviceStopwatch.serviceId.eq((Object)serviceId))})).uniqueResult((Expression)QServiceStopwatch.serviceStopwatch);
    }

    @Override
    protected List<DtcStateDTO> queryForSearchState(JPAQuery query) {
        List result = query.list((Expression)QServiceStopwatch.serviceStopwatch);
        ArrayList<DtcStateDTO> dtos = new ArrayList<DtcStateDTO>();
        for (ServiceStopwatch r : result) {
            DtcService dtcService = this.dtcServiceDAO.findById(r.getServiceId());
            dtos.add(new DtcStateDTO(r.getDtcId(), r.getDtcName(), r.getServiceName(), r.getBeginDate(), r.getState(), dtcService != null ? dtcService.getMode() : null));
        }
        return dtos;
    }

    @Override
    protected SearchParam buildSearchStateSearchParam(DtcStateSearchDTO criteria) {
        SearchParam searchParam;
        block22: {
            searchParam = new SearchParam();
            BooleanExpression expression = null;
            expression = QServiceStopwatch.serviceStopwatch.running.isTrue();
            if (!Strings.isEmpty((String)criteria.getDtcName())) {
                expression = expression.and((Predicate)QServiceStopwatch.serviceStopwatch.dtcName.lower().like(criteria.getDtcName().toLowerCase()));
            }
            if (!Strings.isEmpty((String)criteria.getServiceName())) {
                expression = expression.and((Predicate)QServiceStopwatch.serviceStopwatch.serviceName.lower().like(criteria.getServiceName().toLowerCase()));
            }
            if (!Strings.isEmpty((String)criteria.getDistrictId())) {
                expression = expression.and((Predicate)QServiceStopwatch.serviceStopwatch.districtId.eq((Object)criteria.getDistrictId()));
            }
            if (!Strings.isEmpty((String)criteria.getMunicipalityId())) {
                expression = expression.and((Predicate)QServiceStopwatch.serviceStopwatch.municipalityId.eq((Object)criteria.getMunicipalityId()));
            }
            if (!Strings.isEmpty((String)criteria.getOperationalAreaId())) {
                expression = expression.and((Predicate)QServiceStopwatch.serviceStopwatch.operationalAreaId.eq((Object)criteria.getOperationalAreaId()));
            }
            if (!Strings.isEmpty((String)criteria.getClientId())) {
                expression = expression.and((Predicate)QServiceStopwatch.serviceStopwatch.clientId.eq((Object)criteria.getClientId()));
            }
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block22;
            switch (criteria.getOrderBy()) {
                case "dtcName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QServiceStopwatch.serviceStopwatch.dtcName.asc() : QServiceStopwatch.serviceStopwatch.dtcName.desc());
                    break;
                }
                case "serviceName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QServiceStopwatch.serviceStopwatch.serviceName.asc() : QServiceStopwatch.serviceStopwatch.serviceName.desc());
                    break;
                }
                case "date": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QServiceStopwatch.serviceStopwatch.beginDate.asc() : QServiceStopwatch.serviceStopwatch.beginDate.desc());
                    break;
                }
                case "state": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QServiceStopwatch.serviceStopwatch.state.asc() : QServiceStopwatch.serviceStopwatch.state.desc());
                }
            }
        }
        return searchParam;
    }

    @Override
    protected Double handleComputeClientPower(String clientId, Date begin, Date end) {
        BooleanBuilder builder = new BooleanBuilder();
        if (clientId != null) {
            builder.and((Predicate)QServiceStopwatch.serviceStopwatch.clientId.eq((Object)clientId));
        }
        builder.and((Predicate)QServiceStopwatch.serviceStopwatch.state.eq(Boolean.valueOf(true))).and((Predicate)QServiceStopwatch.serviceStopwatch.beginDate.gt((Comparable)begin));
        if (end != null) {
            builder.and((Predicate)QServiceStopwatch.serviceStopwatch.endDate.lt((Comparable)end));
        }
        JPAQuery query = (JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{builder});
        return null;
    }
}

