/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IServiceDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.ProfileChildSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.QProfile;
import pt.efacec.smartlighting.common.core.entity.QService;
import pt.efacec.smartlighting.common.core.entity.QTimetable;
import pt.efacec.smartlighting.common.core.entity.Service;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class ServiceDAOBase
implements IServiceDAO {
    private static final Log logger = Log.getLogger(ServiceDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from Service e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(Service entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public Service save(Service entity) {
        String temp = null;
        temp = entity.getName();
        if (temp != null && temp.length() > 255) {
            entity.setName(temp.substring(0, 255));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (Service)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public Service findPersisted(Service entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            Service persisted = (Service)this.em.find(Service.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public Service findById(String entityId) {
        return (Service)this.em.find(Service.class, (Object)entityId);
    }

    @Override
    public List<Service> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QService.service})).list((Expression)QService.service);
    }

    @Override
    public Service findByNameAndProfile(String name, String profileId) {
        return (Service)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QService.service})).where(new Predicate[]{QService.service.name.eq((Object)name).and((Predicate)QService.service.profileId.eq((Object)profileId))})).uniqueResult((Expression)QService.service);
    }

    @Override
    public void loadProfile(Service entity) {
        if (entity != null) {
            entity.setProfile(this.getProfile(entity.getProfileId()));
        }
    }

    @Override
    public Profile getProfile(String profileId) {
        if (profileId != null) {
            return (Profile)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QProfile.profile})).where(new Predicate[]{QProfile.profile.id.eq((Object)profileId)})).uniqueResult((Expression)QProfile.profile);
        }
        return null;
    }

    @Override
    public List<Service> findAllByProfile(String profileId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QService.service})).where(new Predicate[]{profileId == null ? QService.service.profileId.isNull() : QService.service.profileId.eq((Object)profileId)})).list((Expression)QService.service);
    }

    @Override
    public void loadTimetable(Service entity) {
        if (entity != null) {
            entity.setTimetable(this.getTimetable(entity.getTimetableId()));
        }
    }

    @Override
    public Timetable getTimetable(String timetableId) {
        if (timetableId != null) {
            return (Timetable)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QTimetable.timetable})).where(new Predicate[]{QTimetable.timetable.id.eq((Object)timetableId)})).uniqueResult((Expression)QTimetable.timetable);
        }
        return null;
    }

    @Override
    public List<Service> findAllByTimetable(String timetableId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QService.service})).where(new Predicate[]{timetableId == null ? QService.service.timetableId.isNull() : QService.service.timetableId.eq((Object)timetableId)})).list((Expression)QService.service);
    }

    @Override
    public Page<Service> search(ProfileChildSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ServiceDAO.search", "criteria"});
        }
        try {
            SearchParam searchParam = this.buildSearchSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearch(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearch(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<Service> list = this.queryForSearch(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing search.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing search.", e);
        }
    }

    protected JPAQuery createQueryForSearch(ProfileChildSearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QService.service});
    }

    protected List<Service> queryForSearch(JPAQuery query) {
        return query.list((Expression)QService.service);
    }

    protected abstract SearchParam buildSearchSearchParam(ProfileChildSearchDTO var1);
}

