/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.types.expr.BooleanExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.ServiceDAOBase;
import pt.efacec.smartlighting.business.misc.SLUtil;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.ProfileChildSearchDTO;
import pt.efacec.smartlighting.common.core.entity.QService;
import pt.efacec.smartlighting.common.core.entity.Service;
import pt.efacec.smartlighting.common.core.service.IDtcManagementService;
import pt.efacec.toolkit.misc.Strings;
import pt.efacec.toolkit.misc.Tool;

@Repository(value="service")
public class ServiceDAO
extends ServiceDAOBase {
    @Autowired
    private IDtcManagementService dtcMangementService;

    @Override
    public Service save(Service entity) {
        Service persisted;
        boolean isNew = entity.getVersion() == null;
        boolean changed = false;
        changed = isNew ? entity.getTimetableId() != null && entity.getProfileId() != null : !Tool.similar((Object)(persisted = this.findPersisted(entity)).getTimetableId(), (Object)entity.getTimetableId());
        Service e = super.save(entity);
        if (changed) {
            this.dtcMangementService.synchronizeDTCsForProfile(entity.getProfileId());
        }
        return e;
    }

    @Override
    public void remove(Service entity) {
        String timetableId = entity.getTimetableId();
        super.remove(entity);
        if (timetableId != null) {
            this.dtcMangementService.synchronizeDTCsForProfile(entity.getProfileId());
        }
    }

    @Override
    protected SearchParam buildSearchSearchParam(ProfileChildSearchDTO criteria) {
        SearchParam searchParam;
        block8: {
            searchParam = new SearchParam();
            BooleanExpression expression = null;
            if (!Strings.isEmpty((String)criteria.getProfileId())) {
                expression = SLUtil.and(expression, QService.service.profileId.eq((Object)criteria.getProfileId()));
            }
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block8;
            switch (criteria.getOrderBy()) {
                case "name": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QService.service.name.asc() : QService.service.name.desc());
                }
            }
        }
        return searchParam;
    }
}

