/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IReportDAO;
import pt.efacec.smartlighting.common.core.entity.QReport;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatchReport;
import pt.efacec.smartlighting.common.core.entity.Report;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatchReport;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.misc.Log;

public abstract class ReportDAOBase
implements IReportDAO {
    private static final Log logger = Log.getLogger(ReportDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from Report e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(Report entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public Report save(Report entity) {
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (Report)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public Report findPersisted(Report entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            Report persisted = (Report)this.em.find(Report.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public Report findById(String entityId) {
        return (Report)this.em.find(Report.class, (Object)entityId);
    }

    @Override
    public List<Report> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QReport.report})).list((Expression)QReport.report);
    }

    @Override
    public void loadStopwatchReportLines(Report entity) {
        if (entity != null && entity.getStopwatchReportLines() == null) {
            entity.setStopwatchReportLines(this.getStopwatchReportLines(entity.getId()));
        }
    }

    @Override
    public Set<ServiceStopwatchReport> getStopwatchReportLines(String reportId) {
        if (reportId != null) {
            return new HashSet<ServiceStopwatchReport>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatchReport.serviceStopwatchReport})).where(new Predicate[]{QServiceStopwatchReport.serviceStopwatchReport.reportAccessId.eq((Object)reportId)})).list((Expression)QServiceStopwatchReport.serviceStopwatchReport));
        }
        return new HashSet<ServiceStopwatchReport>();
    }

    @Override
    public List<Report> findTimedOut(Long elapsed) {
        try {
            return this.handleFindTimedOut(elapsed);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing findTimedOut.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing findTimedOut.", e);
        }
    }

    protected abstract List<Report> handleFindTimedOut(Long var1);

    @Override
    public Boolean touch(String reportUid) {
        try {
            return this.handleTouch(reportUid);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing touch.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing touch.", e);
        }
    }

    protected abstract Boolean handleTouch(String var1);
}

