/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IProfileDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.ProfileSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.OperationalArea;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QOperationalArea;
import pt.efacec.smartlighting.common.core.entity.QProfile;
import pt.efacec.smartlighting.common.core.entity.QService;
import pt.efacec.smartlighting.common.core.entity.QSpecialDay;
import pt.efacec.smartlighting.common.core.entity.QTimetable;
import pt.efacec.smartlighting.common.core.entity.Service;
import pt.efacec.smartlighting.common.core.entity.SpecialDay;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class ProfileDAOBase
implements IProfileDAO {
    private static final Log logger = Log.getLogger(ProfileDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from Profile e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(Profile entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public Profile save(Profile entity) {
        String temp = null;
        temp = entity.getName();
        if (temp != null && temp.length() > 100) {
            entity.setName(temp.substring(0, 100));
        }
        if ((temp = entity.getDescription()) != null && temp.length() > 255) {
            entity.setDescription(temp.substring(0, 255));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (Profile)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public Profile findPersisted(Profile entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            Profile persisted = (Profile)this.em.find(Profile.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public Profile findById(String entityId) {
        return (Profile)this.em.find(Profile.class, (Object)entityId);
    }

    @Override
    public List<Profile> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QProfile.profile})).list((Expression)QProfile.profile);
    }

    @Override
    public void loadOperationalArea(Profile entity) {
        if (entity != null) {
            entity.setOperationalArea(this.getOperationalArea(entity.getOperationalAreaId()));
        }
    }

    @Override
    public OperationalArea getOperationalArea(String operationalAreaId) {
        if (operationalAreaId != null) {
            return (OperationalArea)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QOperationalArea.operationalArea})).where(new Predicate[]{QOperationalArea.operationalArea.id.eq((Object)operationalAreaId)})).uniqueResult((Expression)QOperationalArea.operationalArea);
        }
        return null;
    }

    @Override
    public List<Profile> findAllByOperationalArea(String operationalAreaId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QProfile.profile})).where(new Predicate[]{operationalAreaId == null ? QProfile.profile.operationalAreaId.isNull() : QProfile.profile.operationalAreaId.eq((Object)operationalAreaId)})).list((Expression)QProfile.profile);
    }

    @Override
    public void loadTimetable(Profile entity) {
        if (entity != null) {
            entity.setTimetable(this.getTimetable(entity.getTimetableId()));
        }
    }

    @Override
    public Timetable getTimetable(String timetableId) {
        if (timetableId != null) {
            return (Timetable)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QTimetable.timetable})).where(new Predicate[]{QTimetable.timetable.id.eq((Object)timetableId)})).uniqueResult((Expression)QTimetable.timetable);
        }
        return null;
    }

    @Override
    public List<Profile> findAllByTimetable(String timetableId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QProfile.profile})).where(new Predicate[]{timetableId == null ? QProfile.profile.timetableId.isNull() : QProfile.profile.timetableId.eq((Object)timetableId)})).list((Expression)QProfile.profile);
    }

    @Override
    public void loadDtcs(Profile entity) {
        if (entity != null && entity.getDtcs() == null) {
            entity.setDtcs(this.getDtcs(entity.getId()));
        }
    }

    @Override
    public Set<Dtc> getDtcs(String profileId) {
        if (profileId != null) {
            return new HashSet<Dtc>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.profileId.eq((Object)profileId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc));
        }
        return new HashSet<Dtc>();
    }

    @Override
    public void loadServices(Profile entity) {
        if (entity != null && entity.getServices() == null) {
            entity.setServices(this.getServices(entity.getId()));
        }
    }

    @Override
    public Set<Service> getServices(String profileId) {
        if (profileId != null) {
            return new HashSet<Service>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QService.service})).where(new Predicate[]{QService.service.profileId.eq((Object)profileId)})).list((Expression)QService.service));
        }
        return new HashSet<Service>();
    }

    @Override
    public void loadSpecialDays(Profile entity) {
        if (entity != null && entity.getSpecialDays() == null) {
            entity.setSpecialDays(this.getSpecialDays(entity.getId()));
        }
    }

    @Override
    public Set<SpecialDay> getSpecialDays(String profileId) {
        if (profileId != null) {
            return new HashSet<SpecialDay>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDay.specialDay})).where(new Predicate[]{QSpecialDay.specialDay.profileId.eq((Object)profileId)})).list((Expression)QSpecialDay.specialDay));
        }
        return new HashSet<SpecialDay>();
    }

    @Override
    public Page<Profile> search(ProfileSearchDTO criteria, String clientId, String operationalAreaId) {
        try {
            SearchParam searchParam = this.buildSearchSearchParam(criteria, clientId, operationalAreaId);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearch(criteria, clientId, operationalAreaId);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearch(criteria, clientId, operationalAreaId);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<Profile> list = this.queryForSearch(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing search.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing search.", e);
        }
    }

    protected JPAQuery createQueryForSearch(ProfileSearchDTO criteria, String clientId, String operationalAreaId) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QProfile.profile});
    }

    protected List<Profile> queryForSearch(JPAQuery query) {
        return query.list((Expression)QProfile.profile);
    }

    protected abstract SearchParam buildSearchSearchParam(ProfileSearchDTO var1, String var2, String var3);

    @Override
    public Profile findByNameAndOperationalArea(String name, String operationalAreaId) {
        if (name == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ProfileDAO.findByNameAndOperationalArea", "name"});
        }
        if (operationalAreaId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"ProfileDAO.findByNameAndOperationalArea", "operationalAreaId"});
        }
        try {
            return this.handleFindByNameAndOperationalArea(name, operationalAreaId);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing findByNameAndOperationalArea.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing findByNameAndOperationalArea.", e);
        }
    }

    protected abstract Profile handleFindByNameAndOperationalArea(String var1, String var2);
}

