/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPASubQuery;
import com.mysema.query.jpa.impl.JPAUpdateClause;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.ProfileDAOBase;
import pt.efacec.smartlighting.business.misc.SLUtil;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.ProfileSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QEvent;
import pt.efacec.smartlighting.common.core.entity.QProfile;
import pt.efacec.smartlighting.common.core.service.IDtcManagementService;
import pt.efacec.toolkit.misc.Strings;
import pt.efacec.toolkit.misc.Tool;

@Repository(value="profile")
public class ProfileDAO
extends ProfileDAOBase {
    @Autowired
    private IDtcManagementService dtcMangementService;

    @Override
    public Profile save(Profile entity) {
        boolean changed = false;
        if (entity.getVersion() != null) {
            Profile persisted = this.findPersisted(entity);
            boolean bl = changed = !Tool.similar((Object)persisted.getTimetableId(), (Object)entity.getTimetableId());
            if (!Tool.similar((Object)persisted.getName(), (Object)entity.getName())) {
                JPASubQuery sq = (JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.profileId.eq((Object)entity.getId())});
                new JPAUpdateClause(this.em, (EntityPath)QEvent.event).set((Path)QEvent.event.profileName, (Object)entity.getName()).where(new Predicate[]{QEvent.event.dtcId.in((CollectionExpression)sq.list((Expression)QDtc.dtc.id))}).execute();
            }
        }
        Profile e = super.save(entity);
        if (changed) {
            this.dtcMangementService.synchronizeDTCsForProfile(entity.getId());
        }
        return e;
    }

    @Override
    protected SearchParam buildSearchSearchParam(ProfileSearchDTO criteria, String clientId, String operationalAreaId) {
        SearchParam searchParam;
        block14: {
            searchParam = new SearchParam();
            BooleanExpression expression = null;
            if (operationalAreaId != null) {
                expression = SLUtil.and(expression, QProfile.profile.operationalAreaId.eq((Object)operationalAreaId));
            } else if (clientId != null) {
                List profileIds = ((JPAQuery)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).distinct()).where(new Predicate[]{QDtc.dtc.clientId.eq((Object)clientId).and((Predicate)QDtc.dtc.profileId.isNotNull())})).list((Expression)QDtc.dtc.profileId);
                expression = profileIds.isEmpty() ? SLUtil.and(expression, QProfile.profile.id.eq((Object)"0")) : SLUtil.and(expression, QProfile.profile.id.in((Collection)profileIds));
            }
            if (!Strings.isEmpty((String)criteria.getName())) {
                expression = SLUtil.and(expression, QProfile.profile.name.upper().like(criteria.getName().toUpperCase()));
            }
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block14;
            switch (criteria.getOrderBy()) {
                case "name": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QProfile.profile.name.asc() : QProfile.profile.name.desc());
                    break;
                }
                case "description": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QProfile.profile.description.asc() : QProfile.profile.description.desc());
                }
            }
        }
        return searchParam;
    }

    @Override
    protected Profile handleFindByNameAndOperationalArea(String name, String operationalAreaId) {
        return (Profile)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QProfile.profile})).where(new Predicate[]{QProfile.profile.name.equalsIgnoreCase(name).and((Predicate)QProfile.profile.operationalAreaId.eq((Object)operationalAreaId))})).uniqueResult((Expression)QProfile.profile);
    }
}

