/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IPeriodDAO;
import pt.efacec.smartlighting.common.core.entity.Control;
import pt.efacec.smartlighting.common.core.entity.Period;
import pt.efacec.smartlighting.common.core.entity.QControl;
import pt.efacec.smartlighting.common.core.entity.QPeriod;
import pt.efacec.smartlighting.common.core.entity.QTimetable;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.misc.Log;

public abstract class PeriodDAOBase
implements IPeriodDAO {
    private static final Log logger = Log.getLogger(PeriodDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from Period e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(Period entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public Period save(Period entity) {
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (Period)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public Period findPersisted(Period entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            Period persisted = (Period)this.em.find(Period.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public Period findById(String entityId) {
        return (Period)this.em.find(Period.class, (Object)entityId);
    }

    @Override
    public List<Period> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QPeriod.period})).list((Expression)QPeriod.period);
    }

    @Override
    public void loadTimetable(Period entity) {
        if (entity != null) {
            entity.setTimetable(this.getTimetable(entity.getTimetableId()));
        }
    }

    @Override
    public Timetable getTimetable(String timetableId) {
        if (timetableId != null) {
            return (Timetable)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QTimetable.timetable})).where(new Predicate[]{QTimetable.timetable.id.eq((Object)timetableId)})).uniqueResult((Expression)QTimetable.timetable);
        }
        return null;
    }

    @Override
    public List<Period> findAllByTimetable(String timetableId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QPeriod.period})).where(new Predicate[]{timetableId == null ? QPeriod.period.timetableId.isNull() : QPeriod.period.timetableId.eq((Object)timetableId)})).list((Expression)QPeriod.period);
    }

    @Override
    public void loadControls(Period entity) {
        if (entity != null && entity.getControls() == null) {
            entity.setControls(this.getControls(entity.getId()));
        }
    }

    @Override
    public Set<Control> getControls(String periodId) {
        if (periodId != null) {
            return new HashSet<Control>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QControl.control})).where(new Predicate[]{QControl.control.periodId.eq((Object)periodId)})).list((Expression)QControl.control));
        }
        return new HashSet<Control>();
    }

    @Override
    public List<Period> findAllByTimetableOrderByStart(String timetableId) {
        try {
            return this.handleFindAllByTimetableOrderByStart(timetableId);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing findAllByTimetableOrderByStart.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing findAllByTimetableOrderByStart.", e);
        }
    }

    protected abstract List<Period> handleFindAllByTimetableOrderByStart(String var1);
}

