/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IOperationalAreaDAO;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.OperationalArea;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QOperationalArea;
import pt.efacec.smartlighting.common.core.entity.QProfile;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.QTimetable;
import pt.efacec.smartlighting.common.core.entity.QUser;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.toolkit.misc.Log;

public abstract class OperationalAreaDAOBase
implements IOperationalAreaDAO {
    private static final Log logger = Log.getLogger(OperationalAreaDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from OperationalArea e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(OperationalArea entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public OperationalArea save(OperationalArea entity) {
        String temp = null;
        temp = entity.getName();
        if (temp != null && temp.length() > 100) {
            entity.setName(temp.substring(0, 100));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (OperationalArea)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public OperationalArea findPersisted(OperationalArea entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            OperationalArea persisted = (OperationalArea)this.em.find(OperationalArea.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public OperationalArea findById(String entityId) {
        return (OperationalArea)this.em.find(OperationalArea.class, (Object)entityId);
    }

    @Override
    public List<OperationalArea> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QOperationalArea.operationalArea})).list((Expression)QOperationalArea.operationalArea);
    }

    @Override
    public void loadUsers(OperationalArea entity) {
        if (entity != null && entity.getUsers() == null) {
            entity.setUsers(this.getUsers(entity.getId()));
        }
    }

    @Override
    public Set<User> getUsers(String operationalAreaId) {
        if (operationalAreaId != null) {
            return new HashSet<User>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{QUser.user.operationalAreaId.eq((Object)operationalAreaId).and((Predicate)QUser.user.deleted.eq((Object)"0"))})).list((Expression)QUser.user));
        }
        return new HashSet<User>();
    }

    @Override
    public void loadDtcs(OperationalArea entity) {
        if (entity != null && entity.getDtcs() == null) {
            entity.setDtcs(this.getDtcs(entity.getId()));
        }
    }

    @Override
    public Set<Dtc> getDtcs(String operationalAreaId) {
        if (operationalAreaId != null) {
            return new HashSet<Dtc>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.operationalAreaId.eq((Object)operationalAreaId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc));
        }
        return new HashSet<Dtc>();
    }

    @Override
    public void loadTimetables(OperationalArea entity) {
        if (entity != null && entity.getTimetables() == null) {
            entity.setTimetables(this.getTimetables(entity.getId()));
        }
    }

    @Override
    public Set<Timetable> getTimetables(String operationalAreaId) {
        if (operationalAreaId != null) {
            return new HashSet<Timetable>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QTimetable.timetable})).where(new Predicate[]{QTimetable.timetable.operationalAreaId.eq((Object)operationalAreaId)})).list((Expression)QTimetable.timetable));
        }
        return new HashSet<Timetable>();
    }

    @Override
    public void loadProfiles(OperationalArea entity) {
        if (entity != null && entity.getProfiles() == null) {
            entity.setProfiles(this.getProfiles(entity.getId()));
        }
    }

    @Override
    public Set<Profile> getProfiles(String operationalAreaId) {
        if (operationalAreaId != null) {
            return new HashSet<Profile>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QProfile.profile})).where(new Predicate[]{QProfile.profile.operationalAreaId.eq((Object)operationalAreaId)})).list((Expression)QProfile.profile));
        }
        return new HashSet<Profile>();
    }

    @Override
    public void loadTimers(OperationalArea entity) {
        if (entity != null && entity.getTimers() == null) {
            entity.setTimers(this.getTimers(entity.getId()));
        }
    }

    @Override
    public Set<ServiceStopwatch> getTimers(String operationalAreaId) {
        if (operationalAreaId != null) {
            return new HashSet<ServiceStopwatch>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{QServiceStopwatch.serviceStopwatch.operationalAreaId.eq((Object)operationalAreaId)})).list((Expression)QServiceStopwatch.serviceStopwatch));
        }
        return new HashSet<ServiceStopwatch>();
    }
}

