/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IMunicipalityDAO;
import pt.efacec.smartlighting.common.core.entity.District;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.Municipality;
import pt.efacec.smartlighting.common.core.entity.QDistrict;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QMunicipality;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatch;
import pt.efacec.toolkit.misc.Log;

public abstract class MunicipalityDAOBase
implements IMunicipalityDAO {
    private static final Log logger = Log.getLogger(MunicipalityDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from Municipality e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(Municipality entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public Municipality save(Municipality entity) {
        String temp = null;
        temp = entity.getName();
        if (temp != null && temp.length() > 100) {
            entity.setName(temp.substring(0, 100));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (Municipality)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public Municipality findPersisted(Municipality entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            Municipality persisted = (Municipality)this.em.find(Municipality.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public Municipality findById(String entityId) {
        return (Municipality)this.em.find(Municipality.class, (Object)entityId);
    }

    @Override
    public List<Municipality> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QMunicipality.municipality})).list((Expression)QMunicipality.municipality);
    }

    @Override
    public void loadDistrict(Municipality entity) {
        if (entity != null) {
            entity.setDistrict(this.getDistrict(entity.getDistrictId()));
        }
    }

    @Override
    public District getDistrict(String districtId) {
        if (districtId != null) {
            return (District)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDistrict.district})).where(new Predicate[]{QDistrict.district.id.eq((Object)districtId)})).uniqueResult((Expression)QDistrict.district);
        }
        return null;
    }

    @Override
    public List<Municipality> findAllByDistrict(String districtId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QMunicipality.municipality})).where(new Predicate[]{districtId == null ? QMunicipality.municipality.districtId.isNull() : QMunicipality.municipality.districtId.eq((Object)districtId)})).list((Expression)QMunicipality.municipality);
    }

    @Override
    public void loadDtcs(Municipality entity) {
        if (entity != null && entity.getDtcs() == null) {
            entity.setDtcs(this.getDtcs(entity.getId()));
        }
    }

    @Override
    public Set<Dtc> getDtcs(String municipalityId) {
        if (municipalityId != null) {
            return new HashSet<Dtc>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.municipalityId.eq((Object)municipalityId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc));
        }
        return new HashSet<Dtc>();
    }

    @Override
    public void loadTimers(Municipality entity) {
        if (entity != null && entity.getTimers() == null) {
            entity.setTimers(this.getTimers(entity.getId()));
        }
    }

    @Override
    public Set<ServiceStopwatch> getTimers(String municipalityId) {
        if (municipalityId != null) {
            return new HashSet<ServiceStopwatch>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{QServiceStopwatch.serviceStopwatch.municipalityId.eq((Object)municipalityId)})).list((Expression)QServiceStopwatch.serviceStopwatch));
        }
        return new HashSet<ServiceStopwatch>();
    }
}

