/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IEventDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.DtcTransitionDTO;
import pt.efacec.smartlighting.common.core.dto.DtcTransitionSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.Event;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QDtcService;
import pt.efacec.smartlighting.common.core.entity.QEvent;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class EventDAOBase
implements IEventDAO {
    private static final Log logger = Log.getLogger(EventDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from Event e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(Event entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public Event save(Event entity) {
        String temp = null;
        temp = entity.getValue();
        if (temp != null && temp.length() > 255) {
            entity.setValue(temp.substring(0, 255));
        }
        if ((temp = entity.getClientName()) != null && temp.length() > 255) {
            entity.setClientName(temp.substring(0, 255));
        }
        if ((temp = entity.getDtcName()) != null && temp.length() > 255) {
            entity.setDtcName(temp.substring(0, 255));
        }
        if ((temp = entity.getServiceName()) != null && temp.length() > 255) {
            entity.setServiceName(temp.substring(0, 255));
        }
        if ((temp = entity.getProfileName()) != null && temp.length() > 255) {
            entity.setProfileName(temp.substring(0, 255));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (Event)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public Event findPersisted(Event entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            Event persisted = (Event)this.em.find(Event.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public Event findById(String entityId) {
        return (Event)this.em.find(Event.class, (Object)entityId);
    }

    @Override
    public List<Event> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QEvent.event})).list((Expression)QEvent.event);
    }

    @Override
    public void loadDtc(Event entity) {
        if (entity != null) {
            entity.setDtc(this.getDtc(entity.getDtcId()));
        }
    }

    @Override
    public Dtc getDtc(String dtcId) {
        if (dtcId != null) {
            return (Dtc)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.id.eq((Object)dtcId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).uniqueResult((Expression)QDtc.dtc);
        }
        return null;
    }

    @Override
    public List<Event> findAllByDtc(String dtcId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QEvent.event})).where(new Predicate[]{dtcId == null ? QEvent.event.dtcId.isNull() : QEvent.event.dtcId.eq((Object)dtcId)})).list((Expression)QEvent.event);
    }

    @Override
    public void loadDtcService(Event entity) {
        if (entity != null) {
            entity.setDtcService(this.getDtcService(entity.getDtcServiceId()));
        }
    }

    @Override
    public DtcService getDtcService(String dtcServiceId) {
        if (dtcServiceId != null) {
            return (DtcService)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcService.dtcService})).where(new Predicate[]{QDtcService.dtcService.id.eq((Object)dtcServiceId).and((Predicate)QDtcService.dtcService.deleted.eq((Object)"0"))})).uniqueResult((Expression)QDtcService.dtcService);
        }
        return null;
    }

    @Override
    public List<Event> findAllByDtcService(String dtcServiceId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QEvent.event})).where(new Predicate[]{dtcServiceId == null ? QEvent.event.dtcServiceId.isNull() : QEvent.event.dtcServiceId.eq((Object)dtcServiceId)})).list((Expression)QEvent.event);
    }

    @Override
    public void removeAllForDctService(String serviceUid) {
        try {
            this.handleRemoveAllForDctService(serviceUid);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing removeAllForDctService.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing removeAllForDctService.", e);
        }
    }

    protected abstract void handleRemoveAllForDctService(String var1);

    @Override
    public Page<DtcTransitionDTO> searchDtcTransitions(DtcTransitionSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"EventDAO.searchDtcTransitions", "criteria"});
        }
        try {
            SearchParam searchParam = this.buildSearchDtcTransitionsSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearchDtcTransitions(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearchDtcTransitions(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<DtcTransitionDTO> list = this.queryForSearchDtcTransitions(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing searchDtcTransitions.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing searchDtcTransitions.", e);
        }
    }

    protected JPAQuery createQueryForSearchDtcTransitions(DtcTransitionSearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QEvent.event});
    }

    protected abstract List<DtcTransitionDTO> queryForSearchDtcTransitions(JPAQuery var1);

    protected abstract SearchParam buildSearchDtcTransitionsSearchParam(DtcTransitionSearchDTO var1);
}

