/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPASubQuery;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.EventDAOBase;
import pt.efacec.smartlighting.business.core.entitydao.IClientEntityDAO;
import pt.efacec.smartlighting.business.core.entitydao.IDtcDAO;
import pt.efacec.smartlighting.business.core.entitydao.IDtcServiceDAO;
import pt.efacec.smartlighting.business.core.entitydao.IProfileDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.DtcTransitionDTO;
import pt.efacec.smartlighting.common.core.dto.DtcTransitionSearchDTO;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.Event;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QEvent;
import pt.efacec.smartlighting.common.core.lov.EventLOV;
import pt.efacec.toolkit.misc.Strings;

@Repository(value="event")
public class EventDAO
extends EventDAOBase {
    @Autowired
    private IDtcDAO dtcDAO;
    @Autowired
    private IClientEntityDAO clientEntityDAO;
    @Autowired
    private IProfileDAO profileDAO;
    @Autowired
    private IDtcServiceDAO dtcServiceDAO;

    @Override
    public Event save(Event entity) {
        if (entity.getDtcId() != null) {
            Dtc dtc = this.dtcDAO.findById(entity.getDtcId());
            entity.setDtcName(dtc.getName());
            if (dtc.getClientId() != null) {
                ClientEntity ce = this.clientEntityDAO.findById(dtc.getClientId());
                entity.setClientName(ce.getName());
            }
            if (dtc.getProfileId() != null) {
                Profile profile = this.profileDAO.findById(dtc.getProfileId());
                entity.setProfileName(profile.getName());
            }
        }
        if (entity.getDtcServiceId() != null) {
            DtcService srv = this.dtcServiceDAO.findById(entity.getDtcServiceId());
            entity.setServiceName(srv.getName());
        }
        return super.save(entity);
    }

    @Override
    protected void handleRemoveAllForDctService(String serviceUid) {
        new JPADeleteClause(this.em, (EntityPath)QEvent.event).where(new Predicate[]{QEvent.event.dtcServiceId.eq((Object)serviceUid)});
    }

    @Override
    protected List<DtcTransitionDTO> queryForSearchDtcTransitions(JPAQuery query) {
        List result = query.list((Expression)QEvent.event);
        ArrayList<DtcTransitionDTO> dtos = new ArrayList<DtcTransitionDTO>();
        for (Event r : result) {
            DtcTransitionDTO dto = new DtcTransitionDTO();
            dtos.add(dto);
            dto.setDtcId(r.getDtcId());
            dto.setClientName(r.getClientName());
            dto.setDtcName(r.getDtcName());
            dto.setServiceName(r.getServiceName());
            dto.setProfileName(dto.getProfileName());
            dto.setDate(r.getTime());
            dto.setState(Boolean.valueOf("true".equals(r.getValue())));
        }
        return dtos;
    }

    @Override
    protected SearchParam buildSearchDtcTransitionsSearchParam(DtcTransitionSearchDTO criteria) {
        SearchParam searchParam;
        block34: {
            JPASubQuery sq;
            BooleanExpression expression = QEvent.event.type.eq((Object)EventLOV.STATE);
            if (!Strings.isEmpty((String)criteria.getDtcName())) {
                expression = expression.and((Predicate)QEvent.event.dtcName.lower().like(criteria.getDtcName().toLowerCase()));
            }
            if (!Strings.isEmpty((String)criteria.getServiceName())) {
                expression = expression.and((Predicate)QEvent.event.serviceName.lower().like(criteria.getServiceName().toLowerCase()));
            }
            if (!Strings.isEmpty((String)criteria.getProfileName())) {
                expression = expression.and((Predicate)QEvent.event.profileName.lower().like(criteria.getProfileName().toLowerCase()));
            }
            if (!Strings.isEmpty((String)criteria.getDistrictId())) {
                sq = (JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.districtId.eq((Object)criteria.getDistrictId())});
                expression = expression.and((Predicate)QEvent.event.dtcId.in((CollectionExpression)sq.list((Expression)QDtc.dtc.id)));
            }
            if (!Strings.isEmpty((String)criteria.getMunicipalityId())) {
                sq = (JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.municipalityId.eq((Object)criteria.getMunicipalityId())});
                expression = expression.and((Predicate)QEvent.event.dtcId.in((CollectionExpression)sq.list((Expression)QDtc.dtc.id)));
            }
            if (!Strings.isEmpty((String)criteria.getOperationalAreaId())) {
                sq = (JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.operationalAreaId.eq((Object)criteria.getOperationalAreaId())});
                expression = expression.and((Predicate)QEvent.event.dtcId.in((CollectionExpression)sq.list((Expression)QDtc.dtc.id)));
            }
            if (!Strings.isEmpty((String)criteria.getClientId())) {
                sq = (JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.clientId.eq((Object)criteria.getClientId())});
                expression = expression.and((Predicate)QEvent.event.dtcId.in((CollectionExpression)sq.list((Expression)QDtc.dtc.id)));
            } else if (!Strings.isEmpty((String)criteria.getClientName())) {
                expression = expression.and((Predicate)QEvent.event.clientName.lower().like(criteria.getClientName().toLowerCase()));
            }
            if (criteria.getState() != null) {
                expression = expression.and((Predicate)QEvent.event.value.eq(criteria.getState()));
            }
            if (criteria.getBegin() != null) {
                expression = expression.and((Predicate)QEvent.event.time.goe((Comparable)criteria.getBegin()));
            }
            if (criteria.getEnd() != null) {
                expression = expression.and((Predicate)QEvent.event.time.loe((Comparable)criteria.getEnd()));
            }
            searchParam = new SearchParam();
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block34;
            switch (criteria.getOrderBy()) {
                case "clientName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QEvent.event.clientName.asc() : QEvent.event.clientName.desc());
                    break;
                }
                case "dtcName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QEvent.event.dtcName.asc() : QEvent.event.dtcName.desc());
                    break;
                }
                case "serviceName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QEvent.event.serviceName.asc() : QEvent.event.serviceName.desc());
                    break;
                }
                case "profileName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QEvent.event.profileName.asc() : QEvent.event.profileName.desc());
                    break;
                }
                case "date": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QEvent.event.time.asc() : QEvent.event.time.desc());
                    break;
                }
                case "state": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QEvent.event.value.asc() : QEvent.event.value.desc());
                }
            }
        }
        return searchParam;
    }
}

