/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IDtcStateDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.DtcSyncStateDTO;
import pt.efacec.smartlighting.common.core.dto.DtcSyncStateSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcState;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QDtcState;
import pt.efacec.smartlighting.common.core.entity.QUser;
import pt.efacec.smartlighting.common.core.entity.User;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class DtcStateDAOBase
implements IDtcStateDAO {
    private static final Log logger = Log.getLogger(DtcStateDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from DtcState e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(DtcState entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public DtcState save(DtcState entity) {
        String temp = null;
        temp = entity.getLastChange();
        if (temp != null && temp.length() > 4000) {
            entity.setLastChange(temp.substring(0, 4000));
        }
        if ((temp = entity.getDtcName()) != null && temp.length() > 100) {
            entity.setDtcName(temp.substring(0, 100));
        }
        if ((temp = entity.getOperationalAreaId()) != null && temp.length() > 36) {
            entity.setOperationalAreaId(temp.substring(0, 36));
        }
        if ((temp = entity.getOperationalArea()) != null && temp.length() > 100) {
            entity.setOperationalArea(temp.substring(0, 100));
        }
        if ((temp = entity.getDistrictId()) != null && temp.length() > 36) {
            entity.setDistrictId(temp.substring(0, 36));
        }
        if ((temp = entity.getMunicipalityId()) != null && temp.length() > 36) {
            entity.setMunicipalityId(temp.substring(0, 36));
        }
        if ((temp = entity.getClientId()) != null && temp.length() > 36) {
            entity.setClientId(temp.substring(0, 36));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (DtcState)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public DtcState findPersisted(DtcState entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            DtcState persisted = (DtcState)this.em.find(DtcState.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public DtcState findById(String entityId) {
        return (DtcState)this.em.find(DtcState.class, (Object)entityId);
    }

    @Override
    public List<DtcState> findAll() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcState.dtcState})).list((Expression)QDtcState.dtcState);
    }

    @Override
    public void loadDtc(DtcState entity) {
        if (entity != null) {
            entity.setDtc(this.getDtc(entity.getId()));
        }
    }

    @Override
    public Dtc getDtc(String dtcId) {
        if (dtcId != null) {
            return (Dtc)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.id.eq((Object)dtcId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).uniqueResult((Expression)QDtc.dtc);
        }
        return null;
    }

    @Override
    public void loadSubmiter(DtcState entity) {
        if (entity != null) {
            entity.setSubmiter(this.getSubmiter(entity.getSubmiterId()));
        }
    }

    @Override
    public User getSubmiter(String userId) {
        if (userId != null) {
            return (User)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QUser.user})).where(new Predicate[]{QUser.user.id.eq((Object)userId).and((Predicate)QUser.user.deleted.eq((Object)"0"))})).uniqueResult((Expression)QUser.user);
        }
        return null;
    }

    @Override
    public List<DtcState> findAllBySubmiter(String userId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcState.dtcState})).where(new Predicate[]{userId == null ? QDtcState.dtcState.submiterId.isNull() : QDtcState.dtcState.submiterId.eq((Object)userId)})).list((Expression)QDtcState.dtcState);
    }

    @Override
    public DtcState markAsSynchronized(String dtcId) {
        try {
            return this.handleMarkAsSynchronized(dtcId);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing markAsSynchronized.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing markAsSynchronized.", e);
        }
    }

    protected abstract DtcState handleMarkAsSynchronized(String var1);

    @Override
    public DtcState markAsDirty(String dtcId) {
        try {
            return this.handleMarkAsDirty(dtcId);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing markAsDirty.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing markAsDirty.", e);
        }
    }

    protected abstract DtcState handleMarkAsDirty(String var1);

    @Override
    public void remove(String dtcStateId) {
        try {
            this.handleRemove(dtcStateId);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing remove.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing remove.", e);
        }
    }

    protected abstract void handleRemove(String var1);

    @Override
    public Page<DtcSyncStateDTO> searchSyncState(DtcSyncStateSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"DtcStateDAO.searchSyncState", "criteria"});
        }
        try {
            SearchParam searchParam = this.buildSearchSyncStateSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearchSyncState(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearchSyncState(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<DtcSyncStateDTO> list = this.queryForSearchSyncState(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing searchSyncState.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing searchSyncState.", e);
        }
    }

    protected JPAQuery createQueryForSearchSyncState(DtcSyncStateSearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcState.dtcState});
    }

    protected abstract List<DtcSyncStateDTO> queryForSearchSyncState(JPAQuery var1);

    protected abstract SearchParam buildSearchSyncStateSearchParam(DtcSyncStateSearchDTO var1);

    @Override
    public List<String> findIdsToSynchronize() {
        try {
            return this.handleFindIdsToSynchronize();
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing findIdsToSynchronize.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing findIdsToSynchronize.", e);
        }
    }

    protected abstract List<String> handleFindIdsToSynchronize();
}

