/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPASubQuery;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.DtcStateDAOBase;
import pt.efacec.smartlighting.business.misc.SLUtil;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.DtcSyncStateDTO;
import pt.efacec.smartlighting.common.core.dto.DtcSyncStateSearchDTO;
import pt.efacec.smartlighting.common.core.entity.DtcState;
import pt.efacec.smartlighting.common.core.entity.QDtcService;
import pt.efacec.smartlighting.common.core.entity.QDtcState;
import pt.efacec.smartlighting.common.core.lov.SynchronizationStateLOV;
import pt.efacec.smartlighting.common.util.Context;
import pt.efacec.toolkit.misc.Log;
import pt.efacec.toolkit.misc.Strings;

@Repository(value="dtcState")
public class DtcStateDAO
extends DtcStateDAOBase {
    private static final Log logger = Log.getLogger(DtcStateDAO.class);

    @Override
    protected DtcState handleMarkAsSynchronized(String dtcId) {
        DtcState state = this.findById(dtcId);
        if (state == null) {
            state = new DtcState();
            state.setId(dtcId);
        }
        state.setOperationTime(new Date());
        state.setState(SynchronizationStateLOV.UPDATED);
        return this.save(state);
    }

    @Override
    protected DtcState handleMarkAsDirty(String dtcId) {
        DtcState state = this.findById(dtcId);
        if (state == null) {
            state = new DtcState();
            state.setId(dtcId);
            logger.debug((Object)("creating state for dtcId " + dtcId));
        }
        state.setSubmiterId(Context.get().getUser().getId());
        state.setOperationTime(new Date());
        state.setState(SynchronizationStateLOV.PENDING);
        return this.save(state);
    }

    @Override
    protected void handleRemove(String dtcStateId) {
        new JPADeleteClause(this.em, (EntityPath)QDtcState.dtcState).where(new Predicate[]{QDtcState.dtcState.id.eq((Object)dtcStateId)});
    }

    @Override
    protected List<DtcSyncStateDTO> queryForSearchSyncState(JPAQuery query) {
        List result = query.list((Expression)QDtcState.dtcState);
        ArrayList<DtcSyncStateDTO> dtos = new ArrayList<DtcSyncStateDTO>();
        for (DtcState r : result) {
            dtos.add(new DtcSyncStateDTO(r.getState(), r.getId(), r.getDtcName(), r.getOperationalArea(), r.getOperationTime(), r.getErrorType()));
        }
        return dtos;
    }

    @Override
    protected SearchParam buildSearchSyncStateSearchParam(DtcSyncStateSearchDTO criteria) {
        SearchParam searchParam;
        block20: {
            searchParam = new SearchParam();
            BooleanExpression expression = null;
            if (!Strings.isEmpty((String)criteria.getDtcName())) {
                expression = SLUtil.and(expression, QDtcState.dtcState.dtcName.lower().like(criteria.getDtcName().toLowerCase()));
            }
            if (!Strings.isEmpty((String)criteria.getServiceName())) {
                JPASubQuery sq = (JPASubQuery)((JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtcService.dtcService})).where(new Predicate[]{QDtcService.dtcService.name.lower().like(criteria.getServiceName().toLowerCase()).and((Predicate)QDtcService.dtcService.dtcId.eq((Expression)QDtcState.dtcState.id))})).distinct();
                expression = SLUtil.and(expression, QDtcState.dtcState.id.in((CollectionExpression)sq.list((Expression)QDtcService.dtcService.dtcId)));
            }
            if (!Strings.isEmpty((String)criteria.getDistrictId())) {
                expression = SLUtil.and(expression, QDtcState.dtcState.districtId.eq((Object)criteria.getDistrictId()));
            }
            if (!Strings.isEmpty((String)criteria.getMunicipalityId())) {
                expression = SLUtil.and(expression, QDtcState.dtcState.municipalityId.eq((Object)criteria.getMunicipalityId()));
            }
            if (!Strings.isEmpty((String)criteria.getOperationalAreaId())) {
                expression = SLUtil.and(expression, QDtcState.dtcState.operationalAreaId.eq((Object)criteria.getOperationalAreaId()));
            }
            if (!Strings.isEmpty((String)criteria.getClientId())) {
                expression = SLUtil.and(expression, QDtcState.dtcState.clientId.eq((Object)criteria.getClientId()));
            }
            if (criteria.getState() != null) {
                expression = SLUtil.and(expression, QDtcState.dtcState.state.eq((Object)criteria.getState()));
            }
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block20;
            switch (criteria.getOrderBy()) {
                case "dtcName": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QDtcState.dtcState.dtcName.asc() : QDtcState.dtcState.dtcName.desc());
                    break;
                }
                case "operationalArea": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QDtcState.dtcState.operationalArea.asc() : QDtcState.dtcState.operationalArea.desc());
                    break;
                }
                case "dateTime": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QDtcState.dtcState.operationTime.asc() : QDtcState.dtcState.operationTime.desc());
                }
            }
        }
        return searchParam;
    }

    @Override
    protected List<String> handleFindIdsToSynchronize() {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcState.dtcState})).where(new Predicate[]{QDtcState.dtcState.state.in((Object[])new SynchronizationStateLOV[]{SynchronizationStateLOV.DIRTY, SynchronizationStateLOV.ERROR})})).list((Expression)QDtcState.dtcState.id);
    }
}

