/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IDtcServiceDAO;
import pt.efacec.smartlighting.common.core.dto.ServiceDTO;
import pt.efacec.smartlighting.common.core.entity.Alarm;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.Event;
import pt.efacec.smartlighting.common.core.entity.QAlarm;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QDtcService;
import pt.efacec.smartlighting.common.core.entity.QEvent;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatch;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.misc.Log;

public abstract class DtcServiceDAOBase
implements IDtcServiceDAO {
    private static final Log logger = Log.getLogger(DtcServiceDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from DtcService e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(DtcService entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public DtcService save(DtcService entity) {
        String temp = null;
        temp = entity.getDeleted();
        if (temp != null && temp.length() > 255) {
            entity.setDeleted(temp.substring(0, 255));
        }
        if ((temp = entity.getName()) != null && temp.length() > 255) {
            entity.setName(temp.substring(0, 255));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (DtcService)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public DtcService findPersisted(DtcService entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            DtcService persisted = (DtcService)this.em.find(DtcService.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public DtcService findById(String entityId) {
        return (DtcService)this.em.find(DtcService.class, (Object)entityId);
    }

    @Override
    public List<DtcService> findAll() {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcService.dtcService})).where(new Predicate[]{QDtcService.dtcService.deleted.eq((Object)"0")})).list((Expression)QDtcService.dtcService);
    }

    @Override
    public List<DtcService> findAllWithDeleted() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcService.dtcService})).list((Expression)QDtcService.dtcService);
    }

    @Override
    public DtcService findByNameAndDtc(String name, String dtcId) {
        return (DtcService)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcService.dtcService})).where(new Predicate[]{QDtcService.dtcService.name.eq((Object)name).and((Predicate)QDtcService.dtcService.dtcId.eq((Object)dtcId))})).uniqueResult((Expression)QDtcService.dtcService);
    }

    @Override
    public void loadDtc(DtcService entity) {
        if (entity != null) {
            entity.setDtc(this.getDtc(entity.getDtcId()));
        }
    }

    @Override
    public Dtc getDtc(String dtcId) {
        if (dtcId != null) {
            return (Dtc)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.id.eq((Object)dtcId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).uniqueResult((Expression)QDtc.dtc);
        }
        return null;
    }

    @Override
    public List<DtcService> findAllByDtc(String dtcId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcService.dtcService})).where(new Predicate[]{dtcId == null ? QDtcService.dtcService.dtcId.isNull() : QDtcService.dtcService.dtcId.eq((Object)dtcId).and((Predicate)QDtcService.dtcService.deleted.eq((Object)"0"))})).list((Expression)QDtcService.dtcService);
    }

    @Override
    public List<DtcService> findAllWithDeletedByDtc(String dtcId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcService.dtcService})).where(new Predicate[]{dtcId == null ? QDtcService.dtcService.dtcId.isNull() : QDtcService.dtcService.dtcId.eq((Object)dtcId)})).list((Expression)QDtcService.dtcService);
    }

    @Override
    public void loadEvents(DtcService entity) {
        if (entity != null && entity.getEvents() == null) {
            entity.setEvents(this.getEvents(entity.getId()));
        }
    }

    @Override
    public Set<Event> getEvents(String dtcServiceId) {
        if (dtcServiceId != null) {
            return new HashSet<Event>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QEvent.event})).where(new Predicate[]{QEvent.event.dtcServiceId.eq((Object)dtcServiceId)})).list((Expression)QEvent.event));
        }
        return new HashSet<Event>();
    }

    @Override
    public void loadAlarms(DtcService entity) {
        if (entity != null && entity.getAlarms() == null) {
            entity.setAlarms(this.getAlarms(entity.getId()));
        }
    }

    @Override
    public Set<Alarm> getAlarms(String dtcServiceId) {
        if (dtcServiceId != null) {
            return new HashSet<Alarm>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QAlarm.alarm})).where(new Predicate[]{QAlarm.alarm.serviceId.eq((Object)dtcServiceId)})).list((Expression)QAlarm.alarm));
        }
        return new HashSet<Alarm>();
    }

    @Override
    public void loadTimers(DtcService entity) {
        if (entity != null && entity.getTimers() == null) {
            entity.setTimers(this.getTimers(entity.getId()));
        }
    }

    @Override
    public Set<ServiceStopwatch> getTimers(String dtcServiceId) {
        if (dtcServiceId != null) {
            return new HashSet<ServiceStopwatch>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{QServiceStopwatch.serviceStopwatch.serviceId.eq((Object)dtcServiceId)})).list((Expression)QServiceStopwatch.serviceStopwatch));
        }
        return new HashSet<ServiceStopwatch>();
    }

    @Override
    public void remove(String serviceUid) {
        try {
            this.handleRemove(serviceUid);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing remove.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing remove.", e);
        }
    }

    protected abstract void handleRemove(String var1);

    @Override
    public ServiceDTO toServiceDTO(DtcService entity) {
        if (entity == null) {
            return null;
        }
        ServiceDTO bean = new ServiceDTO();
        bean.setName(entity.getName());
        return bean;
    }

    @Override
    public List<ServiceDTO> toServiceDTOCollection(List<DtcService> entities) {
        ArrayList<ServiceDTO> list = new ArrayList<ServiceDTO>();
        for (DtcService entity : entities) {
            list.add(this.toServiceDTO(entity));
        }
        return list;
    }

    @Override
    public DtcService fromServiceDTO(ServiceDTO bean) {
        if (bean == null) {
            return null;
        }
        DtcService entity = new DtcService();
        entity.setId(bean.getId());
        entity.setName(bean.getName());
        return entity;
    }

    @Override
    public List<DtcService> fromServiceDTOCollection(List<ServiceDTO> beans) {
        ArrayList<DtcService> list = new ArrayList<DtcService>();
        for (ServiceDTO bean : beans) {
            list.add(this.fromServiceDTO(bean));
        }
        return list;
    }
}

