/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPADeleteClause;
import com.mysema.query.jpa.impl.JPAUpdateClause;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.UUID;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.DtcServiceDAOBase;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.QAlarm;
import pt.efacec.smartlighting.common.core.entity.QDtcService;
import pt.efacec.smartlighting.common.core.entity.QEvent;
import pt.efacec.toolkit.misc.Tool;

@Repository(value="dtcService")
public class DtcServiceDAO
extends DtcServiceDAOBase {
    @Override
    public DtcService save(DtcService entity) {
        DtcService persisted;
        if (entity.getDeathDate() != null && "0".equals(entity.getDeleted())) {
            entity.setDeleted(UUID.randomUUID().toString());
        } else if (entity.getDeathDate() == null && !"0".equals(entity.getDeleted())) {
            entity.setDeleted("0");
        }
        if (entity.getVersion() != null && !Tool.similar((Object)(persisted = this.findPersisted(entity)).getName(), (Object)entity.getName())) {
            new JPAUpdateClause(this.em, (EntityPath)QEvent.event).set((Path)QEvent.event.serviceName, (Object)entity.getName()).where(new Predicate[]{QEvent.event.dtcServiceId.eq((Object)entity.getId())}).execute();
            new JPAUpdateClause(this.em, (EntityPath)QAlarm.alarm).set((Path)QAlarm.alarm.serviceName, (Object)entity.getName()).where(new Predicate[]{QAlarm.alarm.serviceId.eq((Object)entity.getId())}).execute();
        }
        return super.save(entity);
    }

    @Override
    protected void handleRemove(String serviceUid) {
        new JPADeleteClause(this.em, (EntityPath)QDtcService.dtcService).where(new Predicate[]{QDtcService.dtcService.name.eq((Object)serviceUid)});
    }
}

