/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import pt.efacec.smartlighting.business.core.entitydao.IDtcDAO;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.ClientDtcSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcAssociationSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcClientAssociationSearchDTO;
import pt.efacec.smartlighting.common.core.dto.ProfileChildSearchDTO;
import pt.efacec.smartlighting.common.core.dto.RtuDTO;
import pt.efacec.smartlighting.common.core.entity.Alarm;
import pt.efacec.smartlighting.common.core.entity.ClientEntity;
import pt.efacec.smartlighting.common.core.entity.District;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.DtcService;
import pt.efacec.smartlighting.common.core.entity.DtcState;
import pt.efacec.smartlighting.common.core.entity.Event;
import pt.efacec.smartlighting.common.core.entity.Municipality;
import pt.efacec.smartlighting.common.core.entity.OperationalArea;
import pt.efacec.smartlighting.common.core.entity.Profile;
import pt.efacec.smartlighting.common.core.entity.QAlarm;
import pt.efacec.smartlighting.common.core.entity.QClientEntity;
import pt.efacec.smartlighting.common.core.entity.QDistrict;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QDtcService;
import pt.efacec.smartlighting.common.core.entity.QDtcState;
import pt.efacec.smartlighting.common.core.entity.QEvent;
import pt.efacec.smartlighting.common.core.entity.QMunicipality;
import pt.efacec.smartlighting.common.core.entity.QOperationalArea;
import pt.efacec.smartlighting.common.core.entity.QProfile;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.QSpecialDay;
import pt.efacec.smartlighting.common.core.entity.QTimetable;
import pt.efacec.smartlighting.common.core.entity.ServiceStopwatch;
import pt.efacec.smartlighting.common.core.entity.SpecialDay;
import pt.efacec.smartlighting.common.core.entity.Timetable;
import pt.efacec.smartlighting.common.exception.BusinessCodedException;
import pt.efacec.smartlighting.common.exception.BusinessException;
import pt.efacec.toolkit.dao.Page;
import pt.efacec.toolkit.misc.Log;

public abstract class DtcDAOBase
implements IDtcDAO {
    private static final Log logger = Log.getLogger(DtcDAOBase.class);
    @PersistenceContext
    protected EntityManager em;

    @Override
    public int removeByIdAndVersion(String id, Integer version) {
        Query q = this.em.createQuery("delete from Dtc e where e.id = :id and e.version = :ver");
        q.setParameter("id", (Object)id);
        q.setParameter("ver", (Object)version);
        return q.executeUpdate();
    }

    @Override
    public void remove(Dtc entity) {
        this.em.remove((Object)entity);
        this.em.flush();
    }

    @Override
    public Dtc save(Dtc entity) {
        String temp = null;
        temp = entity.getDeleted();
        if (temp != null && temp.length() > 255) {
            entity.setDeleted(temp.substring(0, 255));
        }
        if ((temp = entity.getRtuuid()) != null && temp.length() > 50) {
            entity.setRtuuid(temp.substring(0, 50));
        }
        if ((temp = entity.getName()) != null && temp.length() > 100) {
            entity.setName(temp.substring(0, 100));
        }
        if ((temp = entity.getSecundarySubstation()) != null && temp.length() > 16) {
            entity.setSecundarySubstation(temp.substring(0, 16));
        }
        if ((temp = entity.getIpAddress()) != null && temp.length() > 15) {
            entity.setIpAddress(temp.substring(0, 15));
        }
        if (entity.getVersion() == null) {
            if (entity.getId() == null) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.em.persist((Object)entity);
        } else {
            entity = (Dtc)this.em.merge((Object)entity);
        }
        this.em.flush();
        return entity;
    }

    @Override
    public Dtc findPersisted(Dtc entity) {
        if (entity.getVersion() != null) {
            this.em.detach((Object)entity);
            Dtc persisted = (Dtc)this.em.find(Dtc.class, (Object)entity.getId());
            this.em.detach((Object)persisted);
            this.em.merge((Object)entity);
            return persisted;
        }
        return null;
    }

    @Override
    public Dtc findById(String entityId) {
        return (Dtc)this.em.find(Dtc.class, (Object)entityId);
    }

    @Override
    public List<Dtc> findAll() {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.deleted.eq((Object)"0")})).list((Expression)QDtc.dtc);
    }

    @Override
    public List<Dtc> findAllWithDeleted() {
        return ((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).list((Expression)QDtc.dtc);
    }

    @Override
    public Dtc findByRtuuid(String rtuuid) {
        return (Dtc)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.rtuuid.eq((Object)rtuuid)})).uniqueResult((Expression)QDtc.dtc);
    }

    @Override
    public Dtc findByTag(String name) {
        return (Dtc)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.name.eq((Object)name).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).uniqueResult((Expression)QDtc.dtc);
    }

    @Override
    public void loadOperationalArea(Dtc entity) {
        if (entity != null) {
            entity.setOperationalArea(this.getOperationalArea(entity.getOperationalAreaId()));
        }
    }

    @Override
    public OperationalArea getOperationalArea(String operationalAreaId) {
        if (operationalAreaId != null) {
            return (OperationalArea)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QOperationalArea.operationalArea})).where(new Predicate[]{QOperationalArea.operationalArea.id.eq((Object)operationalAreaId)})).uniqueResult((Expression)QOperationalArea.operationalArea);
        }
        return null;
    }

    @Override
    public List<Dtc> findAllByOperationalArea(String operationalAreaId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{operationalAreaId == null ? QDtc.dtc.operationalAreaId.isNull() : QDtc.dtc.operationalAreaId.eq((Object)operationalAreaId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc);
    }

    @Override
    public List<Dtc> findAllWithDeletedByOperationalArea(String operationalAreaId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{operationalAreaId == null ? QDtc.dtc.operationalAreaId.isNull() : QDtc.dtc.operationalAreaId.eq((Object)operationalAreaId)})).list((Expression)QDtc.dtc);
    }

    @Override
    public void loadClient(Dtc entity) {
        if (entity != null) {
            entity.setClient(this.getClient(entity.getClientId()));
        }
    }

    @Override
    public ClientEntity getClient(String clientEntityId) {
        if (clientEntityId != null) {
            return (ClientEntity)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QClientEntity.clientEntity})).where(new Predicate[]{QClientEntity.clientEntity.id.eq((Object)clientEntityId)})).uniqueResult((Expression)QClientEntity.clientEntity);
        }
        return null;
    }

    @Override
    public List<Dtc> findAllByClient(String clientEntityId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{clientEntityId == null ? QDtc.dtc.clientId.isNull() : QDtc.dtc.clientId.eq((Object)clientEntityId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc);
    }

    @Override
    public List<Dtc> findAllWithDeletedByClient(String clientEntityId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{clientEntityId == null ? QDtc.dtc.clientId.isNull() : QDtc.dtc.clientId.eq((Object)clientEntityId)})).list((Expression)QDtc.dtc);
    }

    @Override
    public void loadDistrict(Dtc entity) {
        if (entity != null) {
            entity.setDistrict(this.getDistrict(entity.getDistrictId()));
        }
    }

    @Override
    public District getDistrict(String districtId) {
        if (districtId != null) {
            return (District)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDistrict.district})).where(new Predicate[]{QDistrict.district.id.eq((Object)districtId)})).uniqueResult((Expression)QDistrict.district);
        }
        return null;
    }

    @Override
    public List<Dtc> findAllByDistrict(String districtId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{districtId == null ? QDtc.dtc.districtId.isNull() : QDtc.dtc.districtId.eq((Object)districtId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc);
    }

    @Override
    public List<Dtc> findAllWithDeletedByDistrict(String districtId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{districtId == null ? QDtc.dtc.districtId.isNull() : QDtc.dtc.districtId.eq((Object)districtId)})).list((Expression)QDtc.dtc);
    }

    @Override
    public void loadMunicipality(Dtc entity) {
        if (entity != null) {
            entity.setMunicipality(this.getMunicipality(entity.getMunicipalityId()));
        }
    }

    @Override
    public Municipality getMunicipality(String municipalityId) {
        if (municipalityId != null) {
            return (Municipality)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QMunicipality.municipality})).where(new Predicate[]{QMunicipality.municipality.id.eq((Object)municipalityId)})).uniqueResult((Expression)QMunicipality.municipality);
        }
        return null;
    }

    @Override
    public List<Dtc> findAllByMunicipality(String municipalityId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{municipalityId == null ? QDtc.dtc.municipalityId.isNull() : QDtc.dtc.municipalityId.eq((Object)municipalityId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc);
    }

    @Override
    public List<Dtc> findAllWithDeletedByMunicipality(String municipalityId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{municipalityId == null ? QDtc.dtc.municipalityId.isNull() : QDtc.dtc.municipalityId.eq((Object)municipalityId)})).list((Expression)QDtc.dtc);
    }

    @Override
    public void loadState(Dtc entity) {
        if (entity != null) {
            entity.setState(this.getState(entity.getId()));
        }
    }

    @Override
    public DtcState getState(String dtcStateId) {
        if (dtcStateId != null) {
            return (DtcState)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcState.dtcState})).where(new Predicate[]{QDtcState.dtcState.id.eq((Object)dtcStateId)})).uniqueResult((Expression)QDtcState.dtcState);
        }
        return null;
    }

    @Override
    public void loadTimetable(Dtc entity) {
        if (entity != null) {
            entity.setTimetable(this.getTimetable(entity.getTimetableId()));
        }
    }

    @Override
    public Timetable getTimetable(String timetableId) {
        if (timetableId != null) {
            return (Timetable)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QTimetable.timetable})).where(new Predicate[]{QTimetable.timetable.id.eq((Object)timetableId)})).uniqueResult((Expression)QTimetable.timetable);
        }
        return null;
    }

    @Override
    public List<Dtc> findAllByTimetable(String timetableId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{timetableId == null ? QDtc.dtc.timetableId.isNull() : QDtc.dtc.timetableId.eq((Object)timetableId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc);
    }

    @Override
    public List<Dtc> findAllWithDeletedByTimetable(String timetableId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{timetableId == null ? QDtc.dtc.timetableId.isNull() : QDtc.dtc.timetableId.eq((Object)timetableId)})).list((Expression)QDtc.dtc);
    }

    @Override
    public void loadProfile(Dtc entity) {
        if (entity != null) {
            entity.setProfile(this.getProfile(entity.getProfileId()));
        }
    }

    @Override
    public Profile getProfile(String profileId) {
        if (profileId != null) {
            return (Profile)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QProfile.profile})).where(new Predicate[]{QProfile.profile.id.eq((Object)profileId)})).uniqueResult((Expression)QProfile.profile);
        }
        return null;
    }

    @Override
    public List<Dtc> findAllByProfile(String profileId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{profileId == null ? QDtc.dtc.profileId.isNull() : QDtc.dtc.profileId.eq((Object)profileId).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).list((Expression)QDtc.dtc);
    }

    @Override
    public List<Dtc> findAllWithDeletedByProfile(String profileId) {
        return ((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{profileId == null ? QDtc.dtc.profileId.isNull() : QDtc.dtc.profileId.eq((Object)profileId)})).list((Expression)QDtc.dtc);
    }

    @Override
    public void loadAlarm(Dtc entity) {
        if (entity != null && entity.getAlarm() == null) {
            entity.setAlarm(this.getAlarm(entity.getId()));
        }
    }

    @Override
    public Set<Alarm> getAlarm(String dtcId) {
        if (dtcId != null) {
            return new HashSet<Alarm>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QAlarm.alarm})).where(new Predicate[]{QAlarm.alarm.dtcId.eq((Object)dtcId)})).list((Expression)QAlarm.alarm));
        }
        return new HashSet<Alarm>();
    }

    @Override
    public void loadEvents(Dtc entity) {
        if (entity != null && entity.getEvents() == null) {
            entity.setEvents(this.getEvents(entity.getId()));
        }
    }

    @Override
    public Set<Event> getEvents(String dtcId) {
        if (dtcId != null) {
            return new HashSet<Event>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QEvent.event})).where(new Predicate[]{QEvent.event.dtcId.eq((Object)dtcId)})).list((Expression)QEvent.event));
        }
        return new HashSet<Event>();
    }

    @Override
    public void loadServices(Dtc entity) {
        if (entity != null && entity.getServices() == null) {
            entity.setServices(this.getServices(entity.getId()));
        }
    }

    @Override
    public Set<DtcService> getServices(String dtcId) {
        if (dtcId != null) {
            return new HashSet<DtcService>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtcService.dtcService})).where(new Predicate[]{QDtcService.dtcService.dtcId.eq((Object)dtcId).and((Predicate)QDtcService.dtcService.deleted.eq((Object)"0"))})).list((Expression)QDtcService.dtcService));
        }
        return new HashSet<DtcService>();
    }

    @Override
    public void loadSpecialDays(Dtc entity) {
        if (entity != null && entity.getSpecialDays() == null) {
            entity.setSpecialDays(this.getSpecialDays(entity.getId()));
        }
    }

    @Override
    public Set<SpecialDay> getSpecialDays(String dtcId) {
        if (dtcId != null) {
            return new HashSet<SpecialDay>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QSpecialDay.specialDay})).where(new Predicate[]{QSpecialDay.specialDay.dtcId.eq((Object)dtcId)})).list((Expression)QSpecialDay.specialDay));
        }
        return new HashSet<SpecialDay>();
    }

    @Override
    public void loadTimers(Dtc entity) {
        if (entity != null && entity.getTimers() == null) {
            entity.setTimers(this.getTimers(entity.getId()));
        }
    }

    @Override
    public Set<ServiceStopwatch> getTimers(String dtcId) {
        if (dtcId != null) {
            return new HashSet<ServiceStopwatch>(((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QServiceStopwatch.serviceStopwatch})).where(new Predicate[]{QServiceStopwatch.serviceStopwatch.dtcId.eq((Object)dtcId)})).list((Expression)QServiceStopwatch.serviceStopwatch));
        }
        return new HashSet<ServiceStopwatch>();
    }

    @Override
    public Page<Dtc> search(ProfileChildSearchDTO criteria) {
        if (criteria == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"DtcDAO.search", "criteria"});
        }
        try {
            SearchParam searchParam = this.buildSearchSearchParam(criteria);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearch(criteria);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearch(criteria);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<Dtc> list = this.queryForSearch(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing search.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing search.", e);
        }
    }

    protected JPAQuery createQueryForSearch(ProfileChildSearchDTO criteria) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc});
    }

    protected List<Dtc> queryForSearch(JPAQuery query) {
        return query.list((Expression)QDtc.dtc);
    }

    protected abstract SearchParam buildSearchSearchParam(ProfileChildSearchDTO var1);

    @Override
    public Page<Dtc> searchAssociated(DtcAssociationSearchDTO criteria, String operationalAreaId) {
        if (operationalAreaId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"DtcDAO.searchAssociated", "operationalAreaId"});
        }
        try {
            SearchParam searchParam = this.buildSearchAssociatedSearchParam(criteria, operationalAreaId);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearchAssociated(criteria, operationalAreaId);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearchAssociated(criteria, operationalAreaId);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<Dtc> list = this.queryForSearchAssociated(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing searchAssociated.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing searchAssociated.", e);
        }
    }

    protected JPAQuery createQueryForSearchAssociated(DtcAssociationSearchDTO criteria, String operationalAreaId) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc});
    }

    protected List<Dtc> queryForSearchAssociated(JPAQuery query) {
        return query.list((Expression)QDtc.dtc);
    }

    protected abstract SearchParam buildSearchAssociatedSearchParam(DtcAssociationSearchDTO var1, String var2);

    @Override
    public Page<Dtc> searchAssociatedForClient(DtcClientAssociationSearchDTO criteria, String operationalAreaId) {
        if (operationalAreaId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"DtcDAO.searchAssociatedForClient", "operationalAreaId"});
        }
        try {
            SearchParam searchParam = this.buildSearchAssociatedForClientSearchParam(criteria, operationalAreaId);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearchAssociatedForClient(criteria, operationalAreaId);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearchAssociatedForClient(criteria, operationalAreaId);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<Dtc> list = this.queryForSearchAssociatedForClient(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing searchAssociatedForClient.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing searchAssociatedForClient.", e);
        }
    }

    protected JPAQuery createQueryForSearchAssociatedForClient(DtcClientAssociationSearchDTO criteria, String operationalAreaId) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc});
    }

    protected List<Dtc> queryForSearchAssociatedForClient(JPAQuery query) {
        return query.list((Expression)QDtc.dtc);
    }

    protected abstract SearchParam buildSearchAssociatedForClientSearchParam(DtcClientAssociationSearchDTO var1, String var2);

    @Override
    public Page<Dtc> searchForClient(ClientDtcSearchDTO criteria, String operationalAreaId) {
        try {
            SearchParam searchParam = this.buildSearchForClientSearchParam(criteria, operationalAreaId);
            Page page = new Page();
            if (criteria.getCountRecords().booleanValue()) {
                JPAQuery queryCount = this.createQueryForSearchForClient(criteria, operationalAreaId);
                if (searchParam.getPredicate() != null) {
                    queryCount.where(new Predicate[]{searchParam.getPredicate()});
                }
                page.setCount(queryCount.count());
            } else {
                JPAQuery query = this.createQueryForSearchForClient(criteria, operationalAreaId);
                if (searchParam.getPredicate() != null) {
                    query.where(new Predicate[]{searchParam.getPredicate()});
                }
                if (criteria.getFirstRecord() != null && criteria.getFirstRecord() > 1L) {
                    query.offset(criteria.getFirstRecord().longValue());
                }
                if (criteria.getMaxResult() != null) {
                    query.limit(criteria.getMaxResult() + 1L);
                }
                if (searchParam.getOrderSpecifier() != null) {
                    query.orderBy(new OrderSpecifier[]{searchParam.getOrderSpecifier()});
                }
                List<Dtc> list = this.queryForSearchForClient(query);
                if (criteria.getMaxResult() != null) {
                    page.setLast((long)list.size() <= criteria.getMaxResult());
                } else {
                    page.setLast(true);
                }
                if (!page.isLast()) {
                    list.remove(list.size() - 1);
                }
                page.setResults(list);
            }
            return page;
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing searchForClient.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing searchForClient.", e);
        }
    }

    protected JPAQuery createQueryForSearchForClient(ClientDtcSearchDTO criteria, String operationalAreaId) {
        return (JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc});
    }

    protected List<Dtc> queryForSearchForClient(JPAQuery query) {
        return query.list((Expression)QDtc.dtc);
    }

    protected abstract SearchParam buildSearchForClientSearchParam(ClientDtcSearchDTO var1, String var2);

    @Override
    public List<String> findClientIdsNotInOperationalArea(String operationalAreaId) {
        if (operationalAreaId == null) {
            throw new BusinessCodedException("business.method.null.parameter", new Object[]{"DtcDAO.findClientIdsNotInOperationalArea", "operationalAreaId"});
        }
        try {
            return this.handleFindClientIdsNotInOperationalArea(operationalAreaId);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn("An error ocurred when executing findClientIdsNotInOperationalArea.", (Throwable)e);
            throw new RuntimeException("An error ocurred when executing findClientIdsNotInOperationalArea.", e);
        }
    }

    protected abstract List<String> handleFindClientIdsNotInOperationalArea(String var1);

    @Override
    public RtuDTO toRtuDTO(Dtc entity) {
        if (entity == null) {
            return null;
        }
        RtuDTO bean = new RtuDTO();
        bean.setBirthDate(entity.getBirthDate());
        bean.setDeathDate(entity.getDeathDate());
        bean.setRtuuid(entity.getRtuuid());
        bean.setName(entity.getName());
        bean.setSecundarySubstation(entity.getSecundarySubstation());
        bean.setLatitude(entity.getLatitude());
        bean.setLongitude(entity.getLongitude());
        bean.setHasPhotocell(entity.getHasPhotocell());
        bean.setIpAddress(entity.getIpAddress());
        bean.setOperationalAreaId(entity.getOperationalAreaId());
        bean.setClientId(entity.getClientId());
        bean.setDistrictId(entity.getDistrictId());
        bean.setMunicipalityId(entity.getMunicipalityId());
        return bean;
    }

    @Override
    public List<RtuDTO> toRtuDTOCollection(List<Dtc> entities) {
        ArrayList<RtuDTO> list = new ArrayList<RtuDTO>();
        for (Dtc entity : entities) {
            list.add(this.toRtuDTO(entity));
        }
        return list;
    }

    @Override
    public Dtc fromRtuDTO(RtuDTO bean) {
        if (bean == null) {
            return null;
        }
        Dtc entity = new Dtc();
        entity.setBirthDate(bean.getBirthDate());
        entity.setDeathDate(bean.getDeathDate());
        entity.setRtuuid(bean.getRtuuid());
        entity.setName(bean.getName());
        entity.setSecundarySubstation(bean.getSecundarySubstation());
        entity.setLatitude(bean.getLatitude());
        entity.setLongitude(bean.getLongitude());
        entity.setHasPhotocell(bean.getHasPhotocell());
        entity.setIpAddress(bean.getIpAddress());
        entity.setOperationalAreaId(bean.getOperationalAreaId());
        entity.setClientId(bean.getClientId());
        entity.setDistrictId(bean.getDistrictId());
        entity.setMunicipalityId(bean.getMunicipalityId());
        return entity;
    }

    @Override
    public List<Dtc> fromRtuDTOCollection(List<RtuDTO> beans) {
        ArrayList<Dtc> list = new ArrayList<Dtc>();
        for (RtuDTO bean : beans) {
            list.add(this.fromRtuDTO(bean));
        }
        return list;
    }
}

