/*
 * Decompiled with CFR 0.152.
 */
package pt.efacec.smartlighting.business.core.entitydao;

import com.mysema.query.jpa.impl.JPAQuery;
import com.mysema.query.jpa.impl.JPASubQuery;
import com.mysema.query.jpa.impl.JPAUpdateClause;
import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import pt.efacec.smartlighting.business.core.entitydao.DtcDAOBase;
import pt.efacec.smartlighting.business.misc.SearchParam;
import pt.efacec.smartlighting.common.core.dto.ClientDtcSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcAssociationSearchDTO;
import pt.efacec.smartlighting.common.core.dto.DtcClientAssociationSearchDTO;
import pt.efacec.smartlighting.common.core.dto.PageDTO;
import pt.efacec.smartlighting.common.core.dto.ProfileChildSearchDTO;
import pt.efacec.smartlighting.common.core.entity.Dtc;
import pt.efacec.smartlighting.common.core.entity.QAlarm;
import pt.efacec.smartlighting.common.core.entity.QDtc;
import pt.efacec.smartlighting.common.core.entity.QDtcService;
import pt.efacec.smartlighting.common.core.entity.QDtcState;
import pt.efacec.smartlighting.common.core.entity.QEvent;
import pt.efacec.smartlighting.common.core.entity.QServiceStopwatch;
import pt.efacec.smartlighting.common.core.service.IDtcManagementService;
import pt.efacec.toolkit.misc.Strings;
import pt.efacec.toolkit.misc.Tool;

@Repository(value="dtc")
public class DtcDAO
extends DtcDAOBase {
    @Autowired
    private IDtcManagementService dtcMangementService;

    @Override
    protected SearchParam buildSearchSearchParam(ProfileChildSearchDTO criteria) {
        SearchParam searchParam;
        block8: {
            searchParam = new SearchParam();
            BooleanExpression expression = QDtc.dtc.deleted.eq((Object)"0");
            if (!Strings.isEmpty((String)criteria.getProfileId())) {
                expression = expression.and((Predicate)QDtc.dtc.profileId.eq((Object)criteria.getProfileId()));
            }
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block8;
            switch (criteria.getOrderBy()) {
                case "name": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QDtc.dtc.name.asc() : QDtc.dtc.name.desc());
                }
            }
        }
        return searchParam;
    }

    @Override
    protected SearchParam buildSearchAssociatedSearchParam(DtcAssociationSearchDTO criteria, String operationalAreaId) {
        SearchParam searchParam = this.prepareSearchForAssociated((PageDTO)criteria, operationalAreaId, criteria.getName(), criteria.getDistrictId(), criteria.getMunicipalityId());
        if (Boolean.TRUE.equals(criteria.getNotAssociated())) {
            searchParam.setPredicate(searchParam.getPredicate().and((Predicate)QDtc.dtc.profileId.isNull()));
        }
        return searchParam;
    }

    @Override
    protected SearchParam buildSearchAssociatedForClientSearchParam(DtcClientAssociationSearchDTO criteria, String operationalAreaId) {
        SearchParam searchParam = this.prepareSearchForAssociated((PageDTO)criteria, operationalAreaId, criteria.getName(), criteria.getDistrictId(), criteria.getMunicipalityId());
        if (Boolean.TRUE.equals(criteria.getNotAssociated())) {
            searchParam.setPredicate(searchParam.getPredicate().and((Predicate)QDtc.dtc.clientId.isNull()));
        }
        return searchParam;
    }

    private SearchParam prepareSearchForAssociated(PageDTO page, String operationalAreaId, String name, String districtId, String municipalityId) {
        SearchParam searchParam;
        block10: {
            searchParam = new SearchParam();
            BooleanExpression expression = QDtc.dtc.operationalAreaId.eq((Object)operationalAreaId);
            if (!Strings.isEmpty((String)name)) {
                expression = expression.and((Predicate)QDtc.dtc.name.upper().like(name.toUpperCase()));
            }
            if (districtId != null) {
                expression = expression.and((Predicate)QDtc.dtc.districtId.eq((Object)districtId));
            }
            if (municipalityId != null) {
                expression = expression.and((Predicate)QDtc.dtc.municipalityId.eq((Object)municipalityId));
            }
            expression = expression.and((Predicate)QDtc.dtc.deleted.eq((Object)"0"));
            searchParam.setPredicate(expression);
            if (page.getOrderBy() == null) break block10;
            switch (page.getOrderBy()) {
                case "name": {
                    searchParam.setOrderSpecifier(page.getOrderAscending() != false ? QDtc.dtc.name.asc() : QDtc.dtc.name.desc());
                }
            }
        }
        return searchParam;
    }

    @Override
    protected SearchParam buildSearchForClientSearchParam(ClientDtcSearchDTO criteria, String operationalAreaId) {
        SearchParam searchParam;
        block12: {
            searchParam = new SearchParam();
            BooleanExpression expression = QDtc.dtc.clientId.eq((Object)criteria.getClientId());
            if (operationalAreaId != null) {
                expression = expression.and((Predicate)QDtc.dtc.operationalAreaId.eq((Object)operationalAreaId));
            }
            if (!Strings.isEmpty((String)criteria.getDtcName())) {
                expression = expression.and((Predicate)QDtc.dtc.name.upper().like(criteria.getDtcName().toUpperCase()));
            }
            if (criteria.getDistrictId() != null) {
                expression = expression.and((Predicate)QDtc.dtc.districtId.eq((Object)criteria.getDistrictId()));
            }
            if (criteria.getMunicipalityId() != null) {
                expression = expression.and((Predicate)QDtc.dtc.municipalityId.eq((Object)criteria.getMunicipalityId()));
            }
            if (!Strings.isEmpty((String)criteria.getServiceName())) {
                JPASubQuery sq = (JPASubQuery)((JPASubQuery)((JPASubQuery)new JPASubQuery().from(new EntityPath[]{QDtcService.dtcService})).where(new Predicate[]{QDtcService.dtcService.name.lower().like(criteria.getServiceName().toLowerCase()).and((Predicate)QDtcService.dtcService.dtcId.eq((Expression)QDtc.dtc.id))})).distinct();
                expression = expression.and((Predicate)QDtc.dtc.id.in((CollectionExpression)sq.list((Expression)QDtcService.dtcService.dtcId)));
            }
            expression = expression.and((Predicate)QDtc.dtc.deleted.eq((Object)"0"));
            searchParam.setPredicate(expression);
            if (criteria.getOrderBy() == null) break block12;
            switch (criteria.getOrderBy()) {
                case "name": {
                    searchParam.setOrderSpecifier(criteria.getOrderAscending() != false ? QDtc.dtc.name.asc() : QDtc.dtc.name.desc());
                }
            }
        }
        return searchParam;
    }

    @Override
    protected List<String> handleFindClientIdsNotInOperationalArea(String operationalAreaId) {
        List clientIds = ((JPAQuery)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.clientId.isNotNull().and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).distinct()).list((Expression)QDtc.dtc.clientId);
        List clientsForOA = ((JPAQuery)((JPAQuery)((JPAQuery)new JPAQuery(this.em).from(new EntityPath[]{QDtc.dtc})).where(new Predicate[]{QDtc.dtc.operationalAreaId.eq((Object)operationalAreaId).and((Predicate)QDtc.dtc.clientId.isNotNull()).and((Predicate)QDtc.dtc.deleted.eq((Object)"0"))})).distinct()).list((Expression)QDtc.dtc.clientId);
        clientIds.removeAll(clientsForOA);
        return clientIds;
    }

    @Override
    public Dtc save(Dtc entity) {
        boolean changed = false;
        Dtc persisted = null;
        if (entity.getVersion() != null) {
            persisted = this.findPersisted(entity);
            boolean bl = changed = !Tool.similar((Object)persisted.getProfileId(), (Object)entity.getProfileId()) || !Tool.similar((Object)persisted.getTimetableId(), (Object)entity.getTimetableId());
        }
        if (entity.getDeathDate() != null && "0".equals(entity.getDeleted())) {
            entity.setDeleted(UUID.randomUUID().toString());
        } else if (entity.getDeathDate() == null && !"0".equals(entity.getDeleted())) {
            entity.setDeleted("0");
        }
        Dtc e = super.save(entity);
        if (persisted != null) {
            JPAUpdateClause dtcStateUpdate = null;
            if (!Tool.similar((Object)persisted.getClientId(), (Object)entity.getClientId())) {
                dtcStateUpdate = new JPAUpdateClause(this.em, (EntityPath)QDtcState.dtcState).set((Path)QDtcState.dtcState.clientId, (Object)e.getClientId());
            }
            if (!persisted.getName().equals(e.getName())) {
                new JPAUpdateClause(this.em, (EntityPath)QServiceStopwatch.serviceStopwatch).set((Path)QServiceStopwatch.serviceStopwatch.dtcName, (Object)e.getName()).where(new Predicate[]{QServiceStopwatch.serviceStopwatch.dtcId.eq((Object)e.getId())}).execute();
                new JPAUpdateClause(this.em, (EntityPath)QEvent.event).set((Path)QEvent.event.dtcName, (Object)e.getName()).where(new Predicate[]{QEvent.event.dtcId.eq((Object)e.getId())}).execute();
                new JPAUpdateClause(this.em, (EntityPath)QAlarm.alarm).set((Path)QAlarm.alarm.dtcName, (Object)e.getName()).where(new Predicate[]{QAlarm.alarm.dtcId.eq((Object)e.getId())}).execute();
                if (dtcStateUpdate == null) {
                    dtcStateUpdate = new JPAUpdateClause(this.em, (EntityPath)QDtcState.dtcState);
                }
                dtcStateUpdate.set((Path)QDtcState.dtcState.dtcName, (Object)e.getName());
            }
            if (dtcStateUpdate != null) {
                dtcStateUpdate.where(new Predicate[]{QDtcState.dtcState.id.eq((Object)e.getId())}).execute();
            }
        }
        if (changed) {
            this.dtcMangementService.synchronizeOneDTC(entity.getId());
        }
        return e;
    }
}

